% Providers - Lists the IDs of the various providers used by site settings
%
% Providers Properties:
%    storage   
%    compute   
%    changeLog 
%    jobLogs   
%    accessLog 
%
% Providers Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Providers < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'storage', 'compute', 'changeLog', 'jobLogs', 'accessLog' }, ...
            { 'storage', 'compute', 'change_log', 'job_logs', 'access_log' });
    end
    properties(Dependent)
        storage
        compute
        changeLog
        jobLogs
        accessLog
    end
    methods
        function obj = Providers(varargin)
            obj@flywheel.ModelBase(flywheel.model.Providers.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'storage', []);
                addParameter(p, 'compute', []);
                addParameter(p, 'changeLog', []);
                addParameter(p, 'jobLogs', []);
                addParameter(p, 'accessLog', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.storage)
                    obj.props_('storage') = p.Results.storage;
                end
                if ~isempty(p.Results.compute)
                    obj.props_('compute') = p.Results.compute;
                end
                if ~isempty(p.Results.changeLog)
                    obj.props_('change_log') = p.Results.changeLog;
                end
                if ~isempty(p.Results.jobLogs)
                    obj.props_('job_logs') = p.Results.jobLogs;
                end
                if ~isempty(p.Results.accessLog)
                    obj.props_('access_log') = p.Results.accessLog;
                end
            end
        end
        function result = get.storage(obj)
            if ismethod(obj, 'get_storage')
                result = obj.get_storage();
            else
                if isKey(obj.props_, 'storage')
                    result = obj.props_('storage');
                else
                    result = [];
                end
            end
        end
        function obj = set.storage(obj, value)
            obj.props_('storage') = value;
        end
        function result = get.compute(obj)
            if ismethod(obj, 'get_compute')
                result = obj.get_compute();
            else
                if isKey(obj.props_, 'compute')
                    result = obj.props_('compute');
                else
                    result = [];
                end
            end
        end
        function obj = set.compute(obj, value)
            obj.props_('compute') = value;
        end
        function result = get.changeLog(obj)
            if ismethod(obj, 'get_changeLog')
                result = obj.get_changeLog();
            else
                if isKey(obj.props_, 'change_log')
                    result = obj.props_('change_log');
                else
                    result = [];
                end
            end
        end
        function obj = set.changeLog(obj, value)
            obj.props_('change_log') = value;
        end
        function result = get.jobLogs(obj)
            if ismethod(obj, 'get_jobLogs')
                result = obj.get_jobLogs();
            else
                if isKey(obj.props_, 'job_logs')
                    result = obj.props_('job_logs');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobLogs(obj, value)
            obj.props_('job_logs') = value;
        end
        function result = get.accessLog(obj)
            if ismethod(obj, 'get_accessLog')
                result = obj.get_accessLog();
            else
                if isKey(obj.props_, 'access_log')
                    result = obj.props_('access_log');
                else
                    result = [];
                end
            end
        end
        function obj = set.accessLog(obj, value)
            obj.props_('access_log') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'storage')
                result('storage') = flywheel.ModelBase.serializeValue(obj.props_('storage'), 'char');
            end
            if isKey(obj.props_, 'compute')
                result('compute') = flywheel.ModelBase.serializeValue(obj.props_('compute'), 'char');
            end
            if isKey(obj.props_, 'change_log')
                result('change_log') = flywheel.ModelBase.serializeValue(obj.props_('change_log'), 'char');
            end
            if isKey(obj.props_, 'job_logs')
                result('job_logs') = flywheel.ModelBase.serializeValue(obj.props_('job_logs'), 'char');
            end
            if isKey(obj.props_, 'access_log')
                result('access_log') = flywheel.ModelBase.serializeValue(obj.props_('access_log'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'storage')
                result.storage = obj.props_('storage');
            else
                result.storage = [];
            end
            if isKey(obj.props_, 'compute')
                result.compute = obj.props_('compute');
            else
                result.compute = [];
            end
            if isKey(obj.props_, 'change_log')
                result.changeLog = obj.props_('change_log');
            else
                result.changeLog = [];
            end
            if isKey(obj.props_, 'job_logs')
                result.jobLogs = obj.props_('job_logs');
            else
                result.jobLogs = [];
            end
            if isKey(obj.props_, 'access_log')
                result.accessLog = obj.props_('access_log');
            else
                result.accessLog = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'storage')
                    propList.storage = obj.props_('storage');
                else
                    propList.storage = [];
                end
                if isKey(obj.props_, 'compute')
                    propList.compute = obj.props_('compute');
                else
                    propList.compute = [];
                end
                if isKey(obj.props_, 'change_log')
                    propList.changeLog = obj.props_('change_log');
                else
                    propList.changeLog = [];
                end
                if isKey(obj.props_, 'job_logs')
                    propList.jobLogs = obj.props_('job_logs');
                else
                    propList.jobLogs = [];
                end
                if isKey(obj.props_, 'access_log')
                    propList.accessLog = obj.props_('access_log');
                else
                    propList.accessLog = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Providers;
            if isfield(json, 'storage')
                obj.props_('storage') = flywheel.ModelBase.deserializeValue(json.storage, 'char');
            end
            if isfield(json, 'compute')
                obj.props_('compute') = flywheel.ModelBase.deserializeValue(json.compute, 'char');
            end
            if isfield(json, 'change_log')
                obj.props_('change_log') = flywheel.ModelBase.deserializeValue(json.change_log, 'char');
            end
            if isfield(json, 'job_logs')
                obj.props_('job_logs') = flywheel.ModelBase.deserializeValue(json.job_logs, 'char');
            end
            if isfield(json, 'access_log')
                obj.props_('access_log') = flywheel.ModelBase.deserializeValue(json.access_log, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Providers')
                    obj = flywheel.model.Providers(obj);
                end
                if isKey(obj.props_, 'storage')
                end
                if isKey(obj.props_, 'compute')
                end
                if isKey(obj.props_, 'change_log')
                end
                if isKey(obj.props_, 'job_logs')
                end
                if isKey(obj.props_, 'access_log')
                end
            end
        end
    end
end
