% ReportAccessLogEntry - A single entry in the access log report
%
% ReportAccessLogEntry Properties:
%    id             - The access log entry id
%    accessType     - A named field used in the access log report
%    context       
%    origin        
%    actions        - Array of actions
%    count          - null
%    destination   
%    firstAccess    - Datetime of first access
%    lastAccess     - Datetime of last access
%    roleId         - Id of role
%    roleIds        - Array of role ids
%    userId         - User id
%    userRoleType   - User role type
%    error          - Error
%    requestMethod  - The http request method (e.g. GET, PUT, POST, DELETE)
%    requestPath    - The HTTP request path (e.g. /api/projects)
%    timestamp     
%
% ReportAccessLogEntry Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportAccessLogEntry < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'accessType', 'context', 'origin', 'actions', 'count', 'destination', 'firstAccess', 'lastAccess', 'roleId', 'roleIds', 'userId', 'userRoleType', 'error', 'requestMethod', 'requestPath', 'timestamp' }, ...
            { '_id', 'access_type', 'context', 'origin', 'actions', 'count', 'destination', 'first_access', 'last_access', 'role_id', 'role_ids', 'user_id', 'user_role_type', 'error', 'request_method', 'request_path', 'timestamp' });
    end
    properties(Dependent)
        id
        accessType
        context
        origin
        actions
        count
        destination
        firstAccess
        lastAccess
        roleId
        roleIds
        userId
        userRoleType
        error
        requestMethod
        requestPath
        timestamp
    end
    methods
        function obj = ReportAccessLogEntry(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportAccessLogEntry.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'accessType', []);
                addParameter(p, 'context', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'actions', []);
                addParameter(p, 'count', []);
                addParameter(p, 'destination', []);
                addParameter(p, 'firstAccess', []);
                addParameter(p, 'lastAccess', []);
                addParameter(p, 'roleId', []);
                addParameter(p, 'roleIds', []);
                addParameter(p, 'userId', []);
                addParameter(p, 'userRoleType', []);
                addParameter(p, 'error', []);
                addParameter(p, 'requestMethod', []);
                addParameter(p, 'requestPath', []);
                addParameter(p, 'timestamp', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.accessType)
                    obj.props_('access_type') = p.Results.accessType;
                end
                if ~isempty(p.Results.context)
                    obj.props_('context') = p.Results.context;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.actions)
                    obj.props_('actions') = p.Results.actions;
                end
                if ~isempty(p.Results.count)
                    obj.props_('count') = p.Results.count;
                end
                if ~isempty(p.Results.destination)
                    obj.props_('destination') = p.Results.destination;
                end
                if ~isempty(p.Results.firstAccess)
                    obj.props_('first_access') = p.Results.firstAccess;
                end
                if ~isempty(p.Results.lastAccess)
                    obj.props_('last_access') = p.Results.lastAccess;
                end
                if ~isempty(p.Results.roleId)
                    obj.props_('role_id') = p.Results.roleId;
                end
                if ~isempty(p.Results.roleIds)
                    obj.props_('role_ids') = p.Results.roleIds;
                end
                if ~isempty(p.Results.userId)
                    obj.props_('user_id') = p.Results.userId;
                end
                if ~isempty(p.Results.userRoleType)
                    obj.props_('user_role_type') = p.Results.userRoleType;
                end
                if ~isempty(p.Results.error)
                    obj.props_('error') = p.Results.error;
                end
                if ~isempty(p.Results.requestMethod)
                    obj.props_('request_method') = p.Results.requestMethod;
                end
                if ~isempty(p.Results.requestPath)
                    obj.props_('request_path') = p.Results.requestPath;
                end
                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.accessType(obj)
            if ismethod(obj, 'get_accessType')
                result = obj.get_accessType();
            else
                if isKey(obj.props_, 'access_type')
                    result = obj.props_('access_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.accessType(obj, value)
            obj.props_('access_type') = value;
        end
        function result = get.context(obj)
            if ismethod(obj, 'get_context')
                result = obj.get_context();
            else
                if isKey(obj.props_, 'context')
                    result = obj.props_('context');
                else
                    result = [];
                end
            end
        end
        function obj = set.context(obj, value)
            obj.props_('context') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.actions(obj)
            if ismethod(obj, 'get_actions')
                result = obj.get_actions();
            else
                if isKey(obj.props_, 'actions')
                    result = obj.props_('actions');
                else
                    result = [];
                end
            end
        end
        function obj = set.actions(obj, value)
            obj.props_('actions') = value;
        end
        function result = get.count(obj)
            if ismethod(obj, 'get_count')
                result = obj.get_count();
            else
                if isKey(obj.props_, 'count')
                    result = obj.props_('count');
                else
                    result = [];
                end
            end
        end
        function obj = set.count(obj, value)
            obj.props_('count') = value;
        end
        function result = get.destination(obj)
            if ismethod(obj, 'get_destination')
                result = obj.get_destination();
            else
                if isKey(obj.props_, 'destination')
                    result = obj.props_('destination');
                else
                    result = [];
                end
            end
        end
        function obj = set.destination(obj, value)
            obj.props_('destination') = value;
        end
        function result = get.firstAccess(obj)
            if ismethod(obj, 'get_firstAccess')
                result = obj.get_firstAccess();
            else
                if isKey(obj.props_, 'first_access')
                    result = obj.props_('first_access');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstAccess(obj, value)
            obj.props_('first_access') = value;
        end
        function result = get.lastAccess(obj)
            if ismethod(obj, 'get_lastAccess')
                result = obj.get_lastAccess();
            else
                if isKey(obj.props_, 'last_access')
                    result = obj.props_('last_access');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastAccess(obj, value)
            obj.props_('last_access') = value;
        end
        function result = get.roleId(obj)
            if ismethod(obj, 'get_roleId')
                result = obj.get_roleId();
            else
                if isKey(obj.props_, 'role_id')
                    result = obj.props_('role_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.roleId(obj, value)
            obj.props_('role_id') = value;
        end
        function result = get.roleIds(obj)
            if ismethod(obj, 'get_roleIds')
                result = obj.get_roleIds();
            else
                if isKey(obj.props_, 'role_ids')
                    result = obj.props_('role_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.roleIds(obj, value)
            obj.props_('role_ids') = value;
        end
        function result = get.userId(obj)
            if ismethod(obj, 'get_userId')
                result = obj.get_userId();
            else
                if isKey(obj.props_, 'user_id')
                    result = obj.props_('user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.userId(obj, value)
            obj.props_('user_id') = value;
        end
        function result = get.userRoleType(obj)
            if ismethod(obj, 'get_userRoleType')
                result = obj.get_userRoleType();
            else
                if isKey(obj.props_, 'user_role_type')
                    result = obj.props_('user_role_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.userRoleType(obj, value)
            obj.props_('user_role_type') = value;
        end
        function result = get.error(obj)
            if ismethod(obj, 'get_error')
                result = obj.get_error();
            else
                if isKey(obj.props_, 'error')
                    result = obj.props_('error');
                else
                    result = [];
                end
            end
        end
        function obj = set.error(obj, value)
            obj.props_('error') = value;
        end
        function result = get.requestMethod(obj)
            if ismethod(obj, 'get_requestMethod')
                result = obj.get_requestMethod();
            else
                if isKey(obj.props_, 'request_method')
                    result = obj.props_('request_method');
                else
                    result = [];
                end
            end
        end
        function obj = set.requestMethod(obj, value)
            obj.props_('request_method') = value;
        end
        function result = get.requestPath(obj)
            if ismethod(obj, 'get_requestPath')
                result = obj.get_requestPath();
            else
                if isKey(obj.props_, 'request_path')
                    result = obj.props_('request_path');
                else
                    result = [];
                end
            end
        end
        function obj = set.requestPath(obj, value)
            obj.props_('request_path') = value;
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'access_type')
                result('access_type') = flywheel.ModelBase.serializeValue(obj.props_('access_type'), 'char');
            end
            if isKey(obj.props_, 'context')
                result('context') = obj.props_('context').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'actions')
                result('actions') = flywheel.ModelBase.serializeValue(obj.props_('actions'), 'vector[char]');
            end
            if isKey(obj.props_, 'count')
                result('count') = flywheel.ModelBase.serializeValue(obj.props_('count'), 'integer');
            end
            if isKey(obj.props_, 'destination')
                result('destination') = flywheel.ModelBase.serializeValue(obj.props_('destination'), 'containers.Map');
            end
            if isKey(obj.props_, 'first_access')
                result('first_access') = flywheel.ModelBase.serializeValue(obj.props_('first_access'), 'datetime');
            end
            if isKey(obj.props_, 'last_access')
                result('last_access') = flywheel.ModelBase.serializeValue(obj.props_('last_access'), 'datetime');
            end
            if isKey(obj.props_, 'role_id')
                result('role_id') = flywheel.ModelBase.serializeValue(obj.props_('role_id'), 'char');
            end
            if isKey(obj.props_, 'role_ids')
                result('role_ids') = flywheel.ModelBase.serializeValue(obj.props_('role_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'user_id')
                result('user_id') = flywheel.ModelBase.serializeValue(obj.props_('user_id'), 'char');
            end
            if isKey(obj.props_, 'user_role_type')
                result('user_role_type') = flywheel.ModelBase.serializeValue(obj.props_('user_role_type'), 'vector[char]');
            end
            if isKey(obj.props_, 'error')
                result('error') = flywheel.ModelBase.serializeValue(obj.props_('error'), 'char');
            end
            if isKey(obj.props_, 'request_method')
                result('request_method') = flywheel.ModelBase.serializeValue(obj.props_('request_method'), 'char');
            end
            if isKey(obj.props_, 'request_path')
                result('request_path') = flywheel.ModelBase.serializeValue(obj.props_('request_path'), 'char');
            end
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'access_type')
                result.accessType = obj.props_('access_type');
            else
                result.accessType = [];
            end
            if isKey(obj.props_, 'context')
                result.context = struct(obj.props_('context'));
            else
                result.context = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'actions')
                result.actions = obj.props_('actions');
            else
                result.actions = [];
            end
            if isKey(obj.props_, 'count')
                result.count = obj.props_('count');
            else
                result.count = [];
            end
            if isKey(obj.props_, 'destination')
                result.destination = obj.props_('destination');
            else
                result.destination = [];
            end
            if isKey(obj.props_, 'first_access')
                result.firstAccess = obj.props_('first_access');
            else
                result.firstAccess = [];
            end
            if isKey(obj.props_, 'last_access')
                result.lastAccess = obj.props_('last_access');
            else
                result.lastAccess = [];
            end
            if isKey(obj.props_, 'role_id')
                result.roleId = obj.props_('role_id');
            else
                result.roleId = [];
            end
            if isKey(obj.props_, 'role_ids')
                result.roleIds = obj.props_('role_ids');
            else
                result.roleIds = [];
            end
            if isKey(obj.props_, 'user_id')
                result.userId = obj.props_('user_id');
            else
                result.userId = [];
            end
            if isKey(obj.props_, 'user_role_type')
                result.userRoleType = obj.props_('user_role_type');
            else
                result.userRoleType = [];
            end
            if isKey(obj.props_, 'error')
                result.error = obj.props_('error');
            else
                result.error = [];
            end
            if isKey(obj.props_, 'request_method')
                result.requestMethod = obj.props_('request_method');
            else
                result.requestMethod = [];
            end
            if isKey(obj.props_, 'request_path')
                result.requestPath = obj.props_('request_path');
            else
                result.requestPath = [];
            end
            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'access_type')
                    propList.accessType = obj.props_('access_type');
                else
                    propList.accessType = [];
                end
                if isKey(obj.props_, 'context')
                    propList.context = obj.props_('context');
                else
                    propList.context = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'actions')
                    propList.actions = obj.props_('actions');
                else
                    propList.actions = [];
                end
                if isKey(obj.props_, 'count')
                    propList.count = obj.props_('count');
                else
                    propList.count = [];
                end
                if isKey(obj.props_, 'destination')
                    propList.destination = obj.props_('destination');
                else
                    propList.destination = [];
                end
                if isKey(obj.props_, 'first_access')
                    propList.firstAccess = obj.props_('first_access');
                else
                    propList.firstAccess = [];
                end
                if isKey(obj.props_, 'last_access')
                    propList.lastAccess = obj.props_('last_access');
                else
                    propList.lastAccess = [];
                end
                if isKey(obj.props_, 'role_id')
                    propList.roleId = obj.props_('role_id');
                else
                    propList.roleId = [];
                end
                if isKey(obj.props_, 'role_ids')
                    propList.roleIds = obj.props_('role_ids');
                else
                    propList.roleIds = [];
                end
                if isKey(obj.props_, 'user_id')
                    propList.userId = obj.props_('user_id');
                else
                    propList.userId = [];
                end
                if isKey(obj.props_, 'user_role_type')
                    propList.userRoleType = obj.props_('user_role_type');
                else
                    propList.userRoleType = [];
                end
                if isKey(obj.props_, 'error')
                    propList.error = obj.props_('error');
                else
                    propList.error = [];
                end
                if isKey(obj.props_, 'request_method')
                    propList.requestMethod = obj.props_('request_method');
                else
                    propList.requestMethod = [];
                end
                if isKey(obj.props_, 'request_path')
                    propList.requestPath = obj.props_('request_path');
                else
                    propList.requestPath = [];
                end
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportAccessLogEntry;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'access_type')
                obj.props_('access_type') = flywheel.ModelBase.deserializeValue(json.access_type, 'char');
            end
            if isfield(json, 'context')
                obj.props_('context') = flywheel.model.ReportAccessLogContext.fromJson(json.context, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.ReportAccessLogOrigin.fromJson(json.origin, context);
            end
            if isfield(json, 'actions')
                obj.props_('actions') = flywheel.ModelBase.deserializeValue(json.actions, 'vector[char]');
            end
            if isfield(json, 'count')
                obj.props_('count') = flywheel.ModelBase.deserializeValue(json.count, 'integer');
            end
            if isfield(json, 'destination')
                obj.props_('destination') = flywheel.ModelBase.deserializeValue(json.destination, 'containers.Map');
            end
            if isfield(json, 'first_access')
                obj.props_('first_access') = flywheel.ModelBase.deserializeValue(json.first_access, 'datetime');
            end
            if isfield(json, 'last_access')
                obj.props_('last_access') = flywheel.ModelBase.deserializeValue(json.last_access, 'datetime');
            end
            if isfield(json, 'role_id')
                obj.props_('role_id') = flywheel.ModelBase.deserializeValue(json.role_id, 'char');
            end
            if isfield(json, 'role_ids')
                obj.props_('role_ids') = flywheel.ModelBase.deserializeValue(json.role_ids, 'vector[char]');
            end
            if isfield(json, 'user_id')
                obj.props_('user_id') = flywheel.ModelBase.deserializeValue(json.user_id, 'char');
            end
            if isfield(json, 'user_role_type')
                obj.props_('user_role_type') = flywheel.ModelBase.deserializeValue(json.user_role_type, 'vector[char]');
            end
            if isfield(json, 'error')
                obj.props_('error') = flywheel.ModelBase.deserializeValue(json.error, 'char');
            end
            if isfield(json, 'request_method')
                obj.props_('request_method') = flywheel.ModelBase.deserializeValue(json.request_method, 'char');
            end
            if isfield(json, 'request_path')
                obj.props_('request_path') = flywheel.ModelBase.deserializeValue(json.request_path, 'char');
            end
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportAccessLogEntry')
                    obj = flywheel.model.ReportAccessLogEntry(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'access_type')
                end
                if isKey(obj.props_, 'context')
                    obj.props_('context') =  flywheel.model.ReportAccessLogContext.ensureIsInstance(obj.props_('context'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.ReportAccessLogOrigin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'actions')
                end
                if isKey(obj.props_, 'count')
                end
                if isKey(obj.props_, 'destination')
                end
                if isKey(obj.props_, 'first_access')
                end
                if isKey(obj.props_, 'last_access')
                end
                if isKey(obj.props_, 'role_id')
                end
                if isKey(obj.props_, 'role_ids')
                end
                if isKey(obj.props_, 'user_id')
                end
                if isKey(obj.props_, 'user_role_type')
                end
                if isKey(obj.props_, 'error')
                end
                if isKey(obj.props_, 'request_method')
                end
                if isKey(obj.props_, 'request_path')
                end
                if isKey(obj.props_, 'timestamp')
                end
            end
        end
    end
end
