% ReportAvailabilityList
%
% ReportAvailabilityList Properties:
%    availableReports 
%
% ReportAvailabilityList Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportAvailabilityList < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'availableReports' }, ...
            { 'available_reports' });
    end
    properties(Dependent)
        availableReports
    end
    methods
        function obj = ReportAvailabilityList(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportAvailabilityList.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'availableReports', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.availableReports)
                    obj.props_('available_reports') = p.Results.availableReports;
                end
            end
        end
        function result = get.availableReports(obj)
            if ismethod(obj, 'get_availableReports')
                result = obj.get_availableReports();
            else
                if isKey(obj.props_, 'available_reports')
                    result = obj.props_('available_reports');
                else
                    result = [];
                end
            end
        end
        function obj = set.availableReports(obj, value)
            obj.props_('available_reports') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'available_reports')
                result('available_reports') = flywheel.ModelBase.cellmap(@toJson, obj.props_('available_reports'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'available_reports')
                result.availableReports = flywheel.ModelBase.cellmap(@struct, obj.props_('available_reports'));
            else
                result.availableReports = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'available_reports')
                    propList.availableReports = obj.props_('available_reports');
                else
                    propList.availableReports = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportAvailabilityList;
            if isfield(json, 'available_reports')
                obj.props_('available_reports') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ReportTimePeriod.fromJson(x, context), json.available_reports);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportAvailabilityList')
                    obj = flywheel.model.ReportAvailabilityList(obj);
                end
                if isKey(obj.props_, 'available_reports')
                    obj.props_('available_reports') = flywheel.ModelBase.cellmap(@flywheel.model.ReportTimePeriod.ensureIsInstance, obj.props_('available_reports'));
                end
            end
        end
    end
end
