% ReportEthnicityGrid
%
% ReportEthnicityGrid Properties:
%    notHispanicOrLatino  
%    hispanicOrLatino     
%    unknownOrNotReported 
%    total                
%
% ReportEthnicityGrid Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportEthnicityGrid < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'notHispanicOrLatino', 'hispanicOrLatino', 'unknownOrNotReported', 'total' }, ...
            { 'Not Hispanic or Latino', 'Hispanic or Latino', 'Unknown or Not Reported', 'Total' });
    end
    properties(Dependent)
        notHispanicOrLatino
        hispanicOrLatino
        unknownOrNotReported
        total
    end
    methods
        function obj = ReportEthnicityGrid(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportEthnicityGrid.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'notHispanicOrLatino', []);
                addParameter(p, 'hispanicOrLatino', []);
                addParameter(p, 'unknownOrNotReported', []);
                addParameter(p, 'total', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.notHispanicOrLatino)
                    obj.props_('Not Hispanic or Latino') = p.Results.notHispanicOrLatino;
                end
                if ~isempty(p.Results.hispanicOrLatino)
                    obj.props_('Hispanic or Latino') = p.Results.hispanicOrLatino;
                end
                if ~isempty(p.Results.unknownOrNotReported)
                    obj.props_('Unknown or Not Reported') = p.Results.unknownOrNotReported;
                end
                if ~isempty(p.Results.total)
                    obj.props_('Total') = p.Results.total;
                end
            end
        end
        function result = get.notHispanicOrLatino(obj)
            if ismethod(obj, 'get_notHispanicOrLatino')
                result = obj.get_notHispanicOrLatino();
            else
                if isKey(obj.props_, 'Not Hispanic or Latino')
                    result = obj.props_('Not Hispanic or Latino');
                else
                    result = [];
                end
            end
        end
        function obj = set.notHispanicOrLatino(obj, value)
            obj.props_('Not Hispanic or Latino') = value;
        end
        function result = get.hispanicOrLatino(obj)
            if ismethod(obj, 'get_hispanicOrLatino')
                result = obj.get_hispanicOrLatino();
            else
                if isKey(obj.props_, 'Hispanic or Latino')
                    result = obj.props_('Hispanic or Latino');
                else
                    result = [];
                end
            end
        end
        function obj = set.hispanicOrLatino(obj, value)
            obj.props_('Hispanic or Latino') = value;
        end
        function result = get.unknownOrNotReported(obj)
            if ismethod(obj, 'get_unknownOrNotReported')
                result = obj.get_unknownOrNotReported();
            else
                if isKey(obj.props_, 'Unknown or Not Reported')
                    result = obj.props_('Unknown or Not Reported');
                else
                    result = [];
                end
            end
        end
        function obj = set.unknownOrNotReported(obj, value)
            obj.props_('Unknown or Not Reported') = value;
        end
        function result = get.total(obj)
            if ismethod(obj, 'get_total')
                result = obj.get_total();
            else
                if isKey(obj.props_, 'Total')
                    result = obj.props_('Total');
                else
                    result = [];
                end
            end
        end
        function obj = set.total(obj, value)
            obj.props_('Total') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'Not Hispanic or Latino')
                result('Not Hispanic or Latino') = obj.props_('Not Hispanic or Latino').toJson();
            end
            if isKey(obj.props_, 'Hispanic or Latino')
                result('Hispanic or Latino') = obj.props_('Hispanic or Latino').toJson();
            end
            if isKey(obj.props_, 'Unknown or Not Reported')
                result('Unknown or Not Reported') = obj.props_('Unknown or Not Reported').toJson();
            end
            if isKey(obj.props_, 'Total')
                result('Total') = flywheel.ModelBase.serializeValue(obj.props_('Total'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'Not Hispanic or Latino')
                result.notHispanicOrLatino = struct(obj.props_('Not Hispanic or Latino'));
            else
                result.notHispanicOrLatino = [];
            end
            if isKey(obj.props_, 'Hispanic or Latino')
                result.hispanicOrLatino = struct(obj.props_('Hispanic or Latino'));
            else
                result.hispanicOrLatino = [];
            end
            if isKey(obj.props_, 'Unknown or Not Reported')
                result.unknownOrNotReported = struct(obj.props_('Unknown or Not Reported'));
            else
                result.unknownOrNotReported = [];
            end
            if isKey(obj.props_, 'Total')
                result.total = obj.props_('Total');
            else
                result.total = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'Not Hispanic or Latino')
                    propList.notHispanicOrLatino = obj.props_('Not Hispanic or Latino');
                else
                    propList.notHispanicOrLatino = [];
                end
                if isKey(obj.props_, 'Hispanic or Latino')
                    propList.hispanicOrLatino = obj.props_('Hispanic or Latino');
                else
                    propList.hispanicOrLatino = [];
                end
                if isKey(obj.props_, 'Unknown or Not Reported')
                    propList.unknownOrNotReported = obj.props_('Unknown or Not Reported');
                else
                    propList.unknownOrNotReported = [];
                end
                if isKey(obj.props_, 'Total')
                    propList.total = obj.props_('Total');
                else
                    propList.total = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportEthnicityGrid;
            if isfield(json, 'NotHispanicOrLatino')
                obj.props_('Not Hispanic or Latino') = flywheel.model.AllOfReportEthnicityGridNotHispanicOrLatino.fromJson(json.NotHispanicOrLatino, context);
            end
            if isfield(json, 'HispanicOrLatino')
                obj.props_('Hispanic or Latino') = flywheel.model.AllOfReportEthnicityGridHispanicOrLatino.fromJson(json.HispanicOrLatino, context);
            end
            if isfield(json, 'UnknownOrNotReported')
                obj.props_('Unknown or Not Reported') = flywheel.model.AllOfReportEthnicityGridUnknownOrNotReported.fromJson(json.UnknownOrNotReported, context);
            end
            if isfield(json, 'Total')
                obj.props_('Total') = flywheel.ModelBase.deserializeValue(json.Total, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportEthnicityGrid')
                    obj = flywheel.model.ReportEthnicityGrid(obj);
                end
                if isKey(obj.props_, 'Not Hispanic or Latino')
                    obj.props_('Not Hispanic or Latino') =  flywheel.model.AllOfReportEthnicityGridNotHispanicOrLatino.ensureIsInstance(obj.props_('Not Hispanic or Latino'));
                end
                if isKey(obj.props_, 'Hispanic or Latino')
                    obj.props_('Hispanic or Latino') =  flywheel.model.AllOfReportEthnicityGridHispanicOrLatino.ensureIsInstance(obj.props_('Hispanic or Latino'));
                end
                if isKey(obj.props_, 'Unknown or Not Reported')
                    obj.props_('Unknown or Not Reported') =  flywheel.model.AllOfReportEthnicityGridUnknownOrNotReported.ensureIsInstance(obj.props_('Unknown or Not Reported'));
                end
                if isKey(obj.props_, 'Total')
                end
            end
        end
    end
end
