% ReportGenderCount
%
% ReportGenderCount Properties:
%    male                 
%    unknownOrNotReported 
%    female               
%
% ReportGenderCount Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportGenderCount < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'male', 'unknownOrNotReported', 'female' }, ...
            { 'Male', 'Unknown or Not Reported', 'Female' });
    end
    properties(Dependent)
        male
        unknownOrNotReported
        female
    end
    methods
        function obj = ReportGenderCount(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportGenderCount.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'male', []);
                addParameter(p, 'unknownOrNotReported', []);
                addParameter(p, 'female', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.male)
                    obj.props_('Male') = p.Results.male;
                end
                if ~isempty(p.Results.unknownOrNotReported)
                    obj.props_('Unknown or Not Reported') = p.Results.unknownOrNotReported;
                end
                if ~isempty(p.Results.female)
                    obj.props_('Female') = p.Results.female;
                end
            end
        end
        function result = get.male(obj)
            if ismethod(obj, 'get_male')
                result = obj.get_male();
            else
                if isKey(obj.props_, 'Male')
                    result = obj.props_('Male');
                else
                    result = [];
                end
            end
        end
        function obj = set.male(obj, value)
            obj.props_('Male') = value;
        end
        function result = get.unknownOrNotReported(obj)
            if ismethod(obj, 'get_unknownOrNotReported')
                result = obj.get_unknownOrNotReported();
            else
                if isKey(obj.props_, 'Unknown or Not Reported')
                    result = obj.props_('Unknown or Not Reported');
                else
                    result = [];
                end
            end
        end
        function obj = set.unknownOrNotReported(obj, value)
            obj.props_('Unknown or Not Reported') = value;
        end
        function result = get.female(obj)
            if ismethod(obj, 'get_female')
                result = obj.get_female();
            else
                if isKey(obj.props_, 'Female')
                    result = obj.props_('Female');
                else
                    result = [];
                end
            end
        end
        function obj = set.female(obj, value)
            obj.props_('Female') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'Male')
                result('Male') = flywheel.ModelBase.serializeValue(obj.props_('Male'), 'integer');
            end
            if isKey(obj.props_, 'Unknown or Not Reported')
                result('Unknown or Not Reported') = flywheel.ModelBase.serializeValue(obj.props_('Unknown or Not Reported'), 'integer');
            end
            if isKey(obj.props_, 'Female')
                result('Female') = flywheel.ModelBase.serializeValue(obj.props_('Female'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'Male')
                result.male = obj.props_('Male');
            else
                result.male = [];
            end
            if isKey(obj.props_, 'Unknown or Not Reported')
                result.unknownOrNotReported = obj.props_('Unknown or Not Reported');
            else
                result.unknownOrNotReported = [];
            end
            if isKey(obj.props_, 'Female')
                result.female = obj.props_('Female');
            else
                result.female = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'Male')
                    propList.male = obj.props_('Male');
                else
                    propList.male = [];
                end
                if isKey(obj.props_, 'Unknown or Not Reported')
                    propList.unknownOrNotReported = obj.props_('Unknown or Not Reported');
                else
                    propList.unknownOrNotReported = [];
                end
                if isKey(obj.props_, 'Female')
                    propList.female = obj.props_('Female');
                else
                    propList.female = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportGenderCount;
            if isfield(json, 'Male')
                obj.props_('Male') = flywheel.ModelBase.deserializeValue(json.Male, 'integer');
            end
            if isfield(json, 'UnknownOrNotReported')
                obj.props_('Unknown or Not Reported') = flywheel.ModelBase.deserializeValue(json.UnknownOrNotReported, 'integer');
            end
            if isfield(json, 'Female')
                obj.props_('Female') = flywheel.ModelBase.deserializeValue(json.Female, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportGenderCount')
                    obj = flywheel.model.ReportGenderCount(obj);
                end
                if isKey(obj.props_, 'Male')
                end
                if isKey(obj.props_, 'Unknown or Not Reported')
                end
                if isKey(obj.props_, 'Female')
                end
            end
        end
    end
end
