% ReportGroupReport
%
% ReportGroupReport Properties:
%    projectCount 
%    label         - The group label
%    sessionCount 
%
% ReportGroupReport Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportGroupReport < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'projectCount', 'label', 'sessionCount' }, ...
            { 'project_count', 'label', 'session_count' });
    end
    properties(Dependent)
        projectCount
        label
        sessionCount
    end
    methods
        function obj = ReportGroupReport(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportGroupReport.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'projectCount', []);
                addParameter(p, 'label', []);
                addParameter(p, 'sessionCount', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.projectCount)
                    obj.props_('project_count') = p.Results.projectCount;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.sessionCount)
                    obj.props_('session_count') = p.Results.sessionCount;
                end
            end
        end
        function result = get.projectCount(obj)
            if ismethod(obj, 'get_projectCount')
                result = obj.get_projectCount();
            else
                if isKey(obj.props_, 'project_count')
                    result = obj.props_('project_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectCount(obj, value)
            obj.props_('project_count') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.sessionCount(obj)
            if ismethod(obj, 'get_sessionCount')
                result = obj.get_sessionCount();
            else
                if isKey(obj.props_, 'session_count')
                    result = obj.props_('session_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessionCount(obj, value)
            obj.props_('session_count') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'project_count')
                result('project_count') = flywheel.ModelBase.serializeValue(obj.props_('project_count'), 'integer');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'session_count')
                result('session_count') = flywheel.ModelBase.serializeValue(obj.props_('session_count'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'project_count')
                result.projectCount = obj.props_('project_count');
            else
                result.projectCount = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'session_count')
                result.sessionCount = obj.props_('session_count');
            else
                result.sessionCount = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'project_count')
                    propList.projectCount = obj.props_('project_count');
                else
                    propList.projectCount = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'session_count')
                    propList.sessionCount = obj.props_('session_count');
                else
                    propList.sessionCount = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportGroupReport;
            if isfield(json, 'project_count')
                obj.props_('project_count') = flywheel.ModelBase.deserializeValue(json.project_count, 'integer');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'session_count')
                obj.props_('session_count') = flywheel.ModelBase.deserializeValue(json.session_count, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportGroupReport')
                    obj = flywheel.model.ReportGroupReport(obj);
                end
                if isKey(obj.props_, 'project_count')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'session_count')
                end
            end
        end
    end
end
