% ReportSite
%
% ReportSite Properties:
%    groupCount 
%    groups     
%
% ReportSite Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportSite < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'groupCount', 'groups' }, ...
            { 'group_count', 'groups' });
    end
    properties(Dependent)
        groupCount
        groups
    end
    methods
        function obj = ReportSite(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportSite.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'groupCount', []);
                addParameter(p, 'groups', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.groupCount)
                    obj.props_('group_count') = p.Results.groupCount;
                end
                if ~isempty(p.Results.groups)
                    obj.props_('groups') = p.Results.groups;
                end
            end
        end
        function result = get.groupCount(obj)
            if ismethod(obj, 'get_groupCount')
                result = obj.get_groupCount();
            else
                if isKey(obj.props_, 'group_count')
                    result = obj.props_('group_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupCount(obj, value)
            obj.props_('group_count') = value;
        end
        function result = get.groups(obj)
            if ismethod(obj, 'get_groups')
                result = obj.get_groups();
            else
                if isKey(obj.props_, 'groups')
                    result = obj.props_('groups');
                else
                    result = [];
                end
            end
        end
        function obj = set.groups(obj, value)
            obj.props_('groups') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group_count')
                result('group_count') = flywheel.ModelBase.serializeValue(obj.props_('group_count'), 'integer');
            end
            if isKey(obj.props_, 'groups')
                result('groups') = flywheel.ModelBase.cellmap(@toJson, obj.props_('groups'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group_count')
                result.groupCount = obj.props_('group_count');
            else
                result.groupCount = [];
            end
            if isKey(obj.props_, 'groups')
                result.groups = flywheel.ModelBase.cellmap(@struct, obj.props_('groups'));
            else
                result.groups = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group_count')
                    propList.groupCount = obj.props_('group_count');
                else
                    propList.groupCount = [];
                end
                if isKey(obj.props_, 'groups')
                    propList.groups = obj.props_('groups');
                else
                    propList.groups = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportSite;
            if isfield(json, 'group_count')
                obj.props_('group_count') = flywheel.ModelBase.deserializeValue(json.group_count, 'integer');
            end
            if isfield(json, 'groups')
                obj.props_('groups') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ReportGroupReport.fromJson(x, context), json.groups);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportSite')
                    obj = flywheel.model.ReportSite(obj);
                end
                if isKey(obj.props_, 'group_count')
                end
                if isKey(obj.props_, 'groups')
                    obj.props_('groups') = flywheel.ModelBase.cellmap(@flywheel.model.ReportGroupReport.ensureIsInstance, obj.props_('groups'));
                end
            end
        end
    end
end
