% ReportTimePeriod - Represents a time-period where report data is available
%
% ReportTimePeriod Properties:
%    year   - The year that this report row represents
%    month  - The month that this report row represents
%
% ReportTimePeriod Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportTimePeriod < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'year', 'month' }, ...
            { 'year', 'month' });
    end
    properties(Dependent)
        year
        month
    end
    methods
        function obj = ReportTimePeriod(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportTimePeriod.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'year', []);
                addParameter(p, 'month', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.year)
                    obj.props_('year') = p.Results.year;
                end
                if ~isempty(p.Results.month)
                    obj.props_('month') = p.Results.month;
                end
            end
        end
        function result = get.year(obj)
            if ismethod(obj, 'get_year')
                result = obj.get_year();
            else
                if isKey(obj.props_, 'year')
                    result = obj.props_('year');
                else
                    result = [];
                end
            end
        end
        function obj = set.year(obj, value)
            obj.props_('year') = value;
        end
        function result = get.month(obj)
            if ismethod(obj, 'get_month')
                result = obj.get_month();
            else
                if isKey(obj.props_, 'month')
                    result = obj.props_('month');
                else
                    result = [];
                end
            end
        end
        function obj = set.month(obj, value)
            obj.props_('month') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'year')
                result('year') = flywheel.ModelBase.serializeValue(obj.props_('year'), 'integer');
            end
            if isKey(obj.props_, 'month')
                result('month') = flywheel.ModelBase.serializeValue(obj.props_('month'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'year')
                result.year = obj.props_('year');
            else
                result.year = [];
            end
            if isKey(obj.props_, 'month')
                result.month = obj.props_('month');
            else
                result.month = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'year')
                    propList.year = obj.props_('year');
                else
                    propList.year = [];
                end
                if isKey(obj.props_, 'month')
                    propList.month = obj.props_('month');
                else
                    propList.month = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportTimePeriod;
            if isfield(json, 'year')
                obj.props_('year') = flywheel.ModelBase.deserializeValue(json.year, 'integer');
            end
            if isfield(json, 'month')
                obj.props_('month') = flywheel.ModelBase.deserializeValue(json.month, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportTimePeriod')
                    obj = flywheel.model.ReportTimePeriod(obj);
                end
                if isKey(obj.props_, 'year')
                end
                if isKey(obj.props_, 'month')
                end
            end
        end
    end
end
