% ReportUsage - An entry in the usage report, describing monthly storage and gear usage by group and project
%
% ReportUsage Properties:
%    projectLabel                     - The project label
%    group                            - The group name/ID
%    project                          - The project ID
%    sessionCount                     - The number of sessions in the project on the last recorded day of the month
%    centerJobCount                   - The number of center-designated gear jobs run in this project during the month (billable to the center)
%    groupJobCount                    - The number of non-center-designated (lab) gear jobs runin this project during the month (billable to the group)
%    totalJobCount                    - The total number of gear jobs run in this project during the month
%    centerComputeMs                  - The compute time (in ms) used by center-designated jobs in this project during the month (billable to the center)
%    groupComputeMs                   - The compute time (in ms) used by non-center-designated (lab) gear jobs in this project during the month (billable to the group)
%    totalComputeMs                   - The total compute time (in ms) used by gear jobs in this project during the month
%    centerStorageByteDay             - The storage, in byte-days, used by files originating from devices or center-designated gears in this project during the month (billable to the center)
%    centerStorageSoftDeletedByteDay  - The storage, in byte-days, used by soft deleted files originating from devices or center-designated gears in this project during the month (billable to the center)
%    groupStorageByteDay              - The storage, in byte-days, used by files not originating from devices or non-center-designated (lab) gears in this project during the month (billable to the group)
%    groupStorageSoftDeletedByteDay   - The storage, in byte-days, used by soft deleted files not originating from devices or non-center-designated (lab) gears in this project during the month (billable to the group)
%    totalStorageByteDay              - The total storage, in byte-days, used by files in this project during the month
%    totalStorageSoftDeletedByteDay   - The total storage, in byte-days, used by soft deleted files in this project during the month
%    days                             - Number of days captured in this entry (normally the number of days in the month, unless the project was created in that month or it is the current month)
%
% ReportUsage Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ReportUsage < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'projectLabel', 'group', 'project', 'sessionCount', 'centerJobCount', 'groupJobCount', 'totalJobCount', 'centerComputeMs', 'groupComputeMs', 'totalComputeMs', 'centerStorageByteDay', 'centerStorageSoftDeletedByteDay', 'groupStorageByteDay', 'groupStorageSoftDeletedByteDay', 'totalStorageByteDay', 'totalStorageSoftDeletedByteDay', 'days' }, ...
            { 'project_label', 'group', 'project', 'session_count', 'center_job_count', 'group_job_count', 'total_job_count', 'center_compute_ms', 'group_compute_ms', 'total_compute_ms', 'center_storage_byte_day', 'center_storage_soft_deleted_byte_day', 'group_storage_byte_day', 'group_storage_soft_deleted_byte_day', 'total_storage_byte_day', 'total_storage_soft_deleted_byte_day', 'days' });
    end
    properties(Dependent)
        projectLabel
        group
        project
        sessionCount
        centerJobCount
        groupJobCount
        totalJobCount
        centerComputeMs
        groupComputeMs
        totalComputeMs
        centerStorageByteDay
        centerStorageSoftDeletedByteDay
        groupStorageByteDay
        groupStorageSoftDeletedByteDay
        totalStorageByteDay
        totalStorageSoftDeletedByteDay
        days
    end
    methods
        function obj = ReportUsage(varargin)
            obj@flywheel.ModelBase(flywheel.model.ReportUsage.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'projectLabel', []);
                addParameter(p, 'group', &#x27;&#x27;);
                addParameter(p, 'project', []);
                addParameter(p, 'sessionCount', 0);
                addParameter(p, 'centerJobCount', 0);
                addParameter(p, 'groupJobCount', 0);
                addParameter(p, 'totalJobCount', 0);
                addParameter(p, 'centerComputeMs', 0);
                addParameter(p, 'groupComputeMs', 0);
                addParameter(p, 'totalComputeMs', 0);
                addParameter(p, 'centerStorageByteDay', 0);
                addParameter(p, 'centerStorageSoftDeletedByteDay', 0);
                addParameter(p, 'groupStorageByteDay', 0);
                addParameter(p, 'groupStorageSoftDeletedByteDay', 0);
                addParameter(p, 'totalStorageByteDay', 0);
                addParameter(p, 'totalStorageSoftDeletedByteDay', 0);
                addParameter(p, 'days', 0);

                parse(p, varargin{:});

                if ~isempty(p.Results.projectLabel)
                    obj.props_('project_label') = p.Results.projectLabel;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.sessionCount)
                    obj.props_('session_count') = p.Results.sessionCount;
                end
                if ~isempty(p.Results.centerJobCount)
                    obj.props_('center_job_count') = p.Results.centerJobCount;
                end
                if ~isempty(p.Results.groupJobCount)
                    obj.props_('group_job_count') = p.Results.groupJobCount;
                end
                if ~isempty(p.Results.totalJobCount)
                    obj.props_('total_job_count') = p.Results.totalJobCount;
                end
                if ~isempty(p.Results.centerComputeMs)
                    obj.props_('center_compute_ms') = p.Results.centerComputeMs;
                end
                if ~isempty(p.Results.groupComputeMs)
                    obj.props_('group_compute_ms') = p.Results.groupComputeMs;
                end
                if ~isempty(p.Results.totalComputeMs)
                    obj.props_('total_compute_ms') = p.Results.totalComputeMs;
                end
                if ~isempty(p.Results.centerStorageByteDay)
                    obj.props_('center_storage_byte_day') = p.Results.centerStorageByteDay;
                end
                if ~isempty(p.Results.centerStorageSoftDeletedByteDay)
                    obj.props_('center_storage_soft_deleted_byte_day') = p.Results.centerStorageSoftDeletedByteDay;
                end
                if ~isempty(p.Results.groupStorageByteDay)
                    obj.props_('group_storage_byte_day') = p.Results.groupStorageByteDay;
                end
                if ~isempty(p.Results.groupStorageSoftDeletedByteDay)
                    obj.props_('group_storage_soft_deleted_byte_day') = p.Results.groupStorageSoftDeletedByteDay;
                end
                if ~isempty(p.Results.totalStorageByteDay)
                    obj.props_('total_storage_byte_day') = p.Results.totalStorageByteDay;
                end
                if ~isempty(p.Results.totalStorageSoftDeletedByteDay)
                    obj.props_('total_storage_soft_deleted_byte_day') = p.Results.totalStorageSoftDeletedByteDay;
                end
                if ~isempty(p.Results.days)
                    obj.props_('days') = p.Results.days;
                end
            end
        end
        function result = get.projectLabel(obj)
            if ismethod(obj, 'get_projectLabel')
                result = obj.get_projectLabel();
            else
                if isKey(obj.props_, 'project_label')
                    result = obj.props_('project_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectLabel(obj, value)
            obj.props_('project_label') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.sessionCount(obj)
            if ismethod(obj, 'get_sessionCount')
                result = obj.get_sessionCount();
            else
                if isKey(obj.props_, 'session_count')
                    result = obj.props_('session_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessionCount(obj, value)
            obj.props_('session_count') = value;
        end
        function result = get.centerJobCount(obj)
            if ismethod(obj, 'get_centerJobCount')
                result = obj.get_centerJobCount();
            else
                if isKey(obj.props_, 'center_job_count')
                    result = obj.props_('center_job_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerJobCount(obj, value)
            obj.props_('center_job_count') = value;
        end
        function result = get.groupJobCount(obj)
            if ismethod(obj, 'get_groupJobCount')
                result = obj.get_groupJobCount();
            else
                if isKey(obj.props_, 'group_job_count')
                    result = obj.props_('group_job_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupJobCount(obj, value)
            obj.props_('group_job_count') = value;
        end
        function result = get.totalJobCount(obj)
            if ismethod(obj, 'get_totalJobCount')
                result = obj.get_totalJobCount();
            else
                if isKey(obj.props_, 'total_job_count')
                    result = obj.props_('total_job_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalJobCount(obj, value)
            obj.props_('total_job_count') = value;
        end
        function result = get.centerComputeMs(obj)
            if ismethod(obj, 'get_centerComputeMs')
                result = obj.get_centerComputeMs();
            else
                if isKey(obj.props_, 'center_compute_ms')
                    result = obj.props_('center_compute_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerComputeMs(obj, value)
            obj.props_('center_compute_ms') = value;
        end
        function result = get.groupComputeMs(obj)
            if ismethod(obj, 'get_groupComputeMs')
                result = obj.get_groupComputeMs();
            else
                if isKey(obj.props_, 'group_compute_ms')
                    result = obj.props_('group_compute_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupComputeMs(obj, value)
            obj.props_('group_compute_ms') = value;
        end
        function result = get.totalComputeMs(obj)
            if ismethod(obj, 'get_totalComputeMs')
                result = obj.get_totalComputeMs();
            else
                if isKey(obj.props_, 'total_compute_ms')
                    result = obj.props_('total_compute_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalComputeMs(obj, value)
            obj.props_('total_compute_ms') = value;
        end
        function result = get.centerStorageByteDay(obj)
            if ismethod(obj, 'get_centerStorageByteDay')
                result = obj.get_centerStorageByteDay();
            else
                if isKey(obj.props_, 'center_storage_byte_day')
                    result = obj.props_('center_storage_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerStorageByteDay(obj, value)
            obj.props_('center_storage_byte_day') = value;
        end
        function result = get.centerStorageSoftDeletedByteDay(obj)
            if ismethod(obj, 'get_centerStorageSoftDeletedByteDay')
                result = obj.get_centerStorageSoftDeletedByteDay();
            else
                if isKey(obj.props_, 'center_storage_soft_deleted_byte_day')
                    result = obj.props_('center_storage_soft_deleted_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerStorageSoftDeletedByteDay(obj, value)
            obj.props_('center_storage_soft_deleted_byte_day') = value;
        end
        function result = get.groupStorageByteDay(obj)
            if ismethod(obj, 'get_groupStorageByteDay')
                result = obj.get_groupStorageByteDay();
            else
                if isKey(obj.props_, 'group_storage_byte_day')
                    result = obj.props_('group_storage_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupStorageByteDay(obj, value)
            obj.props_('group_storage_byte_day') = value;
        end
        function result = get.groupStorageSoftDeletedByteDay(obj)
            if ismethod(obj, 'get_groupStorageSoftDeletedByteDay')
                result = obj.get_groupStorageSoftDeletedByteDay();
            else
                if isKey(obj.props_, 'group_storage_soft_deleted_byte_day')
                    result = obj.props_('group_storage_soft_deleted_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupStorageSoftDeletedByteDay(obj, value)
            obj.props_('group_storage_soft_deleted_byte_day') = value;
        end
        function result = get.totalStorageByteDay(obj)
            if ismethod(obj, 'get_totalStorageByteDay')
                result = obj.get_totalStorageByteDay();
            else
                if isKey(obj.props_, 'total_storage_byte_day')
                    result = obj.props_('total_storage_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalStorageByteDay(obj, value)
            obj.props_('total_storage_byte_day') = value;
        end
        function result = get.totalStorageSoftDeletedByteDay(obj)
            if ismethod(obj, 'get_totalStorageSoftDeletedByteDay')
                result = obj.get_totalStorageSoftDeletedByteDay();
            else
                if isKey(obj.props_, 'total_storage_soft_deleted_byte_day')
                    result = obj.props_('total_storage_soft_deleted_byte_day');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalStorageSoftDeletedByteDay(obj, value)
            obj.props_('total_storage_soft_deleted_byte_day') = value;
        end
        function result = get.days(obj)
            if ismethod(obj, 'get_days')
                result = obj.get_days();
            else
                if isKey(obj.props_, 'days')
                    result = obj.props_('days');
                else
                    result = [];
                end
            end
        end
        function obj = set.days(obj, value)
            obj.props_('days') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'project_label')
                result('project_label') = flywheel.ModelBase.serializeValue(obj.props_('project_label'), 'char');
            end
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'char');
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'session_count')
                result('session_count') = flywheel.ModelBase.serializeValue(obj.props_('session_count'), 'integer');
            end
            if isKey(obj.props_, 'center_job_count')
                result('center_job_count') = flywheel.ModelBase.serializeValue(obj.props_('center_job_count'), 'integer');
            end
            if isKey(obj.props_, 'group_job_count')
                result('group_job_count') = flywheel.ModelBase.serializeValue(obj.props_('group_job_count'), 'integer');
            end
            if isKey(obj.props_, 'total_job_count')
                result('total_job_count') = flywheel.ModelBase.serializeValue(obj.props_('total_job_count'), 'integer');
            end
            if isKey(obj.props_, 'center_compute_ms')
                result('center_compute_ms') = flywheel.ModelBase.serializeValue(obj.props_('center_compute_ms'), 'integer');
            end
            if isKey(obj.props_, 'group_compute_ms')
                result('group_compute_ms') = flywheel.ModelBase.serializeValue(obj.props_('group_compute_ms'), 'integer');
            end
            if isKey(obj.props_, 'total_compute_ms')
                result('total_compute_ms') = flywheel.ModelBase.serializeValue(obj.props_('total_compute_ms'), 'integer');
            end
            if isKey(obj.props_, 'center_storage_byte_day')
                result('center_storage_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('center_storage_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'center_storage_soft_deleted_byte_day')
                result('center_storage_soft_deleted_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('center_storage_soft_deleted_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'group_storage_byte_day')
                result('group_storage_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('group_storage_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'group_storage_soft_deleted_byte_day')
                result('group_storage_soft_deleted_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('group_storage_soft_deleted_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'total_storage_byte_day')
                result('total_storage_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('total_storage_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'total_storage_soft_deleted_byte_day')
                result('total_storage_soft_deleted_byte_day') = flywheel.ModelBase.serializeValue(obj.props_('total_storage_soft_deleted_byte_day'), 'integer');
            end
            if isKey(obj.props_, 'days')
                result('days') = flywheel.ModelBase.serializeValue(obj.props_('days'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'project_label')
                result.projectLabel = obj.props_('project_label');
            else
                result.projectLabel = [];
            end
            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'session_count')
                result.sessionCount = obj.props_('session_count');
            else
                result.sessionCount = [];
            end
            if isKey(obj.props_, 'center_job_count')
                result.centerJobCount = obj.props_('center_job_count');
            else
                result.centerJobCount = [];
            end
            if isKey(obj.props_, 'group_job_count')
                result.groupJobCount = obj.props_('group_job_count');
            else
                result.groupJobCount = [];
            end
            if isKey(obj.props_, 'total_job_count')
                result.totalJobCount = obj.props_('total_job_count');
            else
                result.totalJobCount = [];
            end
            if isKey(obj.props_, 'center_compute_ms')
                result.centerComputeMs = obj.props_('center_compute_ms');
            else
                result.centerComputeMs = [];
            end
            if isKey(obj.props_, 'group_compute_ms')
                result.groupComputeMs = obj.props_('group_compute_ms');
            else
                result.groupComputeMs = [];
            end
            if isKey(obj.props_, 'total_compute_ms')
                result.totalComputeMs = obj.props_('total_compute_ms');
            else
                result.totalComputeMs = [];
            end
            if isKey(obj.props_, 'center_storage_byte_day')
                result.centerStorageByteDay = obj.props_('center_storage_byte_day');
            else
                result.centerStorageByteDay = [];
            end
            if isKey(obj.props_, 'center_storage_soft_deleted_byte_day')
                result.centerStorageSoftDeletedByteDay = obj.props_('center_storage_soft_deleted_byte_day');
            else
                result.centerStorageSoftDeletedByteDay = [];
            end
            if isKey(obj.props_, 'group_storage_byte_day')
                result.groupStorageByteDay = obj.props_('group_storage_byte_day');
            else
                result.groupStorageByteDay = [];
            end
            if isKey(obj.props_, 'group_storage_soft_deleted_byte_day')
                result.groupStorageSoftDeletedByteDay = obj.props_('group_storage_soft_deleted_byte_day');
            else
                result.groupStorageSoftDeletedByteDay = [];
            end
            if isKey(obj.props_, 'total_storage_byte_day')
                result.totalStorageByteDay = obj.props_('total_storage_byte_day');
            else
                result.totalStorageByteDay = [];
            end
            if isKey(obj.props_, 'total_storage_soft_deleted_byte_day')
                result.totalStorageSoftDeletedByteDay = obj.props_('total_storage_soft_deleted_byte_day');
            else
                result.totalStorageSoftDeletedByteDay = [];
            end
            if isKey(obj.props_, 'days')
                result.days = obj.props_('days');
            else
                result.days = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'project_label')
                    propList.projectLabel = obj.props_('project_label');
                else
                    propList.projectLabel = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'session_count')
                    propList.sessionCount = obj.props_('session_count');
                else
                    propList.sessionCount = [];
                end
                if isKey(obj.props_, 'center_job_count')
                    propList.centerJobCount = obj.props_('center_job_count');
                else
                    propList.centerJobCount = [];
                end
                if isKey(obj.props_, 'group_job_count')
                    propList.groupJobCount = obj.props_('group_job_count');
                else
                    propList.groupJobCount = [];
                end
                if isKey(obj.props_, 'total_job_count')
                    propList.totalJobCount = obj.props_('total_job_count');
                else
                    propList.totalJobCount = [];
                end
                if isKey(obj.props_, 'center_compute_ms')
                    propList.centerComputeMs = obj.props_('center_compute_ms');
                else
                    propList.centerComputeMs = [];
                end
                if isKey(obj.props_, 'group_compute_ms')
                    propList.groupComputeMs = obj.props_('group_compute_ms');
                else
                    propList.groupComputeMs = [];
                end
                if isKey(obj.props_, 'total_compute_ms')
                    propList.totalComputeMs = obj.props_('total_compute_ms');
                else
                    propList.totalComputeMs = [];
                end
                if isKey(obj.props_, 'center_storage_byte_day')
                    propList.centerStorageByteDay = obj.props_('center_storage_byte_day');
                else
                    propList.centerStorageByteDay = [];
                end
                if isKey(obj.props_, 'center_storage_soft_deleted_byte_day')
                    propList.centerStorageSoftDeletedByteDay = obj.props_('center_storage_soft_deleted_byte_day');
                else
                    propList.centerStorageSoftDeletedByteDay = [];
                end
                if isKey(obj.props_, 'group_storage_byte_day')
                    propList.groupStorageByteDay = obj.props_('group_storage_byte_day');
                else
                    propList.groupStorageByteDay = [];
                end
                if isKey(obj.props_, 'group_storage_soft_deleted_byte_day')
                    propList.groupStorageSoftDeletedByteDay = obj.props_('group_storage_soft_deleted_byte_day');
                else
                    propList.groupStorageSoftDeletedByteDay = [];
                end
                if isKey(obj.props_, 'total_storage_byte_day')
                    propList.totalStorageByteDay = obj.props_('total_storage_byte_day');
                else
                    propList.totalStorageByteDay = [];
                end
                if isKey(obj.props_, 'total_storage_soft_deleted_byte_day')
                    propList.totalStorageSoftDeletedByteDay = obj.props_('total_storage_soft_deleted_byte_day');
                else
                    propList.totalStorageSoftDeletedByteDay = [];
                end
                if isKey(obj.props_, 'days')
                    propList.days = obj.props_('days');
                else
                    propList.days = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ReportUsage;
            if isfield(json, 'project_label')
                obj.props_('project_label') = flywheel.ModelBase.deserializeValue(json.project_label, 'char');
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'char');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'session_count')
                obj.props_('session_count') = flywheel.ModelBase.deserializeValue(json.session_count, 'integer');
            end
            if isfield(json, 'center_job_count')
                obj.props_('center_job_count') = flywheel.ModelBase.deserializeValue(json.center_job_count, 'integer');
            end
            if isfield(json, 'group_job_count')
                obj.props_('group_job_count') = flywheel.ModelBase.deserializeValue(json.group_job_count, 'integer');
            end
            if isfield(json, 'total_job_count')
                obj.props_('total_job_count') = flywheel.ModelBase.deserializeValue(json.total_job_count, 'integer');
            end
            if isfield(json, 'center_compute_ms')
                obj.props_('center_compute_ms') = flywheel.ModelBase.deserializeValue(json.center_compute_ms, 'integer');
            end
            if isfield(json, 'group_compute_ms')
                obj.props_('group_compute_ms') = flywheel.ModelBase.deserializeValue(json.group_compute_ms, 'integer');
            end
            if isfield(json, 'total_compute_ms')
                obj.props_('total_compute_ms') = flywheel.ModelBase.deserializeValue(json.total_compute_ms, 'integer');
            end
            if isfield(json, 'center_storage_byte_day')
                obj.props_('center_storage_byte_day') = flywheel.ModelBase.deserializeValue(json.center_storage_byte_day, 'integer');
            end
            if isfield(json, 'center_storage_soft_deleted_byte_day')
                obj.props_('center_storage_soft_deleted_byte_day') = flywheel.ModelBase.deserializeValue(json.center_storage_soft_deleted_byte_day, 'integer');
            end
            if isfield(json, 'group_storage_byte_day')
                obj.props_('group_storage_byte_day') = flywheel.ModelBase.deserializeValue(json.group_storage_byte_day, 'integer');
            end
            if isfield(json, 'group_storage_soft_deleted_byte_day')
                obj.props_('group_storage_soft_deleted_byte_day') = flywheel.ModelBase.deserializeValue(json.group_storage_soft_deleted_byte_day, 'integer');
            end
            if isfield(json, 'total_storage_byte_day')
                obj.props_('total_storage_byte_day') = flywheel.ModelBase.deserializeValue(json.total_storage_byte_day, 'integer');
            end
            if isfield(json, 'total_storage_soft_deleted_byte_day')
                obj.props_('total_storage_soft_deleted_byte_day') = flywheel.ModelBase.deserializeValue(json.total_storage_soft_deleted_byte_day, 'integer');
            end
            if isfield(json, 'days')
                obj.props_('days') = flywheel.ModelBase.deserializeValue(json.days, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ReportUsage')
                    obj = flywheel.model.ReportUsage(obj);
                end
                if isKey(obj.props_, 'project_label')
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'session_count')
                end
                if isKey(obj.props_, 'center_job_count')
                end
                if isKey(obj.props_, 'group_job_count')
                end
                if isKey(obj.props_, 'total_job_count')
                end
                if isKey(obj.props_, 'center_compute_ms')
                end
                if isKey(obj.props_, 'group_compute_ms')
                end
                if isKey(obj.props_, 'total_compute_ms')
                end
                if isKey(obj.props_, 'center_storage_byte_day')
                end
                if isKey(obj.props_, 'center_storage_soft_deleted_byte_day')
                end
                if isKey(obj.props_, 'group_storage_byte_day')
                end
                if isKey(obj.props_, 'group_storage_soft_deleted_byte_day')
                end
                if isKey(obj.props_, 'total_storage_byte_day')
                end
                if isKey(obj.props_, 'total_storage_soft_deleted_byte_day')
                end
                if isKey(obj.props_, 'days')
                end
            end
        end
    end
end
