% ResolverNode
%
% ResolverNode Properties:
%    containerType 
%
% ResolverNode Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ResolverNode < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'containerType' }, ...
            { 'container_type' });

        discriminatorValueClassMap = containers.Map({ 'file', 'group', 'subject', 'gear', 'analysis', 'acquisition', 'session', 'project' }, ...
            { 'flywheel.model.FileNode.fromJson', 'flywheel.model.GroupNode.fromJson', 'flywheel.model.SubjectNode.fromJson', 'flywheel.model.GearNode.fromJson', 'flywheel.model.AnalysisNode.fromJson', 'flywheel.model.AcquisitionNode.fromJson', 'flywheel.model.SessionNode.fromJson', 'flywheel.model.ProjectNode.fromJson' });
    end
    properties(Dependent)
        containerType
    end
    methods
        function obj = ResolverNode(varargin)
            obj@flywheel.ModelBase(flywheel.model.ResolverNode.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'containerType', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.containerType)
                    obj.props_('container_type') = p.Results.containerType;
                end
            end
        end
        function result = get.containerType(obj)
            if ismethod(obj, 'get_containerType')
                result = obj.get_containerType();
            else
                if isKey(obj.props_, 'container_type')
                    result = obj.props_('container_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerType(obj, value)
            obj.props_('container_type') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'container_type')
                result('container_type') = flywheel.ModelBase.serializeValue(obj.props_('container_type'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'container_type')
                result.containerType = obj.props_('container_type');
            else
                result.containerType = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'container_type')
                    propList.containerType = obj.props_('container_type');
                else
                    propList.containerType = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function result = fromJson(json, context)
            discriminatorValue = [];

            if isfield(json, 'container_type')
                discriminatorValue = json.container_type;
            elseif isfield(json, 'node_type')
                discriminatorValue = json.node_type;
            end

            if isKey(flywheel.model.ResolverNode.discriminatorValueClassMap, discriminatorValue)
                result = feval(flywheel.model.ResolverNode.discriminatorValueClassMap(discriminatorValue), json, context);
            else
                result = [];
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ResolverNode')
                    obj = flywheel.model.ResolverNode(obj);
                end
                if isKey(obj.props_, 'container_type')
                end
            end
        end
    end
end
