% RoleInput
%
% RoleInput Properties:
%    label   
%    actions 
%
% RoleInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef RoleInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'actions' }, ...
            { 'label', 'actions' });
    end
    properties(Dependent)
        label
        actions
    end
    methods
        function obj = RoleInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.RoleInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'actions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.actions)
                    obj.props_('actions') = p.Results.actions;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.actions(obj)
            if ismethod(obj, 'get_actions')
                result = obj.get_actions();
            else
                if isKey(obj.props_, 'actions')
                    result = obj.props_('actions');
                else
                    result = [];
                end
            end
        end
        function obj = set.actions(obj, value)
            obj.props_('actions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'actions')
                result('actions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('actions'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'actions')
                result.actions = flywheel.ModelBase.cellmap(@struct, obj.props_('actions'));
            else
                result.actions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'actions')
                    propList.actions = obj.props_('actions');
                else
                    propList.actions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.RoleInput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'actions')
                obj.props_('actions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.Action.fromJson(x, context), json.actions);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.RoleInput')
                    obj = flywheel.model.RoleInput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'actions')
                    obj.props_('actions') = flywheel.ModelBase.cellmap(@flywheel.model.Action.ensureIsInstance, obj.props_('actions'));
                end
            end
        end
    end
end
