% SaveSearchInput
%
% SaveSearchInput Properties:
%    label  
%    search 
%    parent 
%
% SaveSearchInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SaveSearchInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'search', 'parent' }, ...
            { 'label', 'search', 'parent' });
    end
    properties(Dependent)
        label
        search
        parent
    end
    methods
        function obj = SaveSearchInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SaveSearchInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'search', []);
                addParameter(p, 'parent', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.search)
                    obj.props_('search') = p.Results.search;
                end
                if ~isempty(p.Results.parent)
                    obj.props_('parent') = p.Results.parent;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.search(obj)
            if ismethod(obj, 'get_search')
                result = obj.get_search();
            else
                if isKey(obj.props_, 'search')
                    result = obj.props_('search');
                else
                    result = [];
                end
            end
        end
        function obj = set.search(obj, value)
            obj.props_('search') = value;
        end
        function result = get.parent(obj)
            if ismethod(obj, 'get_parent')
                result = obj.get_parent();
            else
                if isKey(obj.props_, 'parent')
                    result = obj.props_('parent');
                else
                    result = [];
                end
            end
        end
        function obj = set.parent(obj, value)
            obj.props_('parent') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'search')
                result('search') = obj.props_('search').toJson();
            end
            if isKey(obj.props_, 'parent')
                result('parent') = obj.props_('parent').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'search')
                result.search = struct(obj.props_('search'));
            else
                result.search = [];
            end
            if isKey(obj.props_, 'parent')
                result.parent = struct(obj.props_('parent'));
            else
                result.parent = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'search')
                    propList.search = obj.props_('search');
                else
                    propList.search = [];
                end
                if isKey(obj.props_, 'parent')
                    propList.parent = obj.props_('parent');
                else
                    propList.parent = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SaveSearchInput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'search')
                obj.props_('search') = flywheel.model.SearchQuery.fromJson(json.search, context);
            end
            if isfield(json, 'parent')
                obj.props_('parent') = flywheel.model.SaveSearchParent.fromJson(json.parent, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SaveSearchInput')
                    obj = flywheel.model.SaveSearchInput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'search')
                    obj.props_('search') =  flywheel.model.SearchQuery.ensureIsInstance(obj.props_('search'));
                end
                if isKey(obj.props_, 'parent')
                    obj.props_('parent') =  flywheel.model.SaveSearchParent.ensureIsInstance(obj.props_('parent'));
                end
            end
        end
    end
end
