% SaveSearchOutput
%
% SaveSearchOutput Properties:
%    id       
%    label    
%    search   
%    parent   
%    created  
%    modified 
%
% SaveSearchOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SaveSearchOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'label', 'search', 'parent', 'created', 'modified' }, ...
            { '_id', 'label', 'search', 'parent', 'created', 'modified' });
    end
    properties(Dependent)
        id
        label
        search
        parent
        created
        modified
    end
    methods
        function obj = SaveSearchOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SaveSearchOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'label', []);
                addParameter(p, 'search', []);
                addParameter(p, 'parent', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.search)
                    obj.props_('search') = p.Results.search;
                end
                if ~isempty(p.Results.parent)
                    obj.props_('parent') = p.Results.parent;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.search(obj)
            if ismethod(obj, 'get_search')
                result = obj.get_search();
            else
                if isKey(obj.props_, 'search')
                    result = obj.props_('search');
                else
                    result = [];
                end
            end
        end
        function obj = set.search(obj, value)
            obj.props_('search') = value;
        end
        function result = get.parent(obj)
            if ismethod(obj, 'get_parent')
                result = obj.get_parent();
            else
                if isKey(obj.props_, 'parent')
                    result = obj.props_('parent');
                else
                    result = [];
                end
            end
        end
        function obj = set.parent(obj, value)
            obj.props_('parent') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'search')
                result('search') = obj.props_('search').toJson();
            end
            if isKey(obj.props_, 'parent')
                result('parent') = obj.props_('parent').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'search')
                result.search = struct(obj.props_('search'));
            else
                result.search = [];
            end
            if isKey(obj.props_, 'parent')
                result.parent = struct(obj.props_('parent'));
            else
                result.parent = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'search')
                    propList.search = obj.props_('search');
                else
                    propList.search = [];
                end
                if isKey(obj.props_, 'parent')
                    propList.parent = obj.props_('parent');
                else
                    propList.parent = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SaveSearchOutput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'search')
                obj.props_('search') = flywheel.model.SearchQuery.fromJson(json.search, context);
            end
            if isfield(json, 'parent')
                obj.props_('parent') = flywheel.model.SaveSearchParent.fromJson(json.parent, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SaveSearchOutput')
                    obj = flywheel.model.SaveSearchOutput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'search')
                    obj.props_('search') =  flywheel.model.SearchQuery.ensureIsInstance(obj.props_('search'));
                end
                if isKey(obj.props_, 'parent')
                    obj.props_('parent') =  flywheel.model.SaveSearchParent.ensureIsInstance(obj.props_('parent'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
            end
        end
    end
end
