% SaveSearchUpdate
%
% SaveSearchUpdate Properties:
%    label  
%    search 
%
% SaveSearchUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SaveSearchUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'search' }, ...
            { 'label', 'search' });
    end
    properties(Dependent)
        label
        search
    end
    methods
        function obj = SaveSearchUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.SaveSearchUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'search', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.search)
                    obj.props_('search') = p.Results.search;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.search(obj)
            if ismethod(obj, 'get_search')
                result = obj.get_search();
            else
                if isKey(obj.props_, 'search')
                    result = obj.props_('search');
                else
                    result = [];
                end
            end
        end
        function obj = set.search(obj, value)
            obj.props_('search') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'search')
                result('search') = obj.props_('search').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'search')
                result.search = struct(obj.props_('search'));
            else
                result.search = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'search')
                    propList.search = obj.props_('search');
                else
                    propList.search = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SaveSearchUpdate;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'search')
                obj.props_('search') = flywheel.model.SearchQuery.fromJson(json.search, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SaveSearchUpdate')
                    obj = flywheel.model.SaveSearchUpdate(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'search')
                    obj.props_('search') =  flywheel.model.SearchQuery.ensureIsInstance(obj.props_('search'));
                end
            end
        end
    end
end
