% SearchParseError
%
% SearchParseError Properties:
%    line     - The line number where the error occurred
%    pos      - The position where the error occurred
%    offset   - The absolute offset in the input (from 0) where the error occurred
%    message  - The error message
%
% SearchParseError Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SearchParseError < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'line', 'pos', 'offset', 'message' }, ...
            { 'line', 'pos', 'offset', 'message' });
    end
    properties(Dependent)
        line
        pos
        offset
        message
    end
    methods
        function obj = SearchParseError(varargin)
            obj@flywheel.ModelBase(flywheel.model.SearchParseError.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'line', []);
                addParameter(p, 'pos', []);
                addParameter(p, 'offset', []);
                addParameter(p, 'message', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.line)
                    obj.props_('line') = p.Results.line;
                end
                if ~isempty(p.Results.pos)
                    obj.props_('pos') = p.Results.pos;
                end
                if ~isempty(p.Results.offset)
                    obj.props_('offset') = p.Results.offset;
                end
                if ~isempty(p.Results.message)
                    obj.props_('message') = p.Results.message;
                end
            end
        end
        function result = get.line(obj)
            if ismethod(obj, 'get_line')
                result = obj.get_line();
            else
                if isKey(obj.props_, 'line')
                    result = obj.props_('line');
                else
                    result = [];
                end
            end
        end
        function obj = set.line(obj, value)
            obj.props_('line') = value;
        end
        function result = get.pos(obj)
            if ismethod(obj, 'get_pos')
                result = obj.get_pos();
            else
                if isKey(obj.props_, 'pos')
                    result = obj.props_('pos');
                else
                    result = [];
                end
            end
        end
        function obj = set.pos(obj, value)
            obj.props_('pos') = value;
        end
        function result = get.offset(obj)
            if ismethod(obj, 'get_offset')
                result = obj.get_offset();
            else
                if isKey(obj.props_, 'offset')
                    result = obj.props_('offset');
                else
                    result = [];
                end
            end
        end
        function obj = set.offset(obj, value)
            obj.props_('offset') = value;
        end
        function result = get.message(obj)
            if ismethod(obj, 'get_message')
                result = obj.get_message();
            else
                if isKey(obj.props_, 'message')
                    result = obj.props_('message');
                else
                    result = [];
                end
            end
        end
        function obj = set.message(obj, value)
            obj.props_('message') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'line')
                result('line') = flywheel.ModelBase.serializeValue(obj.props_('line'), 'integer');
            end
            if isKey(obj.props_, 'pos')
                result('pos') = flywheel.ModelBase.serializeValue(obj.props_('pos'), 'integer');
            end
            if isKey(obj.props_, 'offset')
                result('offset') = flywheel.ModelBase.serializeValue(obj.props_('offset'), 'integer');
            end
            if isKey(obj.props_, 'message')
                result('message') = flywheel.ModelBase.serializeValue(obj.props_('message'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'line')
                result.line = obj.props_('line');
            else
                result.line = [];
            end
            if isKey(obj.props_, 'pos')
                result.pos = obj.props_('pos');
            else
                result.pos = [];
            end
            if isKey(obj.props_, 'offset')
                result.offset = obj.props_('offset');
            else
                result.offset = [];
            end
            if isKey(obj.props_, 'message')
                result.message = obj.props_('message');
            else
                result.message = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'line')
                    propList.line = obj.props_('line');
                else
                    propList.line = [];
                end
                if isKey(obj.props_, 'pos')
                    propList.pos = obj.props_('pos');
                else
                    propList.pos = [];
                end
                if isKey(obj.props_, 'offset')
                    propList.offset = obj.props_('offset');
                else
                    propList.offset = [];
                end
                if isKey(obj.props_, 'message')
                    propList.message = obj.props_('message');
                else
                    propList.message = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SearchParseError;
            if isfield(json, 'line')
                obj.props_('line') = flywheel.ModelBase.deserializeValue(json.line, 'integer');
            end
            if isfield(json, 'pos')
                obj.props_('pos') = flywheel.ModelBase.deserializeValue(json.pos, 'integer');
            end
            if isfield(json, 'offset')
                obj.props_('offset') = flywheel.ModelBase.deserializeValue(json.offset, 'integer');
            end
            if isfield(json, 'message')
                obj.props_('message') = flywheel.ModelBase.deserializeValue(json.message, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SearchParseError')
                    obj = flywheel.model.SearchParseError(obj);
                end
                if isKey(obj.props_, 'line')
                end
                if isKey(obj.props_, 'pos')
                end
                if isKey(obj.props_, 'offset')
                end
                if isKey(obj.props_, 'message')
                end
            end
        end
    end
end
