% SearchQuery
%
% SearchQuery Properties:
%    returnType       - Sets the type of search results to return
%    structuredQuery  - Represents structured query language search
%    searchString     - Represents the plain text search query
%    allData          - When set will include all data that the user does not have access to read
%    filters          - See https://www.elastic.co/guide/en/elasticsearch/reference/current/term-level-queries.html
%    sort            
%    size            
%
% SearchQuery Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SearchQuery < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'returnType', 'structuredQuery', 'searchString', 'allData', 'filters', 'sort', 'size' }, ...
            { 'return_type', 'structured_query', 'search_string', 'all_data', 'filters', 'sort', 'size' });
    end
    properties(Dependent)
        returnType
        structuredQuery
        searchString
        allData
        filters
        sort
        size
    end
    methods
        function obj = SearchQuery(varargin)
            obj@flywheel.ModelBase(flywheel.model.SearchQuery.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'returnType', []);
                addParameter(p, 'structuredQuery', []);
                addParameter(p, 'searchString', []);
                addParameter(p, 'allData', false);
                addParameter(p, 'filters', []);
                addParameter(p, 'sort', []);
                addParameter(p, 'size', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.returnType)
                    obj.props_('return_type') = p.Results.returnType;
                end
                if ~isempty(p.Results.structuredQuery)
                    obj.props_('structured_query') = p.Results.structuredQuery;
                end
                if ~isempty(p.Results.searchString)
                    obj.props_('search_string') = p.Results.searchString;
                end
                if ~isempty(p.Results.allData)
                    obj.props_('all_data') = p.Results.allData;
                end
                if ~isempty(p.Results.filters)
                    obj.props_('filters') = p.Results.filters;
                end
                if ~isempty(p.Results.sort)
                    obj.props_('sort') = p.Results.sort;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
            end
        end
        function result = get.returnType(obj)
            if ismethod(obj, 'get_returnType')
                result = obj.get_returnType();
            else
                if isKey(obj.props_, 'return_type')
                    result = obj.props_('return_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.returnType(obj, value)
            obj.props_('return_type') = value;
        end
        function result = get.structuredQuery(obj)
            if ismethod(obj, 'get_structuredQuery')
                result = obj.get_structuredQuery();
            else
                if isKey(obj.props_, 'structured_query')
                    result = obj.props_('structured_query');
                else
                    result = [];
                end
            end
        end
        function obj = set.structuredQuery(obj, value)
            obj.props_('structured_query') = value;
        end
        function result = get.searchString(obj)
            if ismethod(obj, 'get_searchString')
                result = obj.get_searchString();
            else
                if isKey(obj.props_, 'search_string')
                    result = obj.props_('search_string');
                else
                    result = [];
                end
            end
        end
        function obj = set.searchString(obj, value)
            obj.props_('search_string') = value;
        end
        function result = get.allData(obj)
            if ismethod(obj, 'get_allData')
                result = obj.get_allData();
            else
                if isKey(obj.props_, 'all_data')
                    result = obj.props_('all_data');
                else
                    result = [];
                end
            end
        end
        function obj = set.allData(obj, value)
            obj.props_('all_data') = value;
        end
        function result = get.filters(obj)
            if ismethod(obj, 'get_filters')
                result = obj.get_filters();
            else
                if isKey(obj.props_, 'filters')
                    result = obj.props_('filters');
                else
                    result = [];
                end
            end
        end
        function obj = set.filters(obj, value)
            obj.props_('filters') = value;
        end
        function result = get.sort(obj)
            if ismethod(obj, 'get_sort')
                result = obj.get_sort();
            else
                if isKey(obj.props_, 'sort')
                    result = obj.props_('sort');
                else
                    result = [];
                end
            end
        end
        function obj = set.sort(obj, value)
            obj.props_('sort') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'return_type')
                result('return_type') = obj.props_('return_type').toJson();
            end
            if isKey(obj.props_, 'structured_query')
                result('structured_query') = flywheel.ModelBase.serializeValue(obj.props_('structured_query'), 'char');
            end
            if isKey(obj.props_, 'search_string')
                result('search_string') = flywheel.ModelBase.serializeValue(obj.props_('search_string'), 'char');
            end
            if isKey(obj.props_, 'all_data')
                result('all_data') = flywheel.ModelBase.serializeValue(obj.props_('all_data'), 'logical');
            end
            if isKey(obj.props_, 'filters')
                result('filters') = flywheel.ModelBase.serializeValue(obj.props_('filters'), 'vector[containers.Map]');
            end
            if isKey(obj.props_, 'sort')
                result('sort') = obj.props_('sort').toJson();
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'return_type')
                result.returnType = struct(obj.props_('return_type'));
            else
                result.returnType = [];
            end
            if isKey(obj.props_, 'structured_query')
                result.structuredQuery = obj.props_('structured_query');
            else
                result.structuredQuery = [];
            end
            if isKey(obj.props_, 'search_string')
                result.searchString = obj.props_('search_string');
            else
                result.searchString = [];
            end
            if isKey(obj.props_, 'all_data')
                result.allData = obj.props_('all_data');
            else
                result.allData = [];
            end
            if isKey(obj.props_, 'filters')
                result.filters = obj.props_('filters');
            else
                result.filters = [];
            end
            if isKey(obj.props_, 'sort')
                result.sort = struct(obj.props_('sort'));
            else
                result.sort = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'return_type')
                    propList.returnType = obj.props_('return_type');
                else
                    propList.returnType = [];
                end
                if isKey(obj.props_, 'structured_query')
                    propList.structuredQuery = obj.props_('structured_query');
                else
                    propList.structuredQuery = [];
                end
                if isKey(obj.props_, 'search_string')
                    propList.searchString = obj.props_('search_string');
                else
                    propList.searchString = [];
                end
                if isKey(obj.props_, 'all_data')
                    propList.allData = obj.props_('all_data');
                else
                    propList.allData = [];
                end
                if isKey(obj.props_, 'filters')
                    propList.filters = obj.props_('filters');
                else
                    propList.filters = [];
                end
                if isKey(obj.props_, 'sort')
                    propList.sort = obj.props_('sort');
                else
                    propList.sort = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SearchQuery;
            if isfield(json, 'return_type')
                obj.props_('return_type') = flywheel.model.AllOfSearchQueryReturnType.fromJson(json.return_type, context);
            end
            if isfield(json, 'structured_query')
                obj.props_('structured_query') = flywheel.ModelBase.deserializeValue(json.structured_query, 'char');
            end
            if isfield(json, 'search_string')
                obj.props_('search_string') = flywheel.ModelBase.deserializeValue(json.search_string, 'char');
            end
            if isfield(json, 'all_data')
                obj.props_('all_data') = flywheel.ModelBase.deserializeValue(json.all_data, 'logical');
            end
            if isfield(json, 'filters')
                obj.props_('filters') = flywheel.ModelBase.deserializeValue(json.filters, 'vector[containers.Map]');
            end
            if isfield(json, 'sort')
                obj.props_('sort') = flywheel.model.Sort.fromJson(json.sort, context);
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SearchQuery')
                    obj = flywheel.model.SearchQuery(obj);
                end
                if isKey(obj.props_, 'return_type')
                    obj.props_('return_type') =  flywheel.model.AllOfSearchQueryReturnType.ensureIsInstance(obj.props_('return_type'));
                end
                if isKey(obj.props_, 'structured_query')
                end
                if isKey(obj.props_, 'search_string')
                end
                if isKey(obj.props_, 'all_data')
                end
                if isKey(obj.props_, 'filters')
                end
                if isKey(obj.props_, 'sort')
                    obj.props_('sort') =  flywheel.model.Sort.ensureIsInstance(obj.props_('sort'));
                end
                if isKey(obj.props_, 'size')
                end
            end
        end
    end
end
