% SearchResponse - Single search response entry
%
% SearchResponse Properties:
%    returnType  
%    project     
%    group       
%    session     
%    acquisition 
%    subject     
%    file        
%    collection  
%    analysis    
%    parent      
%    permissions 
%
% SearchResponse Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SearchResponse < flywheel.ModelBase & flywheel.mixins.SearchResponseMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'returnType', 'project', 'group', 'session', 'acquisition', 'subject', 'file', 'collection', 'analysis', 'parent', 'permissions' }, ...
            { 'return_type', 'project', 'group', 'session', 'acquisition', 'subject', 'file', 'collection', 'analysis', 'parent', 'permissions' });
    end
    properties(Dependent)
        returnType
        project
        group
        session
        acquisition
        subject
        file
        collection
        analysis
        parent
        permissions
    end
    methods
        function obj = SearchResponse(varargin)
            obj@flywheel.ModelBase(flywheel.model.SearchResponse.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'returnType', []);
                addParameter(p, 'project', []);
                addParameter(p, 'group', []);
                addParameter(p, 'session', []);
                addParameter(p, 'acquisition', []);
                addParameter(p, 'subject', []);
                addParameter(p, 'file', []);
                addParameter(p, 'collection', []);
                addParameter(p, 'analysis', []);
                addParameter(p, 'parent', []);
                addParameter(p, 'permissions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.returnType)
                    obj.props_('return_type') = p.Results.returnType;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
                if ~isempty(p.Results.acquisition)
                    obj.props_('acquisition') = p.Results.acquisition;
                end
                if ~isempty(p.Results.subject)
                    obj.props_('subject') = p.Results.subject;
                end
                if ~isempty(p.Results.file)
                    obj.props_('file') = p.Results.file;
                end
                if ~isempty(p.Results.collection)
                    obj.props_('collection') = p.Results.collection;
                end
                if ~isempty(p.Results.analysis)
                    obj.props_('analysis') = p.Results.analysis;
                end
                if ~isempty(p.Results.parent)
                    obj.props_('parent') = p.Results.parent;
                end
                if ~isempty(p.Results.permissions)
                    obj.props_('permissions') = p.Results.permissions;
                end
            end
        end
        function result = get.returnType(obj)
            if ismethod(obj, 'get_returnType')
                result = obj.get_returnType();
            else
                if isKey(obj.props_, 'return_type')
                    result = obj.props_('return_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.returnType(obj, value)
            obj.props_('return_type') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = get.acquisition(obj)
            if ismethod(obj, 'get_acquisition')
                result = obj.get_acquisition();
            else
                if isKey(obj.props_, 'acquisition')
                    result = obj.props_('acquisition');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisition(obj, value)
            obj.props_('acquisition') = value;
        end
        function result = get.subject(obj)
            if ismethod(obj, 'get_subject')
                result = obj.get_subject();
            else
                if isKey(obj.props_, 'subject')
                    result = obj.props_('subject');
                else
                    result = [];
                end
            end
        end
        function obj = set.subject(obj, value)
            obj.props_('subject') = value;
        end
        function result = get.file(obj)
            if ismethod(obj, 'get_file')
                result = obj.get_file();
            else
                if isKey(obj.props_, 'file')
                    result = obj.props_('file');
                else
                    result = [];
                end
            end
        end
        function obj = set.file(obj, value)
            obj.props_('file') = value;
        end
        function result = get.collection(obj)
            if ismethod(obj, 'get_collection')
                result = obj.get_collection();
            else
                if isKey(obj.props_, 'collection')
                    result = obj.props_('collection');
                else
                    result = [];
                end
            end
        end
        function obj = set.collection(obj, value)
            obj.props_('collection') = value;
        end
        function result = get.analysis(obj)
            if ismethod(obj, 'get_analysis')
                result = obj.get_analysis();
            else
                if isKey(obj.props_, 'analysis')
                    result = obj.props_('analysis');
                else
                    result = [];
                end
            end
        end
        function obj = set.analysis(obj, value)
            obj.props_('analysis') = value;
        end
        function result = get.parent(obj)
            if ismethod(obj, 'get_parent')
                result = obj.get_parent();
            else
                if isKey(obj.props_, 'parent')
                    result = obj.props_('parent');
                else
                    result = [];
                end
            end
        end
        function obj = set.parent(obj, value)
            obj.props_('parent') = value;
        end
        function result = get.permissions(obj)
            if ismethod(obj, 'get_permissions')
                result = obj.get_permissions();
            else
                if isKey(obj.props_, 'permissions')
                    result = obj.props_('permissions');
                else
                    result = [];
                end
            end
        end
        function obj = set.permissions(obj, value)
            obj.props_('permissions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'return_type')
                result('return_type') = obj.props_('return_type').toJson();
            end
            if isKey(obj.props_, 'project')
                result('project') = obj.props_('project').toJson();
            end
            if isKey(obj.props_, 'group')
                result('group') = obj.props_('group').toJson();
            end
            if isKey(obj.props_, 'session')
                result('session') = obj.props_('session').toJson();
            end
            if isKey(obj.props_, 'acquisition')
                result('acquisition') = obj.props_('acquisition').toJson();
            end
            if isKey(obj.props_, 'subject')
                result('subject') = obj.props_('subject').toJson();
            end
            if isKey(obj.props_, 'file')
                result('file') = obj.props_('file').toJson();
            end
            if isKey(obj.props_, 'collection')
                result('collection') = obj.props_('collection').toJson();
            end
            if isKey(obj.props_, 'analysis')
                result('analysis') = obj.props_('analysis').toJson();
            end
            if isKey(obj.props_, 'parent')
                result('parent') = obj.props_('parent').toJson();
            end
            if isKey(obj.props_, 'permissions')
                result('permissions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('permissions'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'return_type')
                result.returnType = struct(obj.props_('return_type'));
            else
                result.returnType = [];
            end
            if isKey(obj.props_, 'project')
                result.project = struct(obj.props_('project'));
            else
                result.project = [];
            end
            if isKey(obj.props_, 'group')
                result.group = struct(obj.props_('group'));
            else
                result.group = [];
            end
            if isKey(obj.props_, 'session')
                result.session = struct(obj.props_('session'));
            else
                result.session = [];
            end
            if isKey(obj.props_, 'acquisition')
                result.acquisition = struct(obj.props_('acquisition'));
            else
                result.acquisition = [];
            end
            if isKey(obj.props_, 'subject')
                result.subject = struct(obj.props_('subject'));
            else
                result.subject = [];
            end
            if isKey(obj.props_, 'file')
                result.file = struct(obj.props_('file'));
            else
                result.file = [];
            end
            if isKey(obj.props_, 'collection')
                result.collection = struct(obj.props_('collection'));
            else
                result.collection = [];
            end
            if isKey(obj.props_, 'analysis')
                result.analysis = struct(obj.props_('analysis'));
            else
                result.analysis = [];
            end
            if isKey(obj.props_, 'parent')
                result.parent = struct(obj.props_('parent'));
            else
                result.parent = [];
            end
            if isKey(obj.props_, 'permissions')
                result.permissions = flywheel.ModelBase.cellmap(@struct, obj.props_('permissions'));
            else
                result.permissions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'return_type')
                    propList.returnType = obj.props_('return_type');
                else
                    propList.returnType = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                if isKey(obj.props_, 'acquisition')
                    propList.acquisition = obj.props_('acquisition');
                else
                    propList.acquisition = [];
                end
                if isKey(obj.props_, 'subject')
                    propList.subject = obj.props_('subject');
                else
                    propList.subject = [];
                end
                if isKey(obj.props_, 'file')
                    propList.file = obj.props_('file');
                else
                    propList.file = [];
                end
                if isKey(obj.props_, 'collection')
                    propList.collection = obj.props_('collection');
                else
                    propList.collection = [];
                end
                if isKey(obj.props_, 'analysis')
                    propList.analysis = obj.props_('analysis');
                else
                    propList.analysis = [];
                end
                if isKey(obj.props_, 'parent')
                    propList.parent = obj.props_('parent');
                else
                    propList.parent = [];
                end
                if isKey(obj.props_, 'permissions')
                    propList.permissions = obj.props_('permissions');
                else
                    propList.permissions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SearchResponse;
            if isfield(json, 'return_type')
                obj.props_('return_type') = flywheel.model.SearchReturnType.fromJson(json.return_type, context);
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.model.SearchProjectResponse.fromJson(json.project, context);
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.model.SearchGroupResponse.fromJson(json.group, context);
            end
            if isfield(json, 'session')
                obj.props_('session') = flywheel.model.SearchSessionResponse.fromJson(json.session, context);
            end
            if isfield(json, 'acquisition')
                obj.props_('acquisition') = flywheel.model.SearchAcquisitionResponse.fromJson(json.acquisition, context);
            end
            if isfield(json, 'subject')
                obj.props_('subject') = flywheel.model.SearchSubjectResponse.fromJson(json.subject, context);
            end
            if isfield(json, 'file')
                obj.props_('file') = flywheel.model.SearchFileResponse.fromJson(json.file, context);
            end
            if isfield(json, 'collection')
                obj.props_('collection') = flywheel.model.SearchCollectionResponse.fromJson(json.collection, context);
            end
            if isfield(json, 'analysis')
                obj.props_('analysis') = flywheel.model.SearchAnalysisResponse.fromJson(json.analysis, context);
            end
            if isfield(json, 'parent')
                obj.props_('parent') = flywheel.model.SearchParentResponse.fromJson(json.parent, context);
            end
            if isfield(json, 'permissions')
                obj.props_('permissions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RolesRoleAssignment.fromJson(x, context), json.permissions);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SearchResponse')
                    obj = flywheel.model.SearchResponse(obj);
                end
                if isKey(obj.props_, 'return_type')
                    obj.props_('return_type') =  flywheel.model.SearchReturnType.ensureIsInstance(obj.props_('return_type'));
                end
                if isKey(obj.props_, 'project')
                    obj.props_('project') =  flywheel.model.SearchProjectResponse.ensureIsInstance(obj.props_('project'));
                end
                if isKey(obj.props_, 'group')
                    obj.props_('group') =  flywheel.model.SearchGroupResponse.ensureIsInstance(obj.props_('group'));
                end
                if isKey(obj.props_, 'session')
                    obj.props_('session') =  flywheel.model.SearchSessionResponse.ensureIsInstance(obj.props_('session'));
                end
                if isKey(obj.props_, 'acquisition')
                    obj.props_('acquisition') =  flywheel.model.SearchAcquisitionResponse.ensureIsInstance(obj.props_('acquisition'));
                end
                if isKey(obj.props_, 'subject')
                    obj.props_('subject') =  flywheel.model.SearchSubjectResponse.ensureIsInstance(obj.props_('subject'));
                end
                if isKey(obj.props_, 'file')
                    obj.props_('file') =  flywheel.model.SearchFileResponse.ensureIsInstance(obj.props_('file'));
                end
                if isKey(obj.props_, 'collection')
                    obj.props_('collection') =  flywheel.model.SearchCollectionResponse.ensureIsInstance(obj.props_('collection'));
                end
                if isKey(obj.props_, 'analysis')
                    obj.props_('analysis') =  flywheel.model.SearchAnalysisResponse.ensureIsInstance(obj.props_('analysis'));
                end
                if isKey(obj.props_, 'parent')
                    obj.props_('parent') =  flywheel.model.SearchParentResponse.ensureIsInstance(obj.props_('parent'));
                end
                if isKey(obj.props_, 'permissions')
                    obj.props_('permissions') = flywheel.ModelBase.cellmap(@flywheel.model.RolesRoleAssignment.ensureIsInstance, obj.props_('permissions'));
                end
            end
        end
    end
end
