% SearchStatus
%
% SearchStatus Properties:
%    status   
%    lastSeen  - Last modification time (automatically updated)
%
% SearchStatus Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SearchStatus < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'status', 'lastSeen' }, ...
            { 'status', 'last_seen' });
    end
    properties(Dependent)
        status
        lastSeen
    end
    methods
        function obj = SearchStatus(varargin)
            obj@flywheel.ModelBase(flywheel.model.SearchStatus.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'status', []);
                addParameter(p, 'lastSeen', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.status)
                    obj.props_('status') = p.Results.status;
                end
                if ~isempty(p.Results.lastSeen)
                    obj.props_('last_seen') = p.Results.lastSeen;
                end
            end
        end
        function result = get.status(obj)
            if ismethod(obj, 'get_status')
                result = obj.get_status();
            else
                if isKey(obj.props_, 'status')
                    result = obj.props_('status');
                else
                    result = [];
                end
            end
        end
        function obj = set.status(obj, value)
            obj.props_('status') = value;
        end
        function result = get.lastSeen(obj)
            if ismethod(obj, 'get_lastSeen')
                result = obj.get_lastSeen();
            else
                if isKey(obj.props_, 'last_seen')
                    result = obj.props_('last_seen');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastSeen(obj, value)
            obj.props_('last_seen') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'status')
                result('status') = obj.props_('status').toJson();
            end
            if isKey(obj.props_, 'last_seen')
                result('last_seen') = flywheel.ModelBase.serializeValue(obj.props_('last_seen'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'status')
                result.status = struct(obj.props_('status'));
            else
                result.status = [];
            end
            if isKey(obj.props_, 'last_seen')
                result.lastSeen = obj.props_('last_seen');
            else
                result.lastSeen = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'status')
                    propList.status = obj.props_('status');
                else
                    propList.status = [];
                end
                if isKey(obj.props_, 'last_seen')
                    propList.lastSeen = obj.props_('last_seen');
                else
                    propList.lastSeen = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SearchStatus;
            if isfield(json, 'status')
                obj.props_('status') = flywheel.model.StatusType.fromJson(json.status, context);
            end
            if isfield(json, 'last_seen')
                obj.props_('last_seen') = flywheel.ModelBase.deserializeValue(json.last_seen, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SearchStatus')
                    obj = flywheel.model.SearchStatus(obj);
                end
                if isKey(obj.props_, 'status')
                    obj.props_('status') =  flywheel.model.StatusType.ensureIsInstance(obj.props_('status'));
                end
                if isKey(obj.props_, 'last_seen')
                end
            end
        end
    end
end
