% ServerState
%
% ServerState Properties:
%    activeUser      
%    serverUrl       
%    serverOptionsId 
%    state           
%    progress        
%    progressUrl     
%
% ServerState Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ServerState < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'activeUser', 'serverUrl', 'serverOptionsId', 'state', 'progress', 'progressUrl' }, ...
            { 'active_user', 'server_url', 'server_options_id', 'state', 'progress', 'progress_url' });
    end
    properties(Dependent)
        activeUser
        serverUrl
        serverOptionsId
        state
        progress
        progressUrl
    end
    methods
        function obj = ServerState(varargin)
            obj@flywheel.ModelBase(flywheel.model.ServerState.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'activeUser', []);
                addParameter(p, 'serverUrl', []);
                addParameter(p, 'serverOptionsId', []);
                addParameter(p, 'state', []);
                addParameter(p, 'progress', []);
                addParameter(p, 'progressUrl', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.activeUser)
                    obj.props_('active_user') = p.Results.activeUser;
                end
                if ~isempty(p.Results.serverUrl)
                    obj.props_('server_url') = p.Results.serverUrl;
                end
                if ~isempty(p.Results.serverOptionsId)
                    obj.props_('server_options_id') = p.Results.serverOptionsId;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.progress)
                    obj.props_('progress') = p.Results.progress;
                end
                if ~isempty(p.Results.progressUrl)
                    obj.props_('progress_url') = p.Results.progressUrl;
                end
            end
        end
        function result = get.activeUser(obj)
            if ismethod(obj, 'get_activeUser')
                result = obj.get_activeUser();
            else
                if isKey(obj.props_, 'active_user')
                    result = obj.props_('active_user');
                else
                    result = [];
                end
            end
        end
        function obj = set.activeUser(obj, value)
            obj.props_('active_user') = value;
        end
        function result = get.serverUrl(obj)
            if ismethod(obj, 'get_serverUrl')
                result = obj.get_serverUrl();
            else
                if isKey(obj.props_, 'server_url')
                    result = obj.props_('server_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.serverUrl(obj, value)
            obj.props_('server_url') = value;
        end
        function result = get.serverOptionsId(obj)
            if ismethod(obj, 'get_serverOptionsId')
                result = obj.get_serverOptionsId();
            else
                if isKey(obj.props_, 'server_options_id')
                    result = obj.props_('server_options_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.serverOptionsId(obj, value)
            obj.props_('server_options_id') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.progress(obj)
            if ismethod(obj, 'get_progress')
                result = obj.get_progress();
            else
                if isKey(obj.props_, 'progress')
                    result = obj.props_('progress');
                else
                    result = [];
                end
            end
        end
        function obj = set.progress(obj, value)
            obj.props_('progress') = value;
        end
        function result = get.progressUrl(obj)
            if ismethod(obj, 'get_progressUrl')
                result = obj.get_progressUrl();
            else
                if isKey(obj.props_, 'progress_url')
                    result = obj.props_('progress_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.progressUrl(obj, value)
            obj.props_('progress_url') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'active_user')
                result('active_user') = obj.props_('active_user').toJson();
            end
            if isKey(obj.props_, 'server_url')
                result('server_url') = flywheel.ModelBase.serializeValue(obj.props_('server_url'), 'char');
            end
            if isKey(obj.props_, 'server_options_id')
                result('server_options_id') = flywheel.ModelBase.serializeValue(obj.props_('server_options_id'), 'char');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'progress')
                result('progress') = flywheel.ModelBase.serializeValue(obj.props_('progress'), 'integer');
            end
            if isKey(obj.props_, 'progress_url')
                result('progress_url') = flywheel.ModelBase.serializeValue(obj.props_('progress_url'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'active_user')
                result.activeUser = struct(obj.props_('active_user'));
            else
                result.activeUser = [];
            end
            if isKey(obj.props_, 'server_url')
                result.serverUrl = obj.props_('server_url');
            else
                result.serverUrl = [];
            end
            if isKey(obj.props_, 'server_options_id')
                result.serverOptionsId = obj.props_('server_options_id');
            else
                result.serverOptionsId = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'progress')
                result.progress = obj.props_('progress');
            else
                result.progress = [];
            end
            if isKey(obj.props_, 'progress_url')
                result.progressUrl = obj.props_('progress_url');
            else
                result.progressUrl = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'active_user')
                    propList.activeUser = obj.props_('active_user');
                else
                    propList.activeUser = [];
                end
                if isKey(obj.props_, 'server_url')
                    propList.serverUrl = obj.props_('server_url');
                else
                    propList.serverUrl = [];
                end
                if isKey(obj.props_, 'server_options_id')
                    propList.serverOptionsId = obj.props_('server_options_id');
                else
                    propList.serverOptionsId = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'progress')
                    propList.progress = obj.props_('progress');
                else
                    propList.progress = [];
                end
                if isKey(obj.props_, 'progress_url')
                    propList.progressUrl = obj.props_('progress_url');
                else
                    propList.progressUrl = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ServerState;
            if isfield(json, 'active_user')
                obj.props_('active_user') = flywheel.model.Origin.fromJson(json.active_user, context);
            end
            if isfield(json, 'server_url')
                obj.props_('server_url') = flywheel.ModelBase.deserializeValue(json.server_url, 'char');
            end
            if isfield(json, 'server_options_id')
                obj.props_('server_options_id') = flywheel.ModelBase.deserializeValue(json.server_options_id, 'char');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.AllOfServerStateState.fromJson(json.state, context);
            end
            if isfield(json, 'progress')
                obj.props_('progress') = flywheel.ModelBase.deserializeValue(json.progress, 'integer');
            end
            if isfield(json, 'progress_url')
                obj.props_('progress_url') = flywheel.ModelBase.deserializeValue(json.progress_url, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ServerState')
                    obj = flywheel.model.ServerState(obj);
                end
                if isKey(obj.props_, 'active_user')
                    obj.props_('active_user') =  flywheel.model.Origin.ensureIsInstance(obj.props_('active_user'));
                end
                if isKey(obj.props_, 'server_url')
                end
                if isKey(obj.props_, 'server_options_id')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.AllOfServerStateState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'progress')
                end
                if isKey(obj.props_, 'progress_url')
                end
            end
        end
    end
end
