% ServiceAETInput
%
% ServiceAETInput Properties:
%    aet      - DICOM Application Entity Title
%    created 
%    creator 
%    host     - DICOM service hostname or IP
%    port     - DICOM service port number
%
% ServiceAETInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ServiceAETInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'aet', 'created', 'creator', 'host', 'port' }, ...
            { 'aet', 'created', 'creator', 'host', 'port' });
    end
    properties(Dependent)
        aet
        created
        creator
        host
        port
    end
    methods
        function obj = ServiceAETInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ServiceAETInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'aet', []);
                addParameter(p, 'created', []);
                addParameter(p, 'creator', []);
                addParameter(p, 'host', []);
                addParameter(p, 'port', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.aet)
                    obj.props_('aet') = p.Results.aet;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.creator)
                    obj.props_('creator') = p.Results.creator;
                end
                if ~isempty(p.Results.host)
                    obj.props_('host') = p.Results.host;
                end
                if ~isempty(p.Results.port)
                    obj.props_('port') = p.Results.port;
                end
            end
        end
        function result = get.aet(obj)
            if ismethod(obj, 'get_aet')
                result = obj.get_aet();
            else
                if isKey(obj.props_, 'aet')
                    result = obj.props_('aet');
                else
                    result = [];
                end
            end
        end
        function obj = set.aet(obj, value)
            obj.props_('aet') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.creator(obj)
            if ismethod(obj, 'get_creator')
                result = obj.get_creator();
            else
                if isKey(obj.props_, 'creator')
                    result = obj.props_('creator');
                else
                    result = [];
                end
            end
        end
        function obj = set.creator(obj, value)
            obj.props_('creator') = value;
        end
        function result = get.host(obj)
            if ismethod(obj, 'get_host')
                result = obj.get_host();
            else
                if isKey(obj.props_, 'host')
                    result = obj.props_('host');
                else
                    result = [];
                end
            end
        end
        function obj = set.host(obj, value)
            obj.props_('host') = value;
        end
        function result = get.port(obj)
            if ismethod(obj, 'get_port')
                result = obj.get_port();
            else
                if isKey(obj.props_, 'port')
                    result = obj.props_('port');
                else
                    result = [];
                end
            end
        end
        function obj = set.port(obj, value)
            obj.props_('port') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'aet')
                result('aet') = flywheel.ModelBase.serializeValue(obj.props_('aet'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'creator')
                result('creator') = flywheel.ModelBase.serializeValue(obj.props_('creator'), 'char');
            end
            if isKey(obj.props_, 'host')
                result('host') = flywheel.ModelBase.serializeValue(obj.props_('host'), 'char');
            end
            if isKey(obj.props_, 'port')
                result('port') = flywheel.ModelBase.serializeValue(obj.props_('port'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'aet')
                result.aet = obj.props_('aet');
            else
                result.aet = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'creator')
                result.creator = obj.props_('creator');
            else
                result.creator = [];
            end
            if isKey(obj.props_, 'host')
                result.host = obj.props_('host');
            else
                result.host = [];
            end
            if isKey(obj.props_, 'port')
                result.port = obj.props_('port');
            else
                result.port = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'aet')
                    propList.aet = obj.props_('aet');
                else
                    propList.aet = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'creator')
                    propList.creator = obj.props_('creator');
                else
                    propList.creator = [];
                end
                if isKey(obj.props_, 'host')
                    propList.host = obj.props_('host');
                else
                    propList.host = [];
                end
                if isKey(obj.props_, 'port')
                    propList.port = obj.props_('port');
                else
                    propList.port = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ServiceAETInput;
            if isfield(json, 'aet')
                obj.props_('aet') = flywheel.ModelBase.deserializeValue(json.aet, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'creator')
                obj.props_('creator') = flywheel.ModelBase.deserializeValue(json.creator, 'char');
            end
            if isfield(json, 'host')
                obj.props_('host') = flywheel.ModelBase.deserializeValue(json.host, 'char');
            end
            if isfield(json, 'port')
                obj.props_('port') = flywheel.ModelBase.deserializeValue(json.port, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ServiceAETInput')
                    obj = flywheel.model.ServiceAETInput(obj);
                end
                if isKey(obj.props_, 'aet')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'creator')
                end
                if isKey(obj.props_, 'host')
                end
                if isKey(obj.props_, 'port')
                end
            end
        end
    end
end
