% SessionEmbeddedSubject - Project is not required on embedded subjects but old schema allows it. In this case project is used from the session and the subject found based on lookup order of _id, master_code, code/label. This model is only used on Sessions so it belongs here only If project is provided then we use the identifer code/label for that project to determine the embedded subject
%
% SessionEmbeddedSubject Properties:
%    project    
%    id         
%    masterCode 
%    code       
%    label      
%    age        
%
% SessionEmbeddedSubject Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SessionEmbeddedSubject < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'project', 'id', 'masterCode', 'code', 'label', 'age' }, ...
            { 'project', '_id', 'master_code', 'code', 'label', 'age' });
    end
    properties(Dependent)
        project
        id
        masterCode
        code
        label
        age
    end
    methods
        function obj = SessionEmbeddedSubject(varargin)
            obj@flywheel.ModelBase(flywheel.model.SessionEmbeddedSubject.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'project', []);
                addParameter(p, 'id', []);
                addParameter(p, 'masterCode', []);
                addParameter(p, 'code', []);
                addParameter(p, 'label', []);
                addParameter(p, 'age', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.masterCode)
                    obj.props_('master_code') = p.Results.masterCode;
                end
                if ~isempty(p.Results.code)
                    obj.props_('code') = p.Results.code;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.age)
                    obj.props_('age') = p.Results.age;
                end
            end
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.masterCode(obj)
            if ismethod(obj, 'get_masterCode')
                result = obj.get_masterCode();
            else
                if isKey(obj.props_, 'master_code')
                    result = obj.props_('master_code');
                else
                    result = [];
                end
            end
        end
        function obj = set.masterCode(obj, value)
            obj.props_('master_code') = value;
        end
        function result = get.code(obj)
            if ismethod(obj, 'get_code')
                result = obj.get_code();
            else
                if isKey(obj.props_, 'code')
                    result = obj.props_('code');
                else
                    result = [];
                end
            end
        end
        function obj = set.code(obj, value)
            obj.props_('code') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.age(obj)
            if ismethod(obj, 'get_age')
                result = obj.get_age();
            else
                if isKey(obj.props_, 'age')
                    result = obj.props_('age');
                else
                    result = [];
                end
            end
        end
        function obj = set.age(obj, value)
            obj.props_('age') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'master_code')
                result('master_code') = flywheel.ModelBase.serializeValue(obj.props_('master_code'), 'char');
            end
            if isKey(obj.props_, 'code')
                result('code') = flywheel.ModelBase.serializeValue(obj.props_('code'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'age')
                result('age') = flywheel.ModelBase.serializeValue(obj.props_('age'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'master_code')
                result.masterCode = obj.props_('master_code');
            else
                result.masterCode = [];
            end
            if isKey(obj.props_, 'code')
                result.code = obj.props_('code');
            else
                result.code = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'age')
                result.age = obj.props_('age');
            else
                result.age = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'master_code')
                    propList.masterCode = obj.props_('master_code');
                else
                    propList.masterCode = [];
                end
                if isKey(obj.props_, 'code')
                    propList.code = obj.props_('code');
                else
                    propList.code = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'age')
                    propList.age = obj.props_('age');
                else
                    propList.age = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SessionEmbeddedSubject;
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'master_code')
                obj.props_('master_code') = flywheel.ModelBase.deserializeValue(json.master_code, 'char');
            end
            if isfield(json, 'code')
                obj.props_('code') = flywheel.ModelBase.deserializeValue(json.code, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'age')
                obj.props_('age') = flywheel.ModelBase.deserializeValue(json.age, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SessionEmbeddedSubject')
                    obj = flywheel.model.SessionEmbeddedSubject(obj);
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'master_code')
                end
                if isKey(obj.props_, 'code')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'age')
                end
            end
        end
    end
end
