% SessionModify
%
% SessionModify Properties:
%    timestamp          
%    project            
%    subject            
%    timezone           
%    label              
%    info               
%    tags               
%    permissions        
%    age                
%    weight             
%    operator           
%    projectHasTemplate 
%
% SessionModify Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SessionModify < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'timestamp', 'project', 'subject', 'timezone', 'label', 'info', 'tags', 'permissions', 'age', 'weight', 'operator', 'projectHasTemplate' }, ...
            { 'timestamp', 'project', 'subject', 'timezone', 'label', 'info', 'tags', 'permissions', 'age', 'weight', 'operator', 'project_has_template' });
    end
    properties(Dependent)
        timestamp
        project
        subject
        timezone
        label
        info
        tags
        permissions
        age
        weight
        operator
        projectHasTemplate
    end
    methods
        function obj = SessionModify(varargin)
            obj@flywheel.ModelBase(flywheel.model.SessionModify.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'timestamp', []);
                addParameter(p, 'project', []);
                addParameter(p, 'subject', []);
                addParameter(p, 'timezone', []);
                addParameter(p, 'label', []);
                addParameter(p, 'info', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'permissions', []);
                addParameter(p, 'age', []);
                addParameter(p, 'weight', []);
                addParameter(p, 'operator', []);
                addParameter(p, 'projectHasTemplate', false);

                parse(p, varargin{:});

                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.subject)
                    obj.props_('subject') = p.Results.subject;
                end
                if ~isempty(p.Results.timezone)
                    obj.props_('timezone') = p.Results.timezone;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.permissions)
                    obj.props_('permissions') = p.Results.permissions;
                end
                if ~isempty(p.Results.age)
                    obj.props_('age') = p.Results.age;
                end
                if ~isempty(p.Results.weight)
                    obj.props_('weight') = p.Results.weight;
                end
                if ~isempty(p.Results.operator)
                    obj.props_('operator') = p.Results.operator;
                end
                if ~isempty(p.Results.projectHasTemplate)
                    obj.props_('project_has_template') = p.Results.projectHasTemplate;
                end
            end
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.subject(obj)
            if ismethod(obj, 'get_subject')
                result = obj.get_subject();
            else
                if isKey(obj.props_, 'subject')
                    result = obj.props_('subject');
                else
                    result = [];
                end
            end
        end
        function obj = set.subject(obj, value)
            obj.props_('subject') = value;
        end
        function result = get.timezone(obj)
            if ismethod(obj, 'get_timezone')
                result = obj.get_timezone();
            else
                if isKey(obj.props_, 'timezone')
                    result = obj.props_('timezone');
                else
                    result = [];
                end
            end
        end
        function obj = set.timezone(obj, value)
            obj.props_('timezone') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.permissions(obj)
            if ismethod(obj, 'get_permissions')
                result = obj.get_permissions();
            else
                if isKey(obj.props_, 'permissions')
                    result = obj.props_('permissions');
                else
                    result = [];
                end
            end
        end
        function obj = set.permissions(obj, value)
            obj.props_('permissions') = value;
        end
        function result = get.age(obj)
            if ismethod(obj, 'get_age')
                result = obj.get_age();
            else
                if isKey(obj.props_, 'age')
                    result = obj.props_('age');
                else
                    result = [];
                end
            end
        end
        function obj = set.age(obj, value)
            obj.props_('age') = value;
        end
        function result = get.weight(obj)
            if ismethod(obj, 'get_weight')
                result = obj.get_weight();
            else
                if isKey(obj.props_, 'weight')
                    result = obj.props_('weight');
                else
                    result = [];
                end
            end
        end
        function obj = set.weight(obj, value)
            obj.props_('weight') = value;
        end
        function result = get.operator(obj)
            if ismethod(obj, 'get_operator')
                result = obj.get_operator();
            else
                if isKey(obj.props_, 'operator')
                    result = obj.props_('operator');
                else
                    result = [];
                end
            end
        end
        function obj = set.operator(obj, value)
            obj.props_('operator') = value;
        end
        function result = get.projectHasTemplate(obj)
            if ismethod(obj, 'get_projectHasTemplate')
                result = obj.get_projectHasTemplate();
            else
                if isKey(obj.props_, 'project_has_template')
                    result = obj.props_('project_has_template');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectHasTemplate(obj, value)
            obj.props_('project_has_template') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'subject')
                result('subject') = obj.props_('subject').toJson();
            end
            if isKey(obj.props_, 'timezone')
                result('timezone') = flywheel.ModelBase.serializeValue(obj.props_('timezone'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'permissions')
                result('permissions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('permissions'));
            end
            if isKey(obj.props_, 'age')
                result('age') = flywheel.ModelBase.serializeValue(obj.props_('age'), 'integer');
            end
            if isKey(obj.props_, 'weight')
                result('weight') = flywheel.ModelBase.serializeValue(obj.props_('weight'), 'float');
            end
            if isKey(obj.props_, 'operator')
                result('operator') = flywheel.ModelBase.serializeValue(obj.props_('operator'), 'char');
            end
            if isKey(obj.props_, 'project_has_template')
                result('project_has_template') = flywheel.ModelBase.serializeValue(obj.props_('project_has_template'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'subject')
                result.subject = struct(obj.props_('subject'));
            else
                result.subject = [];
            end
            if isKey(obj.props_, 'timezone')
                result.timezone = obj.props_('timezone');
            else
                result.timezone = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'permissions')
                result.permissions = flywheel.ModelBase.cellmap(@struct, obj.props_('permissions'));
            else
                result.permissions = [];
            end
            if isKey(obj.props_, 'age')
                result.age = obj.props_('age');
            else
                result.age = [];
            end
            if isKey(obj.props_, 'weight')
                result.weight = obj.props_('weight');
            else
                result.weight = [];
            end
            if isKey(obj.props_, 'operator')
                result.operator = obj.props_('operator');
            else
                result.operator = [];
            end
            if isKey(obj.props_, 'project_has_template')
                result.projectHasTemplate = obj.props_('project_has_template');
            else
                result.projectHasTemplate = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'subject')
                    propList.subject = obj.props_('subject');
                else
                    propList.subject = [];
                end
                if isKey(obj.props_, 'timezone')
                    propList.timezone = obj.props_('timezone');
                else
                    propList.timezone = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'permissions')
                    propList.permissions = obj.props_('permissions');
                else
                    propList.permissions = [];
                end
                if isKey(obj.props_, 'age')
                    propList.age = obj.props_('age');
                else
                    propList.age = [];
                end
                if isKey(obj.props_, 'weight')
                    propList.weight = obj.props_('weight');
                else
                    propList.weight = [];
                end
                if isKey(obj.props_, 'operator')
                    propList.operator = obj.props_('operator');
                else
                    propList.operator = [];
                end
                if isKey(obj.props_, 'project_has_template')
                    propList.projectHasTemplate = obj.props_('project_has_template');
                else
                    propList.projectHasTemplate = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SessionModify;
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'subject')
                obj.props_('subject') = flywheel.model.AnyOfSessionModifySubject.fromJson(json.subject, context);
            end
            if isfield(json, 'timezone')
                obj.props_('timezone') = flywheel.ModelBase.deserializeValue(json.timezone, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'permissions')
                obj.props_('permissions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RolePermission.fromJson(x, context), json.permissions);
            end
            if isfield(json, 'age')
                obj.props_('age') = flywheel.ModelBase.deserializeValue(json.age, 'integer');
            end
            if isfield(json, 'weight')
                obj.props_('weight') = flywheel.ModelBase.deserializeValue(json.weight, 'float');
            end
            if isfield(json, 'operator')
                obj.props_('operator') = flywheel.ModelBase.deserializeValue(json.operator, 'char');
            end
            if isfield(json, 'project_has_template')
                obj.props_('project_has_template') = flywheel.ModelBase.deserializeValue(json.project_has_template, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SessionModify')
                    obj = flywheel.model.SessionModify(obj);
                end
                if isKey(obj.props_, 'timestamp')
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'subject')
                    obj.props_('subject') =  flywheel.model.AnyOfSessionModifySubject.ensureIsInstance(obj.props_('subject'));
                end
                if isKey(obj.props_, 'timezone')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'permissions')
                    obj.props_('permissions') = flywheel.ModelBase.cellmap(@flywheel.model.RolePermission.ensureIsInstance, obj.props_('permissions'));
                end
                if isKey(obj.props_, 'age')
                end
                if isKey(obj.props_, 'weight')
                end
                if isKey(obj.props_, 'operator')
                end
                if isKey(obj.props_, 'project_has_template')
                end
            end
        end
    end
end
