% SharingFilterOptions
%
% SharingFilterOptions Properties:
%    therapeuticAreas 
%    bodyRegions      
%    organSystems     
%    ageGroups        
%    measurements     
%    modalities       
%    fileTypes        
%    tags             
%
% SharingFilterOptions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SharingFilterOptions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'therapeuticAreas', 'bodyRegions', 'organSystems', 'ageGroups', 'measurements', 'modalities', 'fileTypes', 'tags' }, ...
            { 'therapeutic_areas', 'body_regions', 'organ_systems', 'age_groups', 'measurements', 'modalities', 'file_types', 'tags' });
    end
    properties(Dependent)
        therapeuticAreas
        bodyRegions
        organSystems
        ageGroups
        measurements
        modalities
        fileTypes
        tags
    end
    methods
        function obj = SharingFilterOptions(varargin)
            obj@flywheel.ModelBase(flywheel.model.SharingFilterOptions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'therapeuticAreas', []);
                addParameter(p, 'bodyRegions', []);
                addParameter(p, 'organSystems', []);
                addParameter(p, 'ageGroups', []);
                addParameter(p, 'measurements', []);
                addParameter(p, 'modalities', []);
                addParameter(p, 'fileTypes', []);
                addParameter(p, 'tags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.therapeuticAreas)
                    obj.props_('therapeutic_areas') = p.Results.therapeuticAreas;
                end
                if ~isempty(p.Results.bodyRegions)
                    obj.props_('body_regions') = p.Results.bodyRegions;
                end
                if ~isempty(p.Results.organSystems)
                    obj.props_('organ_systems') = p.Results.organSystems;
                end
                if ~isempty(p.Results.ageGroups)
                    obj.props_('age_groups') = p.Results.ageGroups;
                end
                if ~isempty(p.Results.measurements)
                    obj.props_('measurements') = p.Results.measurements;
                end
                if ~isempty(p.Results.modalities)
                    obj.props_('modalities') = p.Results.modalities;
                end
                if ~isempty(p.Results.fileTypes)
                    obj.props_('file_types') = p.Results.fileTypes;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
            end
        end
        function result = get.therapeuticAreas(obj)
            if ismethod(obj, 'get_therapeuticAreas')
                result = obj.get_therapeuticAreas();
            else
                if isKey(obj.props_, 'therapeutic_areas')
                    result = obj.props_('therapeutic_areas');
                else
                    result = [];
                end
            end
        end
        function obj = set.therapeuticAreas(obj, value)
            obj.props_('therapeutic_areas') = value;
        end
        function result = get.bodyRegions(obj)
            if ismethod(obj, 'get_bodyRegions')
                result = obj.get_bodyRegions();
            else
                if isKey(obj.props_, 'body_regions')
                    result = obj.props_('body_regions');
                else
                    result = [];
                end
            end
        end
        function obj = set.bodyRegions(obj, value)
            obj.props_('body_regions') = value;
        end
        function result = get.organSystems(obj)
            if ismethod(obj, 'get_organSystems')
                result = obj.get_organSystems();
            else
                if isKey(obj.props_, 'organ_systems')
                    result = obj.props_('organ_systems');
                else
                    result = [];
                end
            end
        end
        function obj = set.organSystems(obj, value)
            obj.props_('organ_systems') = value;
        end
        function result = get.ageGroups(obj)
            if ismethod(obj, 'get_ageGroups')
                result = obj.get_ageGroups();
            else
                if isKey(obj.props_, 'age_groups')
                    result = obj.props_('age_groups');
                else
                    result = [];
                end
            end
        end
        function obj = set.ageGroups(obj, value)
            obj.props_('age_groups') = value;
        end
        function result = get.measurements(obj)
            if ismethod(obj, 'get_measurements')
                result = obj.get_measurements();
            else
                if isKey(obj.props_, 'measurements')
                    result = obj.props_('measurements');
                else
                    result = [];
                end
            end
        end
        function obj = set.measurements(obj, value)
            obj.props_('measurements') = value;
        end
        function result = get.modalities(obj)
            if ismethod(obj, 'get_modalities')
                result = obj.get_modalities();
            else
                if isKey(obj.props_, 'modalities')
                    result = obj.props_('modalities');
                else
                    result = [];
                end
            end
        end
        function obj = set.modalities(obj, value)
            obj.props_('modalities') = value;
        end
        function result = get.fileTypes(obj)
            if ismethod(obj, 'get_fileTypes')
                result = obj.get_fileTypes();
            else
                if isKey(obj.props_, 'file_types')
                    result = obj.props_('file_types');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileTypes(obj, value)
            obj.props_('file_types') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'therapeutic_areas')
                result('therapeutic_areas') = flywheel.ModelBase.serializeValue(obj.props_('therapeutic_areas'), 'vector[char]');
            end
            if isKey(obj.props_, 'body_regions')
                result('body_regions') = flywheel.ModelBase.serializeValue(obj.props_('body_regions'), 'vector[char]');
            end
            if isKey(obj.props_, 'organ_systems')
                result('organ_systems') = flywheel.ModelBase.serializeValue(obj.props_('organ_systems'), 'vector[char]');
            end
            if isKey(obj.props_, 'age_groups')
                result('age_groups') = flywheel.ModelBase.serializeValue(obj.props_('age_groups'), 'vector[char]');
            end
            if isKey(obj.props_, 'measurements')
                result('measurements') = flywheel.ModelBase.serializeValue(obj.props_('measurements'), 'vector[char]');
            end
            if isKey(obj.props_, 'modalities')
                result('modalities') = flywheel.ModelBase.serializeValue(obj.props_('modalities'), 'vector[char]');
            end
            if isKey(obj.props_, 'file_types')
                result('file_types') = flywheel.ModelBase.serializeValue(obj.props_('file_types'), 'vector[char]');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'therapeutic_areas')
                result.therapeuticAreas = obj.props_('therapeutic_areas');
            else
                result.therapeuticAreas = [];
            end
            if isKey(obj.props_, 'body_regions')
                result.bodyRegions = obj.props_('body_regions');
            else
                result.bodyRegions = [];
            end
            if isKey(obj.props_, 'organ_systems')
                result.organSystems = obj.props_('organ_systems');
            else
                result.organSystems = [];
            end
            if isKey(obj.props_, 'age_groups')
                result.ageGroups = obj.props_('age_groups');
            else
                result.ageGroups = [];
            end
            if isKey(obj.props_, 'measurements')
                result.measurements = obj.props_('measurements');
            else
                result.measurements = [];
            end
            if isKey(obj.props_, 'modalities')
                result.modalities = obj.props_('modalities');
            else
                result.modalities = [];
            end
            if isKey(obj.props_, 'file_types')
                result.fileTypes = obj.props_('file_types');
            else
                result.fileTypes = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'therapeutic_areas')
                    propList.therapeuticAreas = obj.props_('therapeutic_areas');
                else
                    propList.therapeuticAreas = [];
                end
                if isKey(obj.props_, 'body_regions')
                    propList.bodyRegions = obj.props_('body_regions');
                else
                    propList.bodyRegions = [];
                end
                if isKey(obj.props_, 'organ_systems')
                    propList.organSystems = obj.props_('organ_systems');
                else
                    propList.organSystems = [];
                end
                if isKey(obj.props_, 'age_groups')
                    propList.ageGroups = obj.props_('age_groups');
                else
                    propList.ageGroups = [];
                end
                if isKey(obj.props_, 'measurements')
                    propList.measurements = obj.props_('measurements');
                else
                    propList.measurements = [];
                end
                if isKey(obj.props_, 'modalities')
                    propList.modalities = obj.props_('modalities');
                else
                    propList.modalities = [];
                end
                if isKey(obj.props_, 'file_types')
                    propList.fileTypes = obj.props_('file_types');
                else
                    propList.fileTypes = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SharingFilterOptions;
            if isfield(json, 'therapeutic_areas')
                obj.props_('therapeutic_areas') = flywheel.ModelBase.deserializeValue(json.therapeutic_areas, 'vector[char]');
            end
            if isfield(json, 'body_regions')
                obj.props_('body_regions') = flywheel.ModelBase.deserializeValue(json.body_regions, 'vector[char]');
            end
            if isfield(json, 'organ_systems')
                obj.props_('organ_systems') = flywheel.ModelBase.deserializeValue(json.organ_systems, 'vector[char]');
            end
            if isfield(json, 'age_groups')
                obj.props_('age_groups') = flywheel.ModelBase.deserializeValue(json.age_groups, 'vector[char]');
            end
            if isfield(json, 'measurements')
                obj.props_('measurements') = flywheel.ModelBase.deserializeValue(json.measurements, 'vector[char]');
            end
            if isfield(json, 'modalities')
                obj.props_('modalities') = flywheel.ModelBase.deserializeValue(json.modalities, 'vector[char]');
            end
            if isfield(json, 'file_types')
                obj.props_('file_types') = flywheel.ModelBase.deserializeValue(json.file_types, 'vector[char]');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SharingFilterOptions')
                    obj = flywheel.model.SharingFilterOptions(obj);
                end
                if isKey(obj.props_, 'therapeutic_areas')
                end
                if isKey(obj.props_, 'body_regions')
                end
                if isKey(obj.props_, 'organ_systems')
                end
                if isKey(obj.props_, 'age_groups')
                end
                if isKey(obj.props_, 'measurements')
                end
                if isKey(obj.props_, 'modalities')
                end
                if isKey(obj.props_, 'file_types')
                end
                if isKey(obj.props_, 'tags')
                end
            end
        end
    end
end
