% SignedUrlCleanupInput - Signed url cleanup input payload schema.
%
% SignedUrlCleanupInput Properties:
%    providerId 
%    uuid       
%
% SignedUrlCleanupInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SignedUrlCleanupInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'providerId', 'uuid' }, ...
            { 'provider_id', 'uuid' });
    end
    properties(Dependent)
        providerId
        uuid
    end
    methods
        function obj = SignedUrlCleanupInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SignedUrlCleanupInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'providerId', []);
                addParameter(p, 'uuid', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.uuid)
                    obj.props_('uuid') = p.Results.uuid;
                end
            end
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.uuid(obj)
            if ismethod(obj, 'get_uuid')
                result = obj.get_uuid();
            else
                if isKey(obj.props_, 'uuid')
                    result = obj.props_('uuid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uuid(obj, value)
            obj.props_('uuid') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'uuid')
                result('uuid') = flywheel.ModelBase.serializeValue(obj.props_('uuid'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'uuid')
                result.uuid = obj.props_('uuid');
            else
                result.uuid = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'uuid')
                    propList.uuid = obj.props_('uuid');
                else
                    propList.uuid = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SignedUrlCleanupInput;
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'uuid')
                obj.props_('uuid') = flywheel.ModelBase.deserializeValue(json.uuid, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SignedUrlCleanupInput')
                    obj = flywheel.model.SignedUrlCleanupInput(obj);
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'uuid')
                end
            end
        end
    end
end
