% SignedUrlUploadOutput - Signed url upload response model.
%
% SignedUrlUploadOutput Properties:
%    providerId          
%    uuid                
%    uploadUrls          
%    uploadHeaders       
%    blockIds            
%    s3MultipartUploadId 
%    azMultipartUploadId 
%    note                
%
% SignedUrlUploadOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SignedUrlUploadOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'providerId', 'uuid', 'uploadUrls', 'uploadHeaders', 'blockIds', 's3MultipartUploadId', 'azMultipartUploadId', 'note' }, ...
            { 'provider_id', 'uuid', 'upload_urls', 'upload_headers', 'block_ids', 's3_multipart_upload_id', 'az_multipart_upload_id', 'note' });
    end
    properties(Dependent)
        providerId
        uuid
        uploadUrls
        uploadHeaders
        blockIds
        s3MultipartUploadId
        azMultipartUploadId
        note
    end
    methods
        function obj = SignedUrlUploadOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SignedUrlUploadOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'providerId', []);
                addParameter(p, 'uuid', []);
                addParameter(p, 'uploadUrls', []);
                addParameter(p, 'uploadHeaders', []);
                addParameter(p, 'blockIds', []);
                addParameter(p, 's3MultipartUploadId', []);
                addParameter(p, 'azMultipartUploadId', []);
                addParameter(p, 'note', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.uuid)
                    obj.props_('uuid') = p.Results.uuid;
                end
                if ~isempty(p.Results.uploadUrls)
                    obj.props_('upload_urls') = p.Results.uploadUrls;
                end
                if ~isempty(p.Results.uploadHeaders)
                    obj.props_('upload_headers') = p.Results.uploadHeaders;
                end
                if ~isempty(p.Results.blockIds)
                    obj.props_('block_ids') = p.Results.blockIds;
                end
                if ~isempty(p.Results.s3MultipartUploadId)
                    obj.props_('s3_multipart_upload_id') = p.Results.s3MultipartUploadId;
                end
                if ~isempty(p.Results.azMultipartUploadId)
                    obj.props_('az_multipart_upload_id') = p.Results.azMultipartUploadId;
                end
                if ~isempty(p.Results.note)
                    obj.props_('note') = p.Results.note;
                end
            end
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.uuid(obj)
            if ismethod(obj, 'get_uuid')
                result = obj.get_uuid();
            else
                if isKey(obj.props_, 'uuid')
                    result = obj.props_('uuid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uuid(obj, value)
            obj.props_('uuid') = value;
        end
        function result = get.uploadUrls(obj)
            if ismethod(obj, 'get_uploadUrls')
                result = obj.get_uploadUrls();
            else
                if isKey(obj.props_, 'upload_urls')
                    result = obj.props_('upload_urls');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadUrls(obj, value)
            obj.props_('upload_urls') = value;
        end
        function result = get.uploadHeaders(obj)
            if ismethod(obj, 'get_uploadHeaders')
                result = obj.get_uploadHeaders();
            else
                if isKey(obj.props_, 'upload_headers')
                    result = obj.props_('upload_headers');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadHeaders(obj, value)
            obj.props_('upload_headers') = value;
        end
        function result = get.blockIds(obj)
            if ismethod(obj, 'get_blockIds')
                result = obj.get_blockIds();
            else
                if isKey(obj.props_, 'block_ids')
                    result = obj.props_('block_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.blockIds(obj, value)
            obj.props_('block_ids') = value;
        end
        function result = get.s3MultipartUploadId(obj)
            if ismethod(obj, 'get_s3MultipartUploadId')
                result = obj.get_s3MultipartUploadId();
            else
                if isKey(obj.props_, 's3_multipart_upload_id')
                    result = obj.props_('s3_multipart_upload_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.s3MultipartUploadId(obj, value)
            obj.props_('s3_multipart_upload_id') = value;
        end
        function result = get.azMultipartUploadId(obj)
            if ismethod(obj, 'get_azMultipartUploadId')
                result = obj.get_azMultipartUploadId();
            else
                if isKey(obj.props_, 'az_multipart_upload_id')
                    result = obj.props_('az_multipart_upload_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.azMultipartUploadId(obj, value)
            obj.props_('az_multipart_upload_id') = value;
        end
        function result = get.note(obj)
            if ismethod(obj, 'get_note')
                result = obj.get_note();
            else
                if isKey(obj.props_, 'note')
                    result = obj.props_('note');
                else
                    result = [];
                end
            end
        end
        function obj = set.note(obj, value)
            obj.props_('note') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'uuid')
                result('uuid') = flywheel.ModelBase.serializeValue(obj.props_('uuid'), 'char');
            end
            if isKey(obj.props_, 'upload_urls')
                result('upload_urls') = flywheel.ModelBase.serializeValue(obj.props_('upload_urls'), 'vector[char]');
            end
            if isKey(obj.props_, 'upload_headers')
                result('upload_headers') = flywheel.ModelBase.serializeValue(obj.props_('upload_headers'), 'containers.Map[String, char]');
            end
            if isKey(obj.props_, 'block_ids')
                result('block_ids') = flywheel.ModelBase.serializeValue(obj.props_('block_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 's3_multipart_upload_id')
                result('s3_multipart_upload_id') = flywheel.ModelBase.serializeValue(obj.props_('s3_multipart_upload_id'), 'char');
            end
            if isKey(obj.props_, 'az_multipart_upload_id')
                result('az_multipart_upload_id') = flywheel.ModelBase.serializeValue(obj.props_('az_multipart_upload_id'), 'char');
            end
            if isKey(obj.props_, 'note')
                result('note') = flywheel.ModelBase.serializeValue(obj.props_('note'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'uuid')
                result.uuid = obj.props_('uuid');
            else
                result.uuid = [];
            end
            if isKey(obj.props_, 'upload_urls')
                result.uploadUrls = obj.props_('upload_urls');
            else
                result.uploadUrls = [];
            end
            if isKey(obj.props_, 'upload_headers')
                result.uploadHeaders = obj.props_('upload_headers');
            else
                result.uploadHeaders = [];
            end
            if isKey(obj.props_, 'block_ids')
                result.blockIds = obj.props_('block_ids');
            else
                result.blockIds = [];
            end
            if isKey(obj.props_, 's3_multipart_upload_id')
                result.s3MultipartUploadId = obj.props_('s3_multipart_upload_id');
            else
                result.s3MultipartUploadId = [];
            end
            if isKey(obj.props_, 'az_multipart_upload_id')
                result.azMultipartUploadId = obj.props_('az_multipart_upload_id');
            else
                result.azMultipartUploadId = [];
            end
            if isKey(obj.props_, 'note')
                result.note = obj.props_('note');
            else
                result.note = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'uuid')
                    propList.uuid = obj.props_('uuid');
                else
                    propList.uuid = [];
                end
                if isKey(obj.props_, 'upload_urls')
                    propList.uploadUrls = obj.props_('upload_urls');
                else
                    propList.uploadUrls = [];
                end
                if isKey(obj.props_, 'upload_headers')
                    propList.uploadHeaders = obj.props_('upload_headers');
                else
                    propList.uploadHeaders = [];
                end
                if isKey(obj.props_, 'block_ids')
                    propList.blockIds = obj.props_('block_ids');
                else
                    propList.blockIds = [];
                end
                if isKey(obj.props_, 's3_multipart_upload_id')
                    propList.s3MultipartUploadId = obj.props_('s3_multipart_upload_id');
                else
                    propList.s3MultipartUploadId = [];
                end
                if isKey(obj.props_, 'az_multipart_upload_id')
                    propList.azMultipartUploadId = obj.props_('az_multipart_upload_id');
                else
                    propList.azMultipartUploadId = [];
                end
                if isKey(obj.props_, 'note')
                    propList.note = obj.props_('note');
                else
                    propList.note = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SignedUrlUploadOutput;
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'uuid')
                obj.props_('uuid') = flywheel.ModelBase.deserializeValue(json.uuid, 'char');
            end
            if isfield(json, 'upload_urls')
                obj.props_('upload_urls') = flywheel.ModelBase.deserializeValue(json.upload_urls, 'vector[char]');
            end
            if isfield(json, 'upload_headers')
                obj.props_('upload_headers') = flywheel.ModelBase.deserializeValue(json.upload_headers, 'containers.Map[String, char]');
            end
            if isfield(json, 'block_ids')
                obj.props_('block_ids') = flywheel.ModelBase.deserializeValue(json.block_ids, 'vector[char]');
            end
            if isfield(json, 's3_multipart_upload_id')
                obj.props_('s3_multipart_upload_id') = flywheel.ModelBase.deserializeValue(json.s3_multipart_upload_id, 'char');
            end
            if isfield(json, 'az_multipart_upload_id')
                obj.props_('az_multipart_upload_id') = flywheel.ModelBase.deserializeValue(json.az_multipart_upload_id, 'char');
            end
            if isfield(json, 'note')
                obj.props_('note') = flywheel.ModelBase.deserializeValue(json.note, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SignedUrlUploadOutput')
                    obj = flywheel.model.SignedUrlUploadOutput(obj);
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'uuid')
                end
                if isKey(obj.props_, 'upload_urls')
                end
                if isKey(obj.props_, 'upload_headers')
                end
                if isKey(obj.props_, 'block_ids')
                end
                if isKey(obj.props_, 's3_multipart_upload_id')
                end
                if isKey(obj.props_, 'az_multipart_upload_id')
                end
                if isKey(obj.props_, 'note')
                end
            end
        end
    end
end
