% Site
%
% Site Properties:
%    id                 
%    apiUrl             
%    centralUrl         
%    deidLogUrl         
%    dimseHost          
%    dimsePort          
%    mfaCodeLength      
%    inactivityTimeout  
%    name               
%    redirectUrl        
%    registered         
%    sslCert            
%    uploadMaximumBytes 
%    proxyCdn           
%    gravatarAddress    
%    paginationLimit    
%
% Site Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Site < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'apiUrl', 'centralUrl', 'deidLogUrl', 'dimseHost', 'dimsePort', 'mfaCodeLength', 'inactivityTimeout', 'name', 'redirectUrl', 'registered', 'sslCert', 'uploadMaximumBytes', 'proxyCdn', 'gravatarAddress', 'paginationLimit' }, ...
            { 'id', 'api_url', 'central_url', 'deid_log_url', 'dimse_host', 'dimse_port', 'mfa_code_length', 'inactivity_timeout', 'name', 'redirect_url', 'registered', 'ssl_cert', 'upload_maximum_bytes', 'proxy_cdn', 'gravatar_address', 'pagination_limit' });
    end
    properties(Dependent)
        id
        apiUrl
        centralUrl
        deidLogUrl
        dimseHost
        dimsePort
        mfaCodeLength
        inactivityTimeout
        name
        redirectUrl
        registered
        sslCert
        uploadMaximumBytes
        proxyCdn
        gravatarAddress
        paginationLimit
    end
    methods
        function obj = Site(varargin)
            obj@flywheel.ModelBase(flywheel.model.Site.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', &#x27;local&#x27;);
                addParameter(p, 'apiUrl', &#x27;https://localhost/api&#x27;);
                addParameter(p, 'centralUrl', &#x27;https://sdmc.scitran.io/api&#x27;);
                addParameter(p, 'deidLogUrl', []);
                addParameter(p, 'dimseHost', []);
                addParameter(p, 'dimsePort', []);
                addParameter(p, 'mfaCodeLength', 6);
                addParameter(p, 'inactivityTimeout', []);
                addParameter(p, 'name', &#x27;Local&#x27;);
                addParameter(p, 'redirectUrl', &#x27;https://local.flywheel.io&#x27;);
                addParameter(p, 'registered', false);
                addParameter(p, 'sslCert', []);
                addParameter(p, 'uploadMaximumBytes', &#x27;10737418240&#x27;);
                addParameter(p, 'proxyCdn', false);
                addParameter(p, 'gravatarAddress', &#x27;https://gravatar.com&#x27;);
                addParameter(p, 'paginationLimit', 100);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.apiUrl)
                    obj.props_('api_url') = p.Results.apiUrl;
                end
                if ~isempty(p.Results.centralUrl)
                    obj.props_('central_url') = p.Results.centralUrl;
                end
                if ~isempty(p.Results.deidLogUrl)
                    obj.props_('deid_log_url') = p.Results.deidLogUrl;
                end
                if ~isempty(p.Results.dimseHost)
                    obj.props_('dimse_host') = p.Results.dimseHost;
                end
                if ~isempty(p.Results.dimsePort)
                    obj.props_('dimse_port') = p.Results.dimsePort;
                end
                if ~isempty(p.Results.mfaCodeLength)
                    obj.props_('mfa_code_length') = p.Results.mfaCodeLength;
                end
                if ~isempty(p.Results.inactivityTimeout)
                    obj.props_('inactivity_timeout') = p.Results.inactivityTimeout;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.redirectUrl)
                    obj.props_('redirect_url') = p.Results.redirectUrl;
                end
                if ~isempty(p.Results.registered)
                    obj.props_('registered') = p.Results.registered;
                end
                if ~isempty(p.Results.sslCert)
                    obj.props_('ssl_cert') = p.Results.sslCert;
                end
                if ~isempty(p.Results.uploadMaximumBytes)
                    obj.props_('upload_maximum_bytes') = p.Results.uploadMaximumBytes;
                end
                if ~isempty(p.Results.proxyCdn)
                    obj.props_('proxy_cdn') = p.Results.proxyCdn;
                end
                if ~isempty(p.Results.gravatarAddress)
                    obj.props_('gravatar_address') = p.Results.gravatarAddress;
                end
                if ~isempty(p.Results.paginationLimit)
                    obj.props_('pagination_limit') = p.Results.paginationLimit;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.apiUrl(obj)
            if ismethod(obj, 'get_apiUrl')
                result = obj.get_apiUrl();
            else
                if isKey(obj.props_, 'api_url')
                    result = obj.props_('api_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.apiUrl(obj, value)
            obj.props_('api_url') = value;
        end
        function result = get.centralUrl(obj)
            if ismethod(obj, 'get_centralUrl')
                result = obj.get_centralUrl();
            else
                if isKey(obj.props_, 'central_url')
                    result = obj.props_('central_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralUrl(obj, value)
            obj.props_('central_url') = value;
        end
        function result = get.deidLogUrl(obj)
            if ismethod(obj, 'get_deidLogUrl')
                result = obj.get_deidLogUrl();
            else
                if isKey(obj.props_, 'deid_log_url')
                    result = obj.props_('deid_log_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidLogUrl(obj, value)
            obj.props_('deid_log_url') = value;
        end
        function result = get.dimseHost(obj)
            if ismethod(obj, 'get_dimseHost')
                result = obj.get_dimseHost();
            else
                if isKey(obj.props_, 'dimse_host')
                    result = obj.props_('dimse_host');
                else
                    result = [];
                end
            end
        end
        function obj = set.dimseHost(obj, value)
            obj.props_('dimse_host') = value;
        end
        function result = get.dimsePort(obj)
            if ismethod(obj, 'get_dimsePort')
                result = obj.get_dimsePort();
            else
                if isKey(obj.props_, 'dimse_port')
                    result = obj.props_('dimse_port');
                else
                    result = [];
                end
            end
        end
        function obj = set.dimsePort(obj, value)
            obj.props_('dimse_port') = value;
        end
        function result = get.mfaCodeLength(obj)
            if ismethod(obj, 'get_mfaCodeLength')
                result = obj.get_mfaCodeLength();
            else
                if isKey(obj.props_, 'mfa_code_length')
                    result = obj.props_('mfa_code_length');
                else
                    result = [];
                end
            end
        end
        function obj = set.mfaCodeLength(obj, value)
            obj.props_('mfa_code_length') = value;
        end
        function result = get.inactivityTimeout(obj)
            if ismethod(obj, 'get_inactivityTimeout')
                result = obj.get_inactivityTimeout();
            else
                if isKey(obj.props_, 'inactivity_timeout')
                    result = obj.props_('inactivity_timeout');
                else
                    result = [];
                end
            end
        end
        function obj = set.inactivityTimeout(obj, value)
            obj.props_('inactivity_timeout') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.redirectUrl(obj)
            if ismethod(obj, 'get_redirectUrl')
                result = obj.get_redirectUrl();
            else
                if isKey(obj.props_, 'redirect_url')
                    result = obj.props_('redirect_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.redirectUrl(obj, value)
            obj.props_('redirect_url') = value;
        end
        function result = get.registered(obj)
            if ismethod(obj, 'get_registered')
                result = obj.get_registered();
            else
                if isKey(obj.props_, 'registered')
                    result = obj.props_('registered');
                else
                    result = [];
                end
            end
        end
        function obj = set.registered(obj, value)
            obj.props_('registered') = value;
        end
        function result = get.sslCert(obj)
            if ismethod(obj, 'get_sslCert')
                result = obj.get_sslCert();
            else
                if isKey(obj.props_, 'ssl_cert')
                    result = obj.props_('ssl_cert');
                else
                    result = [];
                end
            end
        end
        function obj = set.sslCert(obj, value)
            obj.props_('ssl_cert') = value;
        end
        function result = get.uploadMaximumBytes(obj)
            if ismethod(obj, 'get_uploadMaximumBytes')
                result = obj.get_uploadMaximumBytes();
            else
                if isKey(obj.props_, 'upload_maximum_bytes')
                    result = obj.props_('upload_maximum_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadMaximumBytes(obj, value)
            obj.props_('upload_maximum_bytes') = value;
        end
        function result = get.proxyCdn(obj)
            if ismethod(obj, 'get_proxyCdn')
                result = obj.get_proxyCdn();
            else
                if isKey(obj.props_, 'proxy_cdn')
                    result = obj.props_('proxy_cdn');
                else
                    result = [];
                end
            end
        end
        function obj = set.proxyCdn(obj, value)
            obj.props_('proxy_cdn') = value;
        end
        function result = get.gravatarAddress(obj)
            if ismethod(obj, 'get_gravatarAddress')
                result = obj.get_gravatarAddress();
            else
                if isKey(obj.props_, 'gravatar_address')
                    result = obj.props_('gravatar_address');
                else
                    result = [];
                end
            end
        end
        function obj = set.gravatarAddress(obj, value)
            obj.props_('gravatar_address') = value;
        end
        function result = get.paginationLimit(obj)
            if ismethod(obj, 'get_paginationLimit')
                result = obj.get_paginationLimit();
            else
                if isKey(obj.props_, 'pagination_limit')
                    result = obj.props_('pagination_limit');
                else
                    result = [];
                end
            end
        end
        function obj = set.paginationLimit(obj, value)
            obj.props_('pagination_limit') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'api_url')
                result('api_url') = flywheel.ModelBase.serializeValue(obj.props_('api_url'), 'char');
            end
            if isKey(obj.props_, 'central_url')
                result('central_url') = flywheel.ModelBase.serializeValue(obj.props_('central_url'), 'char');
            end
            if isKey(obj.props_, 'deid_log_url')
                result('deid_log_url') = flywheel.ModelBase.serializeValue(obj.props_('deid_log_url'), 'char');
            end
            if isKey(obj.props_, 'dimse_host')
                result('dimse_host') = flywheel.ModelBase.serializeValue(obj.props_('dimse_host'), 'char');
            end
            if isKey(obj.props_, 'dimse_port')
                result('dimse_port') = flywheel.ModelBase.serializeValue(obj.props_('dimse_port'), 'integer');
            end
            if isKey(obj.props_, 'mfa_code_length')
                result('mfa_code_length') = flywheel.ModelBase.serializeValue(obj.props_('mfa_code_length'), 'integer');
            end
            if isKey(obj.props_, 'inactivity_timeout')
                result('inactivity_timeout') = flywheel.ModelBase.serializeValue(obj.props_('inactivity_timeout'), 'integer');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'redirect_url')
                result('redirect_url') = flywheel.ModelBase.serializeValue(obj.props_('redirect_url'), 'char');
            end
            if isKey(obj.props_, 'registered')
                result('registered') = flywheel.ModelBase.serializeValue(obj.props_('registered'), 'logical');
            end
            if isKey(obj.props_, 'ssl_cert')
                result('ssl_cert') = flywheel.ModelBase.serializeValue(obj.props_('ssl_cert'), 'char');
            end
            if isKey(obj.props_, 'upload_maximum_bytes')
                result('upload_maximum_bytes') = flywheel.ModelBase.serializeValue(obj.props_('upload_maximum_bytes'), 'char');
            end
            if isKey(obj.props_, 'proxy_cdn')
                result('proxy_cdn') = flywheel.ModelBase.serializeValue(obj.props_('proxy_cdn'), 'logical');
            end
            if isKey(obj.props_, 'gravatar_address')
                result('gravatar_address') = flywheel.ModelBase.serializeValue(obj.props_('gravatar_address'), 'char');
            end
            if isKey(obj.props_, 'pagination_limit')
                result('pagination_limit') = flywheel.ModelBase.serializeValue(obj.props_('pagination_limit'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'api_url')
                result.apiUrl = obj.props_('api_url');
            else
                result.apiUrl = [];
            end
            if isKey(obj.props_, 'central_url')
                result.centralUrl = obj.props_('central_url');
            else
                result.centralUrl = [];
            end
            if isKey(obj.props_, 'deid_log_url')
                result.deidLogUrl = obj.props_('deid_log_url');
            else
                result.deidLogUrl = [];
            end
            if isKey(obj.props_, 'dimse_host')
                result.dimseHost = obj.props_('dimse_host');
            else
                result.dimseHost = [];
            end
            if isKey(obj.props_, 'dimse_port')
                result.dimsePort = obj.props_('dimse_port');
            else
                result.dimsePort = [];
            end
            if isKey(obj.props_, 'mfa_code_length')
                result.mfaCodeLength = obj.props_('mfa_code_length');
            else
                result.mfaCodeLength = [];
            end
            if isKey(obj.props_, 'inactivity_timeout')
                result.inactivityTimeout = obj.props_('inactivity_timeout');
            else
                result.inactivityTimeout = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'redirect_url')
                result.redirectUrl = obj.props_('redirect_url');
            else
                result.redirectUrl = [];
            end
            if isKey(obj.props_, 'registered')
                result.registered = obj.props_('registered');
            else
                result.registered = [];
            end
            if isKey(obj.props_, 'ssl_cert')
                result.sslCert = obj.props_('ssl_cert');
            else
                result.sslCert = [];
            end
            if isKey(obj.props_, 'upload_maximum_bytes')
                result.uploadMaximumBytes = obj.props_('upload_maximum_bytes');
            else
                result.uploadMaximumBytes = [];
            end
            if isKey(obj.props_, 'proxy_cdn')
                result.proxyCdn = obj.props_('proxy_cdn');
            else
                result.proxyCdn = [];
            end
            if isKey(obj.props_, 'gravatar_address')
                result.gravatarAddress = obj.props_('gravatar_address');
            else
                result.gravatarAddress = [];
            end
            if isKey(obj.props_, 'pagination_limit')
                result.paginationLimit = obj.props_('pagination_limit');
            else
                result.paginationLimit = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'api_url')
                    propList.apiUrl = obj.props_('api_url');
                else
                    propList.apiUrl = [];
                end
                if isKey(obj.props_, 'central_url')
                    propList.centralUrl = obj.props_('central_url');
                else
                    propList.centralUrl = [];
                end
                if isKey(obj.props_, 'deid_log_url')
                    propList.deidLogUrl = obj.props_('deid_log_url');
                else
                    propList.deidLogUrl = [];
                end
                if isKey(obj.props_, 'dimse_host')
                    propList.dimseHost = obj.props_('dimse_host');
                else
                    propList.dimseHost = [];
                end
                if isKey(obj.props_, 'dimse_port')
                    propList.dimsePort = obj.props_('dimse_port');
                else
                    propList.dimsePort = [];
                end
                if isKey(obj.props_, 'mfa_code_length')
                    propList.mfaCodeLength = obj.props_('mfa_code_length');
                else
                    propList.mfaCodeLength = [];
                end
                if isKey(obj.props_, 'inactivity_timeout')
                    propList.inactivityTimeout = obj.props_('inactivity_timeout');
                else
                    propList.inactivityTimeout = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'redirect_url')
                    propList.redirectUrl = obj.props_('redirect_url');
                else
                    propList.redirectUrl = [];
                end
                if isKey(obj.props_, 'registered')
                    propList.registered = obj.props_('registered');
                else
                    propList.registered = [];
                end
                if isKey(obj.props_, 'ssl_cert')
                    propList.sslCert = obj.props_('ssl_cert');
                else
                    propList.sslCert = [];
                end
                if isKey(obj.props_, 'upload_maximum_bytes')
                    propList.uploadMaximumBytes = obj.props_('upload_maximum_bytes');
                else
                    propList.uploadMaximumBytes = [];
                end
                if isKey(obj.props_, 'proxy_cdn')
                    propList.proxyCdn = obj.props_('proxy_cdn');
                else
                    propList.proxyCdn = [];
                end
                if isKey(obj.props_, 'gravatar_address')
                    propList.gravatarAddress = obj.props_('gravatar_address');
                else
                    propList.gravatarAddress = [];
                end
                if isKey(obj.props_, 'pagination_limit')
                    propList.paginationLimit = obj.props_('pagination_limit');
                else
                    propList.paginationLimit = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Site;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'api_url')
                obj.props_('api_url') = flywheel.ModelBase.deserializeValue(json.api_url, 'char');
            end
            if isfield(json, 'central_url')
                obj.props_('central_url') = flywheel.ModelBase.deserializeValue(json.central_url, 'char');
            end
            if isfield(json, 'deid_log_url')
                obj.props_('deid_log_url') = flywheel.ModelBase.deserializeValue(json.deid_log_url, 'char');
            end
            if isfield(json, 'dimse_host')
                obj.props_('dimse_host') = flywheel.ModelBase.deserializeValue(json.dimse_host, 'char');
            end
            if isfield(json, 'dimse_port')
                obj.props_('dimse_port') = flywheel.ModelBase.deserializeValue(json.dimse_port, 'integer');
            end
            if isfield(json, 'mfa_code_length')
                obj.props_('mfa_code_length') = flywheel.ModelBase.deserializeValue(json.mfa_code_length, 'integer');
            end
            if isfield(json, 'inactivity_timeout')
                obj.props_('inactivity_timeout') = flywheel.ModelBase.deserializeValue(json.inactivity_timeout, 'integer');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'redirect_url')
                obj.props_('redirect_url') = flywheel.ModelBase.deserializeValue(json.redirect_url, 'char');
            end
            if isfield(json, 'registered')
                obj.props_('registered') = flywheel.ModelBase.deserializeValue(json.registered, 'logical');
            end
            if isfield(json, 'ssl_cert')
                obj.props_('ssl_cert') = flywheel.ModelBase.deserializeValue(json.ssl_cert, 'char');
            end
            if isfield(json, 'upload_maximum_bytes')
                obj.props_('upload_maximum_bytes') = flywheel.ModelBase.deserializeValue(json.upload_maximum_bytes, 'char');
            end
            if isfield(json, 'proxy_cdn')
                obj.props_('proxy_cdn') = flywheel.ModelBase.deserializeValue(json.proxy_cdn, 'logical');
            end
            if isfield(json, 'gravatar_address')
                obj.props_('gravatar_address') = flywheel.ModelBase.deserializeValue(json.gravatar_address, 'char');
            end
            if isfield(json, 'pagination_limit')
                obj.props_('pagination_limit') = flywheel.ModelBase.deserializeValue(json.pagination_limit, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Site')
                    obj = flywheel.model.Site(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'api_url')
                end
                if isKey(obj.props_, 'central_url')
                end
                if isKey(obj.props_, 'deid_log_url')
                end
                if isKey(obj.props_, 'dimse_host')
                end
                if isKey(obj.props_, 'dimse_port')
                end
                if isKey(obj.props_, 'mfa_code_length')
                end
                if isKey(obj.props_, 'inactivity_timeout')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'redirect_url')
                end
                if isKey(obj.props_, 'registered')
                end
                if isKey(obj.props_, 'ssl_cert')
                end
                if isKey(obj.props_, 'upload_maximum_bytes')
                end
                if isKey(obj.props_, 'proxy_cdn')
                end
                if isKey(obj.props_, 'gravatar_address')
                end
                if isKey(obj.props_, 'pagination_limit')
                end
            end
        end
    end
end
