% SiteSettings
%
% SiteSettings Properties:
%    id          
%    created     
%    modified    
%    centerGears 
%    providers   
%    ldapSync    
%    viewerApps  
%    deidProfile 
%
% SiteSettings Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SiteSettings < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'created', 'modified', 'centerGears', 'providers', 'ldapSync', 'viewerApps', 'deidProfile' }, ...
            { '_id', 'created', 'modified', 'center_gears', 'providers', 'ldap_sync', 'viewer_apps', 'deid_profile' });
    end
    properties(Dependent)
        id
        created
        modified
        centerGears
        providers
        ldapSync
        viewerApps
        deidProfile
    end
    methods
        function obj = SiteSettings(varargin)
            obj@flywheel.ModelBase(flywheel.model.SiteSettings.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', &#x27;site&#x27;);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'centerGears', []);
                addParameter(p, 'providers', []);
                addParameter(p, 'ldapSync', []);
                addParameter(p, 'viewerApps', []);
                addParameter(p, 'deidProfile', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.centerGears)
                    obj.props_('center_gears') = p.Results.centerGears;
                end
                if ~isempty(p.Results.providers)
                    obj.props_('providers') = p.Results.providers;
                end
                if ~isempty(p.Results.ldapSync)
                    obj.props_('ldap_sync') = p.Results.ldapSync;
                end
                if ~isempty(p.Results.viewerApps)
                    obj.props_('viewer_apps') = p.Results.viewerApps;
                end
                if ~isempty(p.Results.deidProfile)
                    obj.props_('deid_profile') = p.Results.deidProfile;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.centerGears(obj)
            if ismethod(obj, 'get_centerGears')
                result = obj.get_centerGears();
            else
                if isKey(obj.props_, 'center_gears')
                    result = obj.props_('center_gears');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerGears(obj, value)
            obj.props_('center_gears') = value;
        end
        function result = get.providers(obj)
            if ismethod(obj, 'get_providers')
                result = obj.get_providers();
            else
                if isKey(obj.props_, 'providers')
                    result = obj.props_('providers');
                else
                    result = [];
                end
            end
        end
        function obj = set.providers(obj, value)
            obj.props_('providers') = value;
        end
        function result = get.ldapSync(obj)
            if ismethod(obj, 'get_ldapSync')
                result = obj.get_ldapSync();
            else
                if isKey(obj.props_, 'ldap_sync')
                    result = obj.props_('ldap_sync');
                else
                    result = [];
                end
            end
        end
        function obj = set.ldapSync(obj, value)
            obj.props_('ldap_sync') = value;
        end
        function result = get.viewerApps(obj)
            if ismethod(obj, 'get_viewerApps')
                result = obj.get_viewerApps();
            else
                if isKey(obj.props_, 'viewer_apps')
                    result = obj.props_('viewer_apps');
                else
                    result = [];
                end
            end
        end
        function obj = set.viewerApps(obj, value)
            obj.props_('viewer_apps') = value;
        end
        function result = get.deidProfile(obj)
            if ismethod(obj, 'get_deidProfile')
                result = obj.get_deidProfile();
            else
                if isKey(obj.props_, 'deid_profile')
                    result = obj.props_('deid_profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidProfile(obj, value)
            obj.props_('deid_profile') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'center_gears')
                result('center_gears') = flywheel.ModelBase.serializeValue(obj.props_('center_gears'), 'vector[char]');
            end
            if isKey(obj.props_, 'providers')
                result('providers') = obj.props_('providers').toJson();
            end
            if isKey(obj.props_, 'ldap_sync')
                result('ldap_sync') = obj.props_('ldap_sync').toJson();
            end
            if isKey(obj.props_, 'viewer_apps')
                result('viewer_apps') = flywheel.ModelBase.cellmap(@toJson, obj.props_('viewer_apps'));
            end
            if isKey(obj.props_, 'deid_profile')
                result('deid_profile') = flywheel.ModelBase.serializeValue(obj.props_('deid_profile'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'center_gears')
                result.centerGears = obj.props_('center_gears');
            else
                result.centerGears = [];
            end
            if isKey(obj.props_, 'providers')
                result.providers = struct(obj.props_('providers'));
            else
                result.providers = [];
            end
            if isKey(obj.props_, 'ldap_sync')
                result.ldapSync = struct(obj.props_('ldap_sync'));
            else
                result.ldapSync = [];
            end
            if isKey(obj.props_, 'viewer_apps')
                result.viewerApps = flywheel.ModelBase.cellmap(@struct, obj.props_('viewer_apps'));
            else
                result.viewerApps = [];
            end
            if isKey(obj.props_, 'deid_profile')
                result.deidProfile = obj.props_('deid_profile');
            else
                result.deidProfile = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'center_gears')
                    propList.centerGears = obj.props_('center_gears');
                else
                    propList.centerGears = [];
                end
                if isKey(obj.props_, 'providers')
                    propList.providers = obj.props_('providers');
                else
                    propList.providers = [];
                end
                if isKey(obj.props_, 'ldap_sync')
                    propList.ldapSync = obj.props_('ldap_sync');
                else
                    propList.ldapSync = [];
                end
                if isKey(obj.props_, 'viewer_apps')
                    propList.viewerApps = obj.props_('viewer_apps');
                else
                    propList.viewerApps = [];
                end
                if isKey(obj.props_, 'deid_profile')
                    propList.deidProfile = obj.props_('deid_profile');
                else
                    propList.deidProfile = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SiteSettings;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'center_gears')
                obj.props_('center_gears') = flywheel.ModelBase.deserializeValue(json.center_gears, 'vector[char]');
            end
            if isfield(json, 'providers')
                obj.props_('providers') = flywheel.model.Providers.fromJson(json.providers, context);
            end
            if isfield(json, 'ldap_sync')
                obj.props_('ldap_sync') = flywheel.model.LdapSyncStatus.fromJson(json.ldap_sync, context);
            end
            if isfield(json, 'viewer_apps')
                obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ViewerApp.fromJson(x, context), json.viewer_apps);
            end
            if isfield(json, 'deid_profile')
                obj.props_('deid_profile') = flywheel.ModelBase.deserializeValue(json.deid_profile, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SiteSettings')
                    obj = flywheel.model.SiteSettings(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'center_gears')
                end
                if isKey(obj.props_, 'providers')
                    obj.props_('providers') =  flywheel.model.Providers.ensureIsInstance(obj.props_('providers'));
                end
                if isKey(obj.props_, 'ldap_sync')
                    obj.props_('ldap_sync') =  flywheel.model.LdapSyncStatus.ensureIsInstance(obj.props_('ldap_sync'));
                end
                if isKey(obj.props_, 'viewer_apps')
                    obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@flywheel.model.ViewerApp.ensureIsInstance, obj.props_('viewer_apps'));
                end
                if isKey(obj.props_, 'deid_profile')
                end
            end
        end
    end
end
