% Sort
%
% Sort Properties:
%    field 
%    order 
%
% Sort Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Sort < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'field', 'order' }, ...
            { 'field', 'order' });
    end
    properties(Dependent)
        field
        order
    end
    methods
        function obj = Sort(varargin)
            obj@flywheel.ModelBase(flywheel.model.Sort.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'field', []);
                addParameter(p, 'order', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.field)
                    obj.props_('field') = p.Results.field;
                end
                if ~isempty(p.Results.order)
                    obj.props_('order') = p.Results.order;
                end
            end
        end
        function result = get.field(obj)
            if ismethod(obj, 'get_field')
                result = obj.get_field();
            else
                if isKey(obj.props_, 'field')
                    result = obj.props_('field');
                else
                    result = [];
                end
            end
        end
        function obj = set.field(obj, value)
            obj.props_('field') = value;
        end
        function result = get.order(obj)
            if ismethod(obj, 'get_order')
                result = obj.get_order();
            else
                if isKey(obj.props_, 'order')
                    result = obj.props_('order');
                else
                    result = [];
                end
            end
        end
        function obj = set.order(obj, value)
            obj.props_('order') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'field')
                result('field') = flywheel.ModelBase.serializeValue(obj.props_('field'), 'char');
            end
            if isKey(obj.props_, 'order')
                result('order') = obj.props_('order').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'field')
                result.field = obj.props_('field');
            else
                result.field = [];
            end
            if isKey(obj.props_, 'order')
                result.order = struct(obj.props_('order'));
            else
                result.order = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'field')
                    propList.field = obj.props_('field');
                else
                    propList.field = [];
                end
                if isKey(obj.props_, 'order')
                    propList.order = obj.props_('order');
                else
                    propList.order = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Sort;
            if isfield(json, 'field')
                obj.props_('field') = flywheel.ModelBase.deserializeValue(json.field, 'char');
            end
            if isfield(json, 'order')
                obj.props_('order') = flywheel.model.Order.fromJson(json.order, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Sort')
                    obj = flywheel.model.Sort(obj);
                end
                if isKey(obj.props_, 'field')
                end
                if isKey(obj.props_, 'order')
                    obj.props_('order') =  flywheel.model.Order.ensureIsInstance(obj.props_('order'));
                end
            end
        end
    end
end
