% StaticCompute
%
% StaticCompute Properties:
%    configType  
%    configClass 
%    tags        
%
% StaticCompute Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef StaticCompute < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'configType', 'configClass', 'tags' }, ...
            { 'config_type', 'config_class', 'tags' });
    end
    properties(Dependent)
        configType
        configClass
        tags
    end
    methods
        function obj = StaticCompute(varargin)
            obj@flywheel.ModelBase(flywheel.model.StaticCompute.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'configType', &#x27;static&#x27;);
                addParameter(p, 'configClass', &#x27;compute&#x27;);
                addParameter(p, 'tags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.configType)
                    obj.props_('config_type') = p.Results.configType;
                end
                if ~isempty(p.Results.configClass)
                    obj.props_('config_class') = p.Results.configClass;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
            end
        end
        function result = get.configType(obj)
            if ismethod(obj, 'get_configType')
                result = obj.get_configType();
            else
                if isKey(obj.props_, 'config_type')
                    result = obj.props_('config_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.configType(obj, value)
            obj.props_('config_type') = value;
        end
        function result = get.configClass(obj)
            if ismethod(obj, 'get_configClass')
                result = obj.get_configClass();
            else
                if isKey(obj.props_, 'config_class')
                    result = obj.props_('config_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.configClass(obj, value)
            obj.props_('config_class') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'config_type')
                result('config_type') = flywheel.ModelBase.serializeValue(obj.props_('config_type'), 'char');
            end
            if isKey(obj.props_, 'config_class')
                result('config_class') = flywheel.ModelBase.serializeValue(obj.props_('config_class'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'config_type')
                result.configType = obj.props_('config_type');
            else
                result.configType = [];
            end
            if isKey(obj.props_, 'config_class')
                result.configClass = obj.props_('config_class');
            else
                result.configClass = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'config_type')
                    propList.configType = obj.props_('config_type');
                else
                    propList.configType = [];
                end
                if isKey(obj.props_, 'config_class')
                    propList.configClass = obj.props_('config_class');
                else
                    propList.configClass = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.StaticCompute;
            if isfield(json, 'config_type')
                obj.props_('config_type') = flywheel.ModelBase.deserializeValue(json.config_type, 'char');
            end
            if isfield(json, 'config_class')
                obj.props_('config_class') = flywheel.ModelBase.deserializeValue(json.config_class, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.StaticCompute')
                    obj = flywheel.model.StaticCompute(obj);
                end
                if isKey(obj.props_, 'config_type')
                end
                if isKey(obj.props_, 'config_class')
                end
                if isKey(obj.props_, 'tags')
                end
            end
        end
    end
end
