% StructuredQuery
%
% StructuredQuery Properties:
%    structuredQuery  - Represents structured query language search
%
% StructuredQuery Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef StructuredQuery < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'structuredQuery' }, ...
            { 'structured_query' });
    end
    properties(Dependent)
        structuredQuery
    end
    methods
        function obj = StructuredQuery(varargin)
            obj@flywheel.ModelBase(flywheel.model.StructuredQuery.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'structuredQuery', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.structuredQuery)
                    obj.props_('structured_query') = p.Results.structuredQuery;
                end
            end
        end
        function result = get.structuredQuery(obj)
            if ismethod(obj, 'get_structuredQuery')
                result = obj.get_structuredQuery();
            else
                if isKey(obj.props_, 'structured_query')
                    result = obj.props_('structured_query');
                else
                    result = [];
                end
            end
        end
        function obj = set.structuredQuery(obj, value)
            obj.props_('structured_query') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'structured_query')
                result('structured_query') = flywheel.ModelBase.serializeValue(obj.props_('structured_query'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'structured_query')
                result.structuredQuery = obj.props_('structured_query');
            else
                result.structuredQuery = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'structured_query')
                    propList.structuredQuery = obj.props_('structured_query');
                else
                    propList.structuredQuery = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.StructuredQuery;
            if isfield(json, 'structured_query')
                obj.props_('structured_query') = flywheel.ModelBase.deserializeValue(json.structured_query, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.StructuredQuery')
                    obj = flywheel.model.StructuredQuery(obj);
                end
                if isKey(obj.props_, 'structured_query')
                end
            end
        end
    end
end
