% StructuredQuerySuggestions
%
% StructuredQuerySuggestions Properties:
%    from         - The starting position for the auto-complete replacement
%    suggestions  - The list of suggested replacements
%
% StructuredQuerySuggestions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef StructuredQuerySuggestions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'from', 'suggestions' }, ...
            { 'from', 'suggestions' });
    end
    properties(Dependent)
        from
        suggestions
    end
    methods
        function obj = StructuredQuerySuggestions(varargin)
            obj@flywheel.ModelBase(flywheel.model.StructuredQuerySuggestions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'from', []);
                addParameter(p, 'suggestions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.from)
                    obj.props_('from') = p.Results.from;
                end
                if ~isempty(p.Results.suggestions)
                    obj.props_('suggestions') = p.Results.suggestions;
                end
            end
        end
        function result = get.from(obj)
            if ismethod(obj, 'get_from')
                result = obj.get_from();
            else
                if isKey(obj.props_, 'from')
                    result = obj.props_('from');
                else
                    result = [];
                end
            end
        end
        function obj = set.from(obj, value)
            obj.props_('from') = value;
        end
        function result = get.suggestions(obj)
            if ismethod(obj, 'get_suggestions')
                result = obj.get_suggestions();
            else
                if isKey(obj.props_, 'suggestions')
                    result = obj.props_('suggestions');
                else
                    result = [];
                end
            end
        end
        function obj = set.suggestions(obj, value)
            obj.props_('suggestions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'from')
                result('from') = flywheel.ModelBase.serializeValue(obj.props_('from'), 'integer');
            end
            if isKey(obj.props_, 'suggestions')
                result('suggestions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('suggestions'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'from')
                result.from = obj.props_('from');
            else
                result.from = [];
            end
            if isKey(obj.props_, 'suggestions')
                result.suggestions = flywheel.ModelBase.cellmap(@struct, obj.props_('suggestions'));
            else
                result.suggestions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'from')
                    propList.from = obj.props_('from');
                else
                    propList.from = [];
                end
                if isKey(obj.props_, 'suggestions')
                    propList.suggestions = obj.props_('suggestions');
                else
                    propList.suggestions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.StructuredQuerySuggestions;
            if isfield(json, 'from')
                obj.props_('from') = flywheel.ModelBase.deserializeValue(json.from, 'integer');
            end
            if isfield(json, 'suggestions')
                obj.props_('suggestions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.StructuredQueryValueSuggestion.fromJson(x, context), json.suggestions);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.StructuredQuerySuggestions')
                    obj = flywheel.model.StructuredQuerySuggestions(obj);
                end
                if isKey(obj.props_, 'from')
                end
                if isKey(obj.props_, 'suggestions')
                    obj.props_('suggestions') = flywheel.ModelBase.cellmap(@flywheel.model.StructuredQueryValueSuggestion.ensureIsInstance, obj.props_('suggestions'));
                end
            end
        end
    end
end
