% SubjectModify
%
% SubjectModify Properties:
%    firstname   
%    lastname    
%    sex         
%    cohort      
%    dateOfBirth 
%    mlset       
%    type        
%    race        
%    ethnicity   
%    species     
%    strain      
%    label       
%    code        
%    masterCode  
%    tags        
%    info        
%    state       
%    project     
%    permissions 
%    notes       
%
% SubjectModify Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SubjectModify < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'firstname', 'lastname', 'sex', 'cohort', 'dateOfBirth', 'mlset', 'type', 'race', 'ethnicity', 'species', 'strain', 'label', 'code', 'masterCode', 'tags', 'info', 'state', 'project', 'permissions', 'notes' }, ...
            { 'firstname', 'lastname', 'sex', 'cohort', 'date_of_birth', 'mlset', 'type', 'race', 'ethnicity', 'species', 'strain', 'label', 'code', 'master_code', 'tags', 'info', 'state', 'project', 'permissions', 'notes' });
    end
    properties(Dependent)
        firstname
        lastname
        sex
        cohort
        dateOfBirth
        mlset
        type
        race
        ethnicity
        species
        strain
        label
        code
        masterCode
        tags
        info
        state
        project
        permissions
        notes
    end
    methods
        function obj = SubjectModify(varargin)
            obj@flywheel.ModelBase(flywheel.model.SubjectModify.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'sex', []);
                addParameter(p, 'cohort', []);
                addParameter(p, 'dateOfBirth', []);
                addParameter(p, 'mlset', []);
                addParameter(p, 'type', []);
                addParameter(p, 'race', []);
                addParameter(p, 'ethnicity', []);
                addParameter(p, 'species', []);
                addParameter(p, 'strain', []);
                addParameter(p, 'label', []);
                addParameter(p, 'code', []);
                addParameter(p, 'masterCode', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'info', []);
                addParameter(p, 'state', []);
                addParameter(p, 'project', []);
                addParameter(p, 'permissions', []);
                addParameter(p, 'notes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.sex)
                    obj.props_('sex') = p.Results.sex;
                end
                if ~isempty(p.Results.cohort)
                    obj.props_('cohort') = p.Results.cohort;
                end
                if ~isempty(p.Results.dateOfBirth)
                    obj.props_('date_of_birth') = p.Results.dateOfBirth;
                end
                if ~isempty(p.Results.mlset)
                    obj.props_('mlset') = p.Results.mlset;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.race)
                    obj.props_('race') = p.Results.race;
                end
                if ~isempty(p.Results.ethnicity)
                    obj.props_('ethnicity') = p.Results.ethnicity;
                end
                if ~isempty(p.Results.species)
                    obj.props_('species') = p.Results.species;
                end
                if ~isempty(p.Results.strain)
                    obj.props_('strain') = p.Results.strain;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.code)
                    obj.props_('code') = p.Results.code;
                end
                if ~isempty(p.Results.masterCode)
                    obj.props_('master_code') = p.Results.masterCode;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.permissions)
                    obj.props_('permissions') = p.Results.permissions;
                end
                if ~isempty(p.Results.notes)
                    obj.props_('notes') = p.Results.notes;
                end
            end
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.sex(obj)
            if ismethod(obj, 'get_sex')
                result = obj.get_sex();
            else
                if isKey(obj.props_, 'sex')
                    result = obj.props_('sex');
                else
                    result = [];
                end
            end
        end
        function obj = set.sex(obj, value)
            obj.props_('sex') = value;
        end
        function result = get.cohort(obj)
            if ismethod(obj, 'get_cohort')
                result = obj.get_cohort();
            else
                if isKey(obj.props_, 'cohort')
                    result = obj.props_('cohort');
                else
                    result = [];
                end
            end
        end
        function obj = set.cohort(obj, value)
            obj.props_('cohort') = value;
        end
        function result = get.dateOfBirth(obj)
            if ismethod(obj, 'get_dateOfBirth')
                result = obj.get_dateOfBirth();
            else
                if isKey(obj.props_, 'date_of_birth')
                    result = obj.props_('date_of_birth');
                else
                    result = [];
                end
            end
        end
        function obj = set.dateOfBirth(obj, value)
            obj.props_('date_of_birth') = value;
        end
        function result = get.mlset(obj)
            if ismethod(obj, 'get_mlset')
                result = obj.get_mlset();
            else
                if isKey(obj.props_, 'mlset')
                    result = obj.props_('mlset');
                else
                    result = [];
                end
            end
        end
        function obj = set.mlset(obj, value)
            obj.props_('mlset') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.race(obj)
            if ismethod(obj, 'get_race')
                result = obj.get_race();
            else
                if isKey(obj.props_, 'race')
                    result = obj.props_('race');
                else
                    result = [];
                end
            end
        end
        function obj = set.race(obj, value)
            obj.props_('race') = value;
        end
        function result = get.ethnicity(obj)
            if ismethod(obj, 'get_ethnicity')
                result = obj.get_ethnicity();
            else
                if isKey(obj.props_, 'ethnicity')
                    result = obj.props_('ethnicity');
                else
                    result = [];
                end
            end
        end
        function obj = set.ethnicity(obj, value)
            obj.props_('ethnicity') = value;
        end
        function result = get.species(obj)
            if ismethod(obj, 'get_species')
                result = obj.get_species();
            else
                if isKey(obj.props_, 'species')
                    result = obj.props_('species');
                else
                    result = [];
                end
            end
        end
        function obj = set.species(obj, value)
            obj.props_('species') = value;
        end
        function result = get.strain(obj)
            if ismethod(obj, 'get_strain')
                result = obj.get_strain();
            else
                if isKey(obj.props_, 'strain')
                    result = obj.props_('strain');
                else
                    result = [];
                end
            end
        end
        function obj = set.strain(obj, value)
            obj.props_('strain') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.code(obj)
            if ismethod(obj, 'get_code')
                result = obj.get_code();
            else
                if isKey(obj.props_, 'code')
                    result = obj.props_('code');
                else
                    result = [];
                end
            end
        end
        function obj = set.code(obj, value)
            obj.props_('code') = value;
        end
        function result = get.masterCode(obj)
            if ismethod(obj, 'get_masterCode')
                result = obj.get_masterCode();
            else
                if isKey(obj.props_, 'master_code')
                    result = obj.props_('master_code');
                else
                    result = [];
                end
            end
        end
        function obj = set.masterCode(obj, value)
            obj.props_('master_code') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.permissions(obj)
            if ismethod(obj, 'get_permissions')
                result = obj.get_permissions();
            else
                if isKey(obj.props_, 'permissions')
                    result = obj.props_('permissions');
                else
                    result = [];
                end
            end
        end
        function obj = set.permissions(obj, value)
            obj.props_('permissions') = value;
        end
        function result = get.notes(obj)
            if ismethod(obj, 'get_notes')
                result = obj.get_notes();
            else
                if isKey(obj.props_, 'notes')
                    result = obj.props_('notes');
                else
                    result = [];
                end
            end
        end
        function obj = set.notes(obj, value)
            obj.props_('notes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'sex')
                result('sex') = flywheel.ModelBase.serializeValue(obj.props_('sex'), 'char');
            end
            if isKey(obj.props_, 'cohort')
                result('cohort') = obj.props_('cohort').toJson();
            end
            if isKey(obj.props_, 'date_of_birth')
                result('date_of_birth') = flywheel.ModelBase.serializeValue(obj.props_('date_of_birth'), 'datetime');
            end
            if isKey(obj.props_, 'mlset')
                result('mlset') = obj.props_('mlset').toJson();
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'race')
                result('race') = flywheel.ModelBase.serializeValue(obj.props_('race'), 'char');
            end
            if isKey(obj.props_, 'ethnicity')
                result('ethnicity') = flywheel.ModelBase.serializeValue(obj.props_('ethnicity'), 'char');
            end
            if isKey(obj.props_, 'species')
                result('species') = flywheel.ModelBase.serializeValue(obj.props_('species'), 'char');
            end
            if isKey(obj.props_, 'strain')
                result('strain') = flywheel.ModelBase.serializeValue(obj.props_('strain'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'code')
                result('code') = flywheel.ModelBase.serializeValue(obj.props_('code'), 'char');
            end
            if isKey(obj.props_, 'master_code')
                result('master_code') = flywheel.ModelBase.serializeValue(obj.props_('master_code'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'permissions')
                result('permissions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('permissions'));
            end
            if isKey(obj.props_, 'notes')
                result('notes') = flywheel.ModelBase.cellmap(@toJson, obj.props_('notes'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'sex')
                result.sex = obj.props_('sex');
            else
                result.sex = [];
            end
            if isKey(obj.props_, 'cohort')
                result.cohort = struct(obj.props_('cohort'));
            else
                result.cohort = [];
            end
            if isKey(obj.props_, 'date_of_birth')
                result.dateOfBirth = obj.props_('date_of_birth');
            else
                result.dateOfBirth = [];
            end
            if isKey(obj.props_, 'mlset')
                result.mlset = struct(obj.props_('mlset'));
            else
                result.mlset = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'race')
                result.race = obj.props_('race');
            else
                result.race = [];
            end
            if isKey(obj.props_, 'ethnicity')
                result.ethnicity = obj.props_('ethnicity');
            else
                result.ethnicity = [];
            end
            if isKey(obj.props_, 'species')
                result.species = obj.props_('species');
            else
                result.species = [];
            end
            if isKey(obj.props_, 'strain')
                result.strain = obj.props_('strain');
            else
                result.strain = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'code')
                result.code = obj.props_('code');
            else
                result.code = [];
            end
            if isKey(obj.props_, 'master_code')
                result.masterCode = obj.props_('master_code');
            else
                result.masterCode = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'permissions')
                result.permissions = flywheel.ModelBase.cellmap(@struct, obj.props_('permissions'));
            else
                result.permissions = [];
            end
            if isKey(obj.props_, 'notes')
                result.notes = flywheel.ModelBase.cellmap(@struct, obj.props_('notes'));
            else
                result.notes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'sex')
                    propList.sex = obj.props_('sex');
                else
                    propList.sex = [];
                end
                if isKey(obj.props_, 'cohort')
                    propList.cohort = obj.props_('cohort');
                else
                    propList.cohort = [];
                end
                if isKey(obj.props_, 'date_of_birth')
                    propList.dateOfBirth = obj.props_('date_of_birth');
                else
                    propList.dateOfBirth = [];
                end
                if isKey(obj.props_, 'mlset')
                    propList.mlset = obj.props_('mlset');
                else
                    propList.mlset = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'race')
                    propList.race = obj.props_('race');
                else
                    propList.race = [];
                end
                if isKey(obj.props_, 'ethnicity')
                    propList.ethnicity = obj.props_('ethnicity');
                else
                    propList.ethnicity = [];
                end
                if isKey(obj.props_, 'species')
                    propList.species = obj.props_('species');
                else
                    propList.species = [];
                end
                if isKey(obj.props_, 'strain')
                    propList.strain = obj.props_('strain');
                else
                    propList.strain = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'code')
                    propList.code = obj.props_('code');
                else
                    propList.code = [];
                end
                if isKey(obj.props_, 'master_code')
                    propList.masterCode = obj.props_('master_code');
                else
                    propList.masterCode = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'permissions')
                    propList.permissions = obj.props_('permissions');
                else
                    propList.permissions = [];
                end
                if isKey(obj.props_, 'notes')
                    propList.notes = obj.props_('notes');
                else
                    propList.notes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SubjectModify;
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'sex')
                obj.props_('sex') = flywheel.ModelBase.deserializeValue(json.sex, 'char');
            end
            if isfield(json, 'cohort')
                obj.props_('cohort') = flywheel.model.Cohort.fromJson(json.cohort, context);
            end
            if isfield(json, 'date_of_birth')
                obj.props_('date_of_birth') = flywheel.ModelBase.deserializeValue(json.date_of_birth, 'datetime');
            end
            if isfield(json, 'mlset')
                obj.props_('mlset') = flywheel.model.MLType.fromJson(json.mlset, context);
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'race')
                obj.props_('race') = flywheel.ModelBase.deserializeValue(json.race, 'char');
            end
            if isfield(json, 'ethnicity')
                obj.props_('ethnicity') = flywheel.ModelBase.deserializeValue(json.ethnicity, 'char');
            end
            if isfield(json, 'species')
                obj.props_('species') = flywheel.ModelBase.deserializeValue(json.species, 'char');
            end
            if isfield(json, 'strain')
                obj.props_('strain') = flywheel.ModelBase.deserializeValue(json.strain, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'code')
                obj.props_('code') = flywheel.ModelBase.deserializeValue(json.code, 'char');
            end
            if isfield(json, 'master_code')
                obj.props_('master_code') = flywheel.ModelBase.deserializeValue(json.master_code, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.SubjectState.fromJson(json.state, context);
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'permissions')
                obj.props_('permissions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RolePermission.fromJson(x, context), json.permissions);
            end
            if isfield(json, 'notes')
                obj.props_('notes') = flywheel.ModelBase.cellmap(@(x) flywheel.model.Note.fromJson(x, context), json.notes);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SubjectModify')
                    obj = flywheel.model.SubjectModify(obj);
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'sex')
                end
                if isKey(obj.props_, 'cohort')
                    obj.props_('cohort') =  flywheel.model.Cohort.ensureIsInstance(obj.props_('cohort'));
                end
                if isKey(obj.props_, 'date_of_birth')
                end
                if isKey(obj.props_, 'mlset')
                    obj.props_('mlset') =  flywheel.model.MLType.ensureIsInstance(obj.props_('mlset'));
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'race')
                end
                if isKey(obj.props_, 'ethnicity')
                end
                if isKey(obj.props_, 'species')
                end
                if isKey(obj.props_, 'strain')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'code')
                end
                if isKey(obj.props_, 'master_code')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.SubjectState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'permissions')
                    obj.props_('permissions') = flywheel.ModelBase.cellmap(@flywheel.model.RolePermission.ensureIsInstance, obj.props_('permissions'));
                end
                if isKey(obj.props_, 'notes')
                    obj.props_('notes') = flywheel.ModelBase.cellmap(@flywheel.model.Note.ensureIsInstance, obj.props_('notes'));
                end
            end
        end
    end
end
