% SubjectTemplateOptions
%
% SubjectTemplateOptions Properties:
%    code 
%    tags 
%
% SubjectTemplateOptions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SubjectTemplateOptions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'code', 'tags' }, ...
            { 'code', 'tags' });
    end
    properties(Dependent)
        code
        tags
    end
    methods
        function obj = SubjectTemplateOptions(varargin)
            obj@flywheel.ModelBase(flywheel.model.SubjectTemplateOptions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'code', []);
                addParameter(p, 'tags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.code)
                    obj.props_('code') = p.Results.code;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
            end
        end
        function result = get.code(obj)
            if ismethod(obj, 'get_code')
                result = obj.get_code();
            else
                if isKey(obj.props_, 'code')
                    result = obj.props_('code');
                else
                    result = [];
                end
            end
        end
        function obj = set.code(obj, value)
            obj.props_('code') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'code')
                result('code') = flywheel.ModelBase.serializeValue(obj.props_('code'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'code')
                result.code = obj.props_('code');
            else
                result.code = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'code')
                    propList.code = obj.props_('code');
                else
                    propList.code = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SubjectTemplateOptions;
            if isfield(json, 'code')
                obj.props_('code') = flywheel.ModelBase.deserializeValue(json.code, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SubjectTemplateOptions')
                    obj = flywheel.model.SubjectTemplateOptions(obj);
                end
                if isKey(obj.props_, 'code')
                end
                if isKey(obj.props_, 'tags')
                end
            end
        end
    end
end
