% SubjectUpsertInput
%
% SubjectUpsertInput Properties:
%    dateOfBirth  
%    id           
%    routingField 
%    label        
%    source       
%    firstname    
%    lastname     
%    sex          
%    type         
%    race         
%    ethnicity    
%    species      
%    strain       
%    info         
%    state        
%
% SubjectUpsertInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SubjectUpsertInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'dateOfBirth', 'id', 'routingField', 'label', 'source', 'firstname', 'lastname', 'sex', 'type', 'race', 'ethnicity', 'species', 'strain', 'info', 'state' }, ...
            { 'date_of_birth', '_id', 'routing_field', 'label', 'source', 'firstname', 'lastname', 'sex', 'type', 'race', 'ethnicity', 'species', 'strain', 'info', 'state' });
    end
    properties(Dependent)
        dateOfBirth
        id
        routingField
        label
        source
        firstname
        lastname
        sex
        type
        race
        ethnicity
        species
        strain
        info
        state
    end
    methods
        function obj = SubjectUpsertInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SubjectUpsertInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'dateOfBirth', []);
                addParameter(p, 'id', []);
                addParameter(p, 'routingField', []);
                addParameter(p, 'label', []);
                addParameter(p, 'source', []);
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'sex', []);
                addParameter(p, 'type', []);
                addParameter(p, 'race', []);
                addParameter(p, 'ethnicity', []);
                addParameter(p, 'species', []);
                addParameter(p, 'strain', []);
                addParameter(p, 'info', []);
                addParameter(p, 'state', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.dateOfBirth)
                    obj.props_('date_of_birth') = p.Results.dateOfBirth;
                end
                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.routingField)
                    obj.props_('routing_field') = p.Results.routingField;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.source)
                    obj.props_('source') = p.Results.source;
                end
                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.sex)
                    obj.props_('sex') = p.Results.sex;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.race)
                    obj.props_('race') = p.Results.race;
                end
                if ~isempty(p.Results.ethnicity)
                    obj.props_('ethnicity') = p.Results.ethnicity;
                end
                if ~isempty(p.Results.species)
                    obj.props_('species') = p.Results.species;
                end
                if ~isempty(p.Results.strain)
                    obj.props_('strain') = p.Results.strain;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
            end
        end
        function result = get.dateOfBirth(obj)
            if ismethod(obj, 'get_dateOfBirth')
                result = obj.get_dateOfBirth();
            else
                if isKey(obj.props_, 'date_of_birth')
                    result = obj.props_('date_of_birth');
                else
                    result = [];
                end
            end
        end
        function obj = set.dateOfBirth(obj, value)
            obj.props_('date_of_birth') = value;
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.routingField(obj)
            if ismethod(obj, 'get_routingField')
                result = obj.get_routingField();
            else
                if isKey(obj.props_, 'routing_field')
                    result = obj.props_('routing_field');
                else
                    result = [];
                end
            end
        end
        function obj = set.routingField(obj, value)
            obj.props_('routing_field') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.source(obj)
            if ismethod(obj, 'get_source')
                result = obj.get_source();
            else
                if isKey(obj.props_, 'source')
                    result = obj.props_('source');
                else
                    result = [];
                end
            end
        end
        function obj = set.source(obj, value)
            obj.props_('source') = value;
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.sex(obj)
            if ismethod(obj, 'get_sex')
                result = obj.get_sex();
            else
                if isKey(obj.props_, 'sex')
                    result = obj.props_('sex');
                else
                    result = [];
                end
            end
        end
        function obj = set.sex(obj, value)
            obj.props_('sex') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.race(obj)
            if ismethod(obj, 'get_race')
                result = obj.get_race();
            else
                if isKey(obj.props_, 'race')
                    result = obj.props_('race');
                else
                    result = [];
                end
            end
        end
        function obj = set.race(obj, value)
            obj.props_('race') = value;
        end
        function result = get.ethnicity(obj)
            if ismethod(obj, 'get_ethnicity')
                result = obj.get_ethnicity();
            else
                if isKey(obj.props_, 'ethnicity')
                    result = obj.props_('ethnicity');
                else
                    result = [];
                end
            end
        end
        function obj = set.ethnicity(obj, value)
            obj.props_('ethnicity') = value;
        end
        function result = get.species(obj)
            if ismethod(obj, 'get_species')
                result = obj.get_species();
            else
                if isKey(obj.props_, 'species')
                    result = obj.props_('species');
                else
                    result = [];
                end
            end
        end
        function obj = set.species(obj, value)
            obj.props_('species') = value;
        end
        function result = get.strain(obj)
            if ismethod(obj, 'get_strain')
                result = obj.get_strain();
            else
                if isKey(obj.props_, 'strain')
                    result = obj.props_('strain');
                else
                    result = [];
                end
            end
        end
        function obj = set.strain(obj, value)
            obj.props_('strain') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'date_of_birth')
                result('date_of_birth') = flywheel.ModelBase.serializeValue(obj.props_('date_of_birth'), 'datetime');
            end
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'routing_field')
                result('routing_field') = flywheel.ModelBase.serializeValue(obj.props_('routing_field'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'source')
                result('source') = obj.props_('source').toJson();
            end
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'sex')
                result('sex') = flywheel.ModelBase.serializeValue(obj.props_('sex'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'race')
                result('race') = flywheel.ModelBase.serializeValue(obj.props_('race'), 'char');
            end
            if isKey(obj.props_, 'ethnicity')
                result('ethnicity') = flywheel.ModelBase.serializeValue(obj.props_('ethnicity'), 'char');
            end
            if isKey(obj.props_, 'species')
                result('species') = flywheel.ModelBase.serializeValue(obj.props_('species'), 'char');
            end
            if isKey(obj.props_, 'strain')
                result('strain') = flywheel.ModelBase.serializeValue(obj.props_('strain'), 'char');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'date_of_birth')
                result.dateOfBirth = obj.props_('date_of_birth');
            else
                result.dateOfBirth = [];
            end
            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'routing_field')
                result.routingField = obj.props_('routing_field');
            else
                result.routingField = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'source')
                result.source = struct(obj.props_('source'));
            else
                result.source = [];
            end
            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'sex')
                result.sex = obj.props_('sex');
            else
                result.sex = [];
            end
            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'race')
                result.race = obj.props_('race');
            else
                result.race = [];
            end
            if isKey(obj.props_, 'ethnicity')
                result.ethnicity = obj.props_('ethnicity');
            else
                result.ethnicity = [];
            end
            if isKey(obj.props_, 'species')
                result.species = obj.props_('species');
            else
                result.species = [];
            end
            if isKey(obj.props_, 'strain')
                result.strain = obj.props_('strain');
            else
                result.strain = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'date_of_birth')
                    propList.dateOfBirth = obj.props_('date_of_birth');
                else
                    propList.dateOfBirth = [];
                end
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'routing_field')
                    propList.routingField = obj.props_('routing_field');
                else
                    propList.routingField = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'source')
                    propList.source = obj.props_('source');
                else
                    propList.source = [];
                end
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'sex')
                    propList.sex = obj.props_('sex');
                else
                    propList.sex = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'race')
                    propList.race = obj.props_('race');
                else
                    propList.race = [];
                end
                if isKey(obj.props_, 'ethnicity')
                    propList.ethnicity = obj.props_('ethnicity');
                else
                    propList.ethnicity = [];
                end
                if isKey(obj.props_, 'species')
                    propList.species = obj.props_('species');
                else
                    propList.species = [];
                end
                if isKey(obj.props_, 'strain')
                    propList.strain = obj.props_('strain');
                else
                    propList.strain = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SubjectUpsertInput;
            if isfield(json, 'date_of_birth')
                obj.props_('date_of_birth') = flywheel.ModelBase.deserializeValue(json.date_of_birth, 'datetime');
            end
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'routing_field')
                obj.props_('routing_field') = flywheel.ModelBase.deserializeValue(json.routing_field, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'source')
                obj.props_('source') = flywheel.model.CoreModelsCommonSource.fromJson(json.source, context);
            end
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'sex')
                obj.props_('sex') = flywheel.ModelBase.deserializeValue(json.sex, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'race')
                obj.props_('race') = flywheel.ModelBase.deserializeValue(json.race, 'char');
            end
            if isfield(json, 'ethnicity')
                obj.props_('ethnicity') = flywheel.ModelBase.deserializeValue(json.ethnicity, 'char');
            end
            if isfield(json, 'species')
                obj.props_('species') = flywheel.ModelBase.deserializeValue(json.species, 'char');
            end
            if isfield(json, 'strain')
                obj.props_('strain') = flywheel.ModelBase.deserializeValue(json.strain, 'char');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.SubjectState.fromJson(json.state, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SubjectUpsertInput')
                    obj = flywheel.model.SubjectUpsertInput(obj);
                end
                if isKey(obj.props_, 'date_of_birth')
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'routing_field')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'source')
                    obj.props_('source') =  flywheel.model.CoreModelsCommonSource.ensureIsInstance(obj.props_('source'));
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'sex')
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'race')
                end
                if isKey(obj.props_, 'ethnicity')
                end
                if isKey(obj.props_, 'species')
                end
                if isKey(obj.props_, 'strain')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.SubjectState.ensureIsInstance(obj.props_('state'));
                end
            end
        end
    end
end
