% SyncUserInput
%
% SyncUserInput Properties:
%    email      
%    givenName  
%    familyName 
%    disabled   
%    auth0id    
%    revision   
%    role       
%
% SyncUserInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef SyncUserInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'email', 'givenName', 'familyName', 'disabled', 'auth0id', 'revision', 'role' }, ...
            { 'email', 'given_name', 'family_name', 'disabled', 'auth0id', 'revision', 'role' });
    end
    properties(Dependent)
        email
        givenName
        familyName
        disabled
        auth0id
        revision
        role
    end
    methods
        function obj = SyncUserInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.SyncUserInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'email', []);
                addParameter(p, 'givenName', []);
                addParameter(p, 'familyName', []);
                addParameter(p, 'disabled', []);
                addParameter(p, 'auth0id', []);
                addParameter(p, 'revision', []);
                addParameter(p, 'role', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.email)
                    obj.props_('email') = p.Results.email;
                end
                if ~isempty(p.Results.givenName)
                    obj.props_('given_name') = p.Results.givenName;
                end
                if ~isempty(p.Results.familyName)
                    obj.props_('family_name') = p.Results.familyName;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.auth0id)
                    obj.props_('auth0id') = p.Results.auth0id;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
                if ~isempty(p.Results.role)
                    obj.props_('role') = p.Results.role;
                end
            end
        end
        function result = get.email(obj)
            if ismethod(obj, 'get_email')
                result = obj.get_email();
            else
                if isKey(obj.props_, 'email')
                    result = obj.props_('email');
                else
                    result = [];
                end
            end
        end
        function obj = set.email(obj, value)
            obj.props_('email') = value;
        end
        function result = get.givenName(obj)
            if ismethod(obj, 'get_givenName')
                result = obj.get_givenName();
            else
                if isKey(obj.props_, 'given_name')
                    result = obj.props_('given_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.givenName(obj, value)
            obj.props_('given_name') = value;
        end
        function result = get.familyName(obj)
            if ismethod(obj, 'get_familyName')
                result = obj.get_familyName();
            else
                if isKey(obj.props_, 'family_name')
                    result = obj.props_('family_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.familyName(obj, value)
            obj.props_('family_name') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.auth0id(obj)
            if ismethod(obj, 'get_auth0id')
                result = obj.get_auth0id();
            else
                if isKey(obj.props_, 'auth0id')
                    result = obj.props_('auth0id');
                else
                    result = [];
                end
            end
        end
        function obj = set.auth0id(obj, value)
            obj.props_('auth0id') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = get.role(obj)
            if ismethod(obj, 'get_role')
                result = obj.get_role();
            else
                if isKey(obj.props_, 'role')
                    result = obj.props_('role');
                else
                    result = [];
                end
            end
        end
        function obj = set.role(obj, value)
            obj.props_('role') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'email')
                result('email') = flywheel.ModelBase.serializeValue(obj.props_('email'), 'char');
            end
            if isKey(obj.props_, 'given_name')
                result('given_name') = flywheel.ModelBase.serializeValue(obj.props_('given_name'), 'char');
            end
            if isKey(obj.props_, 'family_name')
                result('family_name') = flywheel.ModelBase.serializeValue(obj.props_('family_name'), 'char');
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'auth0id')
                result('auth0id') = flywheel.ModelBase.serializeValue(obj.props_('auth0id'), 'char');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
            if isKey(obj.props_, 'role')
                result('role') = obj.props_('role').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'email')
                result.email = obj.props_('email');
            else
                result.email = [];
            end
            if isKey(obj.props_, 'given_name')
                result.givenName = obj.props_('given_name');
            else
                result.givenName = [];
            end
            if isKey(obj.props_, 'family_name')
                result.familyName = obj.props_('family_name');
            else
                result.familyName = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'auth0id')
                result.auth0id = obj.props_('auth0id');
            else
                result.auth0id = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
            if isKey(obj.props_, 'role')
                result.role = struct(obj.props_('role'));
            else
                result.role = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'email')
                    propList.email = obj.props_('email');
                else
                    propList.email = [];
                end
                if isKey(obj.props_, 'given_name')
                    propList.givenName = obj.props_('given_name');
                else
                    propList.givenName = [];
                end
                if isKey(obj.props_, 'family_name')
                    propList.familyName = obj.props_('family_name');
                else
                    propList.familyName = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'auth0id')
                    propList.auth0id = obj.props_('auth0id');
                else
                    propList.auth0id = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                if isKey(obj.props_, 'role')
                    propList.role = obj.props_('role');
                else
                    propList.role = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.SyncUserInput;
            if isfield(json, 'email')
                obj.props_('email') = flywheel.ModelBase.deserializeValue(json.email, 'char');
            end
            if isfield(json, 'given_name')
                obj.props_('given_name') = flywheel.ModelBase.deserializeValue(json.given_name, 'char');
            end
            if isfield(json, 'family_name')
                obj.props_('family_name') = flywheel.ModelBase.deserializeValue(json.family_name, 'char');
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'auth0id')
                obj.props_('auth0id') = flywheel.ModelBase.deserializeValue(json.auth0id, 'char');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isfield(json, 'role')
                obj.props_('role') = flywheel.model.RoleType.fromJson(json.role, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.SyncUserInput')
                    obj = flywheel.model.SyncUserInput(obj);
                end
                if isKey(obj.props_, 'email')
                end
                if isKey(obj.props_, 'given_name')
                end
                if isKey(obj.props_, 'family_name')
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'auth0id')
                end
                if isKey(obj.props_, 'revision')
                end
                if isKey(obj.props_, 'role')
                    obj.props_('role') =  flywheel.model.RoleType.ensureIsInstance(obj.props_('role'));
                end
            end
        end
    end
end
