% Transitions - The representation of the object holding information about when a job     made transitions to the different states  Attributes:     pending (Optional[datetime.datetime]): Timestamp of when the job         transitioned to pending state     running (Optional[datetime.datetime]): Timestamp of when the job         transitioned to running state     failed (Optional[datetime.datetime]): Timestamp of when the job         transitioned to failed state     complete (Optional[datetime.datetime]): Timestamp of when the job         transitioned to complete state     cancelled (Optional[datetime.datetime]): Timestamp of when the job         transitioned to cancelled state
%
% Transitions Properties:
%    pending   
%    running   
%    failed    
%    complete  
%    cancelled 
%
% Transitions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Transitions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'pending', 'running', 'failed', 'complete', 'cancelled' }, ...
            { 'pending', 'running', 'failed', 'complete', 'cancelled' });
    end
    properties(Dependent)
        pending
        running
        failed
        complete
        cancelled
    end
    methods
        function obj = Transitions(varargin)
            obj@flywheel.ModelBase(flywheel.model.Transitions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'pending', []);
                addParameter(p, 'running', []);
                addParameter(p, 'failed', []);
                addParameter(p, 'complete', []);
                addParameter(p, 'cancelled', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.pending)
                    obj.props_('pending') = p.Results.pending;
                end
                if ~isempty(p.Results.running)
                    obj.props_('running') = p.Results.running;
                end
                if ~isempty(p.Results.failed)
                    obj.props_('failed') = p.Results.failed;
                end
                if ~isempty(p.Results.complete)
                    obj.props_('complete') = p.Results.complete;
                end
                if ~isempty(p.Results.cancelled)
                    obj.props_('cancelled') = p.Results.cancelled;
                end
            end
        end
        function result = get.pending(obj)
            if ismethod(obj, 'get_pending')
                result = obj.get_pending();
            else
                if isKey(obj.props_, 'pending')
                    result = obj.props_('pending');
                else
                    result = [];
                end
            end
        end
        function obj = set.pending(obj, value)
            obj.props_('pending') = value;
        end
        function result = get.running(obj)
            if ismethod(obj, 'get_running')
                result = obj.get_running();
            else
                if isKey(obj.props_, 'running')
                    result = obj.props_('running');
                else
                    result = [];
                end
            end
        end
        function obj = set.running(obj, value)
            obj.props_('running') = value;
        end
        function result = get.failed(obj)
            if ismethod(obj, 'get_failed')
                result = obj.get_failed();
            else
                if isKey(obj.props_, 'failed')
                    result = obj.props_('failed');
                else
                    result = [];
                end
            end
        end
        function obj = set.failed(obj, value)
            obj.props_('failed') = value;
        end
        function result = get.complete(obj)
            if ismethod(obj, 'get_complete')
                result = obj.get_complete();
            else
                if isKey(obj.props_, 'complete')
                    result = obj.props_('complete');
                else
                    result = [];
                end
            end
        end
        function obj = set.complete(obj, value)
            obj.props_('complete') = value;
        end
        function result = get.cancelled(obj)
            if ismethod(obj, 'get_cancelled')
                result = obj.get_cancelled();
            else
                if isKey(obj.props_, 'cancelled')
                    result = obj.props_('cancelled');
                else
                    result = [];
                end
            end
        end
        function obj = set.cancelled(obj, value)
            obj.props_('cancelled') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'pending')
                result('pending') = flywheel.ModelBase.serializeValue(obj.props_('pending'), 'datetime');
            end
            if isKey(obj.props_, 'running')
                result('running') = flywheel.ModelBase.serializeValue(obj.props_('running'), 'datetime');
            end
            if isKey(obj.props_, 'failed')
                result('failed') = flywheel.ModelBase.serializeValue(obj.props_('failed'), 'datetime');
            end
            if isKey(obj.props_, 'complete')
                result('complete') = flywheel.ModelBase.serializeValue(obj.props_('complete'), 'datetime');
            end
            if isKey(obj.props_, 'cancelled')
                result('cancelled') = flywheel.ModelBase.serializeValue(obj.props_('cancelled'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'pending')
                result.pending = obj.props_('pending');
            else
                result.pending = [];
            end
            if isKey(obj.props_, 'running')
                result.running = obj.props_('running');
            else
                result.running = [];
            end
            if isKey(obj.props_, 'failed')
                result.failed = obj.props_('failed');
            else
                result.failed = [];
            end
            if isKey(obj.props_, 'complete')
                result.complete = obj.props_('complete');
            else
                result.complete = [];
            end
            if isKey(obj.props_, 'cancelled')
                result.cancelled = obj.props_('cancelled');
            else
                result.cancelled = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'pending')
                    propList.pending = obj.props_('pending');
                else
                    propList.pending = [];
                end
                if isKey(obj.props_, 'running')
                    propList.running = obj.props_('running');
                else
                    propList.running = [];
                end
                if isKey(obj.props_, 'failed')
                    propList.failed = obj.props_('failed');
                else
                    propList.failed = [];
                end
                if isKey(obj.props_, 'complete')
                    propList.complete = obj.props_('complete');
                else
                    propList.complete = [];
                end
                if isKey(obj.props_, 'cancelled')
                    propList.cancelled = obj.props_('cancelled');
                else
                    propList.cancelled = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Transitions;
            if isfield(json, 'pending')
                obj.props_('pending') = flywheel.ModelBase.deserializeValue(json.pending, 'datetime');
            end
            if isfield(json, 'running')
                obj.props_('running') = flywheel.ModelBase.deserializeValue(json.running, 'datetime');
            end
            if isfield(json, 'failed')
                obj.props_('failed') = flywheel.ModelBase.deserializeValue(json.failed, 'datetime');
            end
            if isfield(json, 'complete')
                obj.props_('complete') = flywheel.ModelBase.deserializeValue(json.complete, 'datetime');
            end
            if isfield(json, 'cancelled')
                obj.props_('cancelled') = flywheel.ModelBase.deserializeValue(json.cancelled, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Transitions')
                    obj = flywheel.model.Transitions(obj);
                end
                if isKey(obj.props_, 'pending')
                end
                if isKey(obj.props_, 'running')
                end
                if isKey(obj.props_, 'failed')
                end
                if isKey(obj.props_, 'complete')
                end
                if isKey(obj.props_, 'cancelled')
                end
            end
        end
    end
end
