% TreeGraphConnection
%
% TreeGraphConnection Properties:
%    local      
%    foreign    
%    collection 
%    order      
%
% TreeGraphConnection Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef TreeGraphConnection < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'local', 'foreign', 'collection', 'order' }, ...
            { 'local', 'foreign', 'collection', 'order' });
    end
    properties(Dependent)
        local
        foreign
        collection
        order
    end
    methods
        function obj = TreeGraphConnection(varargin)
            obj@flywheel.ModelBase(flywheel.model.TreeGraphConnection.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'local', []);
                addParameter(p, 'foreign', []);
                addParameter(p, 'collection', []);
                addParameter(p, 'order', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.local)
                    obj.props_('local') = p.Results.local;
                end
                if ~isempty(p.Results.foreign)
                    obj.props_('foreign') = p.Results.foreign;
                end
                if ~isempty(p.Results.collection)
                    obj.props_('collection') = p.Results.collection;
                end
                if ~isempty(p.Results.order)
                    obj.props_('order') = p.Results.order;
                end
            end
        end
        function result = get.local(obj)
            if ismethod(obj, 'get_local')
                result = obj.get_local();
            else
                if isKey(obj.props_, 'local')
                    result = obj.props_('local');
                else
                    result = [];
                end
            end
        end
        function obj = set.local(obj, value)
            obj.props_('local') = value;
        end
        function result = get.foreign(obj)
            if ismethod(obj, 'get_foreign')
                result = obj.get_foreign();
            else
                if isKey(obj.props_, 'foreign')
                    result = obj.props_('foreign');
                else
                    result = [];
                end
            end
        end
        function obj = set.foreign(obj, value)
            obj.props_('foreign') = value;
        end
        function result = get.collection(obj)
            if ismethod(obj, 'get_collection')
                result = obj.get_collection();
            else
                if isKey(obj.props_, 'collection')
                    result = obj.props_('collection');
                else
                    result = [];
                end
            end
        end
        function obj = set.collection(obj, value)
            obj.props_('collection') = value;
        end
        function result = get.order(obj)
            if ismethod(obj, 'get_order')
                result = obj.get_order();
            else
                if isKey(obj.props_, 'order')
                    result = obj.props_('order');
                else
                    result = [];
                end
            end
        end
        function obj = set.order(obj, value)
            obj.props_('order') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'local')
                result('local') = flywheel.ModelBase.serializeValue(obj.props_('local'), 'char');
            end
            if isKey(obj.props_, 'foreign')
                result('foreign') = flywheel.ModelBase.serializeValue(obj.props_('foreign'), 'char');
            end
            if isKey(obj.props_, 'collection')
                result('collection') = flywheel.ModelBase.serializeValue(obj.props_('collection'), 'char');
            end
            if isKey(obj.props_, 'order')
                result('order') = flywheel.ModelBase.serializeValue(obj.props_('order'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'local')
                result.local = obj.props_('local');
            else
                result.local = [];
            end
            if isKey(obj.props_, 'foreign')
                result.foreign = obj.props_('foreign');
            else
                result.foreign = [];
            end
            if isKey(obj.props_, 'collection')
                result.collection = obj.props_('collection');
            else
                result.collection = [];
            end
            if isKey(obj.props_, 'order')
                result.order = obj.props_('order');
            else
                result.order = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'local')
                    propList.local = obj.props_('local');
                else
                    propList.local = [];
                end
                if isKey(obj.props_, 'foreign')
                    propList.foreign = obj.props_('foreign');
                else
                    propList.foreign = [];
                end
                if isKey(obj.props_, 'collection')
                    propList.collection = obj.props_('collection');
                else
                    propList.collection = [];
                end
                if isKey(obj.props_, 'order')
                    propList.order = obj.props_('order');
                else
                    propList.order = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.TreeGraphConnection;
            if isfield(json, 'local')
                obj.props_('local') = flywheel.ModelBase.deserializeValue(json.local, 'char');
            end
            if isfield(json, 'foreign')
                obj.props_('foreign') = flywheel.ModelBase.deserializeValue(json.foreign, 'char');
            end
            if isfield(json, 'collection')
                obj.props_('collection') = flywheel.ModelBase.deserializeValue(json.collection, 'char');
            end
            if isfield(json, 'order')
                obj.props_('order') = flywheel.ModelBase.deserializeValue(json.order, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.TreeGraphConnection')
                    obj = flywheel.model.TreeGraphConnection(obj);
                end
                if isKey(obj.props_, 'local')
                end
                if isKey(obj.props_, 'foreign')
                end
                if isKey(obj.props_, 'collection')
                end
                if isKey(obj.props_, 'order')
                end
            end
        end
    end
end
