% UploadTicketOutput - The output of the ticket  Attributes:     ticket: The id of the ticket     urls: A mapping of filename to respective url
%
% UploadTicketOutput Properties:
%    ticket  
%    urls    
%    headers 
%
% UploadTicketOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef UploadTicketOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'ticket', 'urls', 'headers' }, ...
            { 'ticket', 'urls', 'headers' });
    end
    properties(Dependent)
        ticket
        urls
        headers
    end
    methods
        function obj = UploadTicketOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.UploadTicketOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'ticket', []);
                addParameter(p, 'urls', []);
                addParameter(p, 'headers', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.ticket)
                    obj.props_('ticket') = p.Results.ticket;
                end
                if ~isempty(p.Results.urls)
                    obj.props_('urls') = p.Results.urls;
                end
                if ~isempty(p.Results.headers)
                    obj.props_('headers') = p.Results.headers;
                end
            end
        end
        function result = get.ticket(obj)
            if ismethod(obj, 'get_ticket')
                result = obj.get_ticket();
            else
                if isKey(obj.props_, 'ticket')
                    result = obj.props_('ticket');
                else
                    result = [];
                end
            end
        end
        function obj = set.ticket(obj, value)
            obj.props_('ticket') = value;
        end
        function result = get.urls(obj)
            if ismethod(obj, 'get_urls')
                result = obj.get_urls();
            else
                if isKey(obj.props_, 'urls')
                    result = obj.props_('urls');
                else
                    result = [];
                end
            end
        end
        function obj = set.urls(obj, value)
            obj.props_('urls') = value;
        end
        function result = get.headers(obj)
            if ismethod(obj, 'get_headers')
                result = obj.get_headers();
            else
                if isKey(obj.props_, 'headers')
                    result = obj.props_('headers');
                else
                    result = [];
                end
            end
        end
        function obj = set.headers(obj, value)
            obj.props_('headers') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'ticket')
                result('ticket') = flywheel.ModelBase.serializeValue(obj.props_('ticket'), 'char');
            end
            if isKey(obj.props_, 'urls')
                result('urls') = obj.props_('urls').toJson();
            end
            if isKey(obj.props_, 'headers')
                result('headers') = flywheel.ModelBase.serializeValue(obj.props_('headers'), 'containers.Map[String, char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'ticket')
                result.ticket = obj.props_('ticket');
            else
                result.ticket = [];
            end
            if isKey(obj.props_, 'urls')
                result.urls = struct(obj.props_('urls'));
            else
                result.urls = [];
            end
            if isKey(obj.props_, 'headers')
                result.headers = obj.props_('headers');
            else
                result.headers = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'ticket')
                    propList.ticket = obj.props_('ticket');
                else
                    propList.ticket = [];
                end
                if isKey(obj.props_, 'urls')
                    propList.urls = obj.props_('urls');
                else
                    propList.urls = [];
                end
                if isKey(obj.props_, 'headers')
                    propList.headers = obj.props_('headers');
                else
                    propList.headers = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.UploadTicketOutput;
            if isfield(json, 'ticket')
                obj.props_('ticket') = flywheel.ModelBase.deserializeValue(json.ticket, 'char');
            end
            if isfield(json, 'urls')
                obj.props_('urls') = flywheel.model.AnyOfUploadTicketOutputUrls.fromJson(json.urls, context);
            end
            if isfield(json, 'headers')
                obj.props_('headers') = flywheel.ModelBase.deserializeValue(json.headers, 'containers.Map[String, char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.UploadTicketOutput')
                    obj = flywheel.model.UploadTicketOutput(obj);
                end
                if isKey(obj.props_, 'ticket')
                end
                if isKey(obj.props_, 'urls')
                    obj.props_('urls') =  flywheel.model.AnyOfUploadTicketOutputUrls.ensureIsInstance(obj.props_('urls'));
                end
                if isKey(obj.props_, 'headers')
                end
            end
        end
    end
end
