% User
%
% User Properties:
%    id               - Database ID of a user
%    userId          
%    firstname        - First name
%    lastname         - Last name
%    email            - Email address
%    avatar           - Avatar image URL
%    avatars         
%    roles           
%    root             - Super admin flag
%    disabled        
%    preferences     
%    wechat          
%    firstlogin      
%    lastlogin       
%    apiKey          
%    apiKeys         
%    created          - Creation time (automatically set)
%    modified         - Last modification time (automatically updated)
%    deleted          - Deleted time (automatically set on delete)
%    centralUserId   
%    centralRevision 
%    info            
%
% User Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef User < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'userId', 'firstname', 'lastname', 'email', 'avatar', 'avatars', 'roles', 'root', 'disabled', 'preferences', 'wechat', 'firstlogin', 'lastlogin', 'apiKey', 'apiKeys', 'created', 'modified', 'deleted', 'centralUserId', 'centralRevision', 'info' }, ...
            { '_id', 'user_id', 'firstname', 'lastname', 'email', 'avatar', 'avatars', 'roles', 'root', 'disabled', 'preferences', 'wechat', 'firstlogin', 'lastlogin', 'api_key', 'api_keys', 'created', 'modified', 'deleted', 'central_user_id', 'central_revision', 'info' });
    end
    properties(Dependent)
        id
        userId
        firstname
        lastname
        email
        avatar
        avatars
        roles
        root
        disabled
        preferences
        wechat
        firstlogin
        lastlogin
        apiKey
        apiKeys
        created
        modified
        deleted
        centralUserId
        centralRevision
        info
    end
    methods
        function obj = User(varargin)
            obj@flywheel.ModelBase(flywheel.model.User.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'userId', []);
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'email', []);
                addParameter(p, 'avatar', []);
                addParameter(p, 'avatars', []);
                addParameter(p, 'roles', []);
                addParameter(p, 'root', []);
                addParameter(p, 'disabled', []);
                addParameter(p, 'preferences', []);
                addParameter(p, 'wechat', []);
                addParameter(p, 'firstlogin', []);
                addParameter(p, 'lastlogin', []);
                addParameter(p, 'apiKey', []);
                addParameter(p, 'apiKeys', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'centralUserId', []);
                addParameter(p, 'centralRevision', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.userId)
                    obj.props_('user_id') = p.Results.userId;
                end
                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.email)
                    obj.props_('email') = p.Results.email;
                end
                if ~isempty(p.Results.avatar)
                    obj.props_('avatar') = p.Results.avatar;
                end
                if ~isempty(p.Results.avatars)
                    obj.props_('avatars') = p.Results.avatars;
                end
                if ~isempty(p.Results.roles)
                    obj.props_('roles') = p.Results.roles;
                end
                if ~isempty(p.Results.root)
                    obj.props_('root') = p.Results.root;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.preferences)
                    obj.props_('preferences') = p.Results.preferences;
                end
                if ~isempty(p.Results.wechat)
                    obj.props_('wechat') = p.Results.wechat;
                end
                if ~isempty(p.Results.firstlogin)
                    obj.props_('firstlogin') = p.Results.firstlogin;
                end
                if ~isempty(p.Results.lastlogin)
                    obj.props_('lastlogin') = p.Results.lastlogin;
                end
                if ~isempty(p.Results.apiKey)
                    obj.props_('api_key') = p.Results.apiKey;
                end
                if ~isempty(p.Results.apiKeys)
                    obj.props_('api_keys') = p.Results.apiKeys;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.centralUserId)
                    obj.props_('central_user_id') = p.Results.centralUserId;
                end
                if ~isempty(p.Results.centralRevision)
                    obj.props_('central_revision') = p.Results.centralRevision;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.userId(obj)
            if ismethod(obj, 'get_userId')
                result = obj.get_userId();
            else
                if isKey(obj.props_, 'user_id')
                    result = obj.props_('user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.userId(obj, value)
            obj.props_('user_id') = value;
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.email(obj)
            if ismethod(obj, 'get_email')
                result = obj.get_email();
            else
                if isKey(obj.props_, 'email')
                    result = obj.props_('email');
                else
                    result = [];
                end
            end
        end
        function obj = set.email(obj, value)
            obj.props_('email') = value;
        end
        function result = get.avatar(obj)
            if ismethod(obj, 'get_avatar')
                result = obj.get_avatar();
            else
                if isKey(obj.props_, 'avatar')
                    result = obj.props_('avatar');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatar(obj, value)
            obj.props_('avatar') = value;
        end
        function result = get.avatars(obj)
            if ismethod(obj, 'get_avatars')
                result = obj.get_avatars();
            else
                if isKey(obj.props_, 'avatars')
                    result = obj.props_('avatars');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatars(obj, value)
            obj.props_('avatars') = value;
        end
        function result = get.roles(obj)
            if ismethod(obj, 'get_roles')
                result = obj.get_roles();
            else
                if isKey(obj.props_, 'roles')
                    result = obj.props_('roles');
                else
                    result = [];
                end
            end
        end
        function obj = set.roles(obj, value)
            obj.props_('roles') = value;
        end
        function result = get.root(obj)
            if ismethod(obj, 'get_root')
                result = obj.get_root();
            else
                if isKey(obj.props_, 'root')
                    result = obj.props_('root');
                else
                    result = [];
                end
            end
        end
        function obj = set.root(obj, value)
            obj.props_('root') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.preferences(obj)
            if ismethod(obj, 'get_preferences')
                result = obj.get_preferences();
            else
                if isKey(obj.props_, 'preferences')
                    result = obj.props_('preferences');
                else
                    result = [];
                end
            end
        end
        function obj = set.preferences(obj, value)
            obj.props_('preferences') = value;
        end
        function result = get.wechat(obj)
            if ismethod(obj, 'get_wechat')
                result = obj.get_wechat();
            else
                if isKey(obj.props_, 'wechat')
                    result = obj.props_('wechat');
                else
                    result = [];
                end
            end
        end
        function obj = set.wechat(obj, value)
            obj.props_('wechat') = value;
        end
        function result = get.firstlogin(obj)
            if ismethod(obj, 'get_firstlogin')
                result = obj.get_firstlogin();
            else
                if isKey(obj.props_, 'firstlogin')
                    result = obj.props_('firstlogin');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstlogin(obj, value)
            obj.props_('firstlogin') = value;
        end
        function result = get.lastlogin(obj)
            if ismethod(obj, 'get_lastlogin')
                result = obj.get_lastlogin();
            else
                if isKey(obj.props_, 'lastlogin')
                    result = obj.props_('lastlogin');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastlogin(obj, value)
            obj.props_('lastlogin') = value;
        end
        function result = get.apiKey(obj)
            if ismethod(obj, 'get_apiKey')
                result = obj.get_apiKey();
            else
                if isKey(obj.props_, 'api_key')
                    result = obj.props_('api_key');
                else
                    result = [];
                end
            end
        end
        function obj = set.apiKey(obj, value)
            obj.props_('api_key') = value;
        end
        function result = get.apiKeys(obj)
            if ismethod(obj, 'get_apiKeys')
                result = obj.get_apiKeys();
            else
                if isKey(obj.props_, 'api_keys')
                    result = obj.props_('api_keys');
                else
                    result = [];
                end
            end
        end
        function obj = set.apiKeys(obj, value)
            obj.props_('api_keys') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.centralUserId(obj)
            if ismethod(obj, 'get_centralUserId')
                result = obj.get_centralUserId();
            else
                if isKey(obj.props_, 'central_user_id')
                    result = obj.props_('central_user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralUserId(obj, value)
            obj.props_('central_user_id') = value;
        end
        function result = get.centralRevision(obj)
            if ismethod(obj, 'get_centralRevision')
                result = obj.get_centralRevision();
            else
                if isKey(obj.props_, 'central_revision')
                    result = obj.props_('central_revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralRevision(obj, value)
            obj.props_('central_revision') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'user_id')
                result('user_id') = flywheel.ModelBase.serializeValue(obj.props_('user_id'), 'char');
            end
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'email')
                result('email') = flywheel.ModelBase.serializeValue(obj.props_('email'), 'char');
            end
            if isKey(obj.props_, 'avatar')
                result('avatar') = flywheel.ModelBase.serializeValue(obj.props_('avatar'), 'char');
            end
            if isKey(obj.props_, 'avatars')
                result('avatars') = obj.props_('avatars').toJson();
            end
            if isKey(obj.props_, 'roles')
                result('roles') = flywheel.ModelBase.serializeValue(obj.props_('roles'), 'vector[char]');
            end
            if isKey(obj.props_, 'root')
                result('root') = flywheel.ModelBase.serializeValue(obj.props_('root'), 'logical');
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'preferences')
                result('preferences') = obj.props_('preferences').toJson();
            end
            if isKey(obj.props_, 'wechat')
                result('wechat') = obj.props_('wechat').toJson();
            end
            if isKey(obj.props_, 'firstlogin')
                result('firstlogin') = flywheel.ModelBase.serializeValue(obj.props_('firstlogin'), 'char');
            end
            if isKey(obj.props_, 'lastlogin')
                result('lastlogin') = flywheel.ModelBase.serializeValue(obj.props_('lastlogin'), 'char');
            end
            if isKey(obj.props_, 'api_key')
                result('api_key') = obj.props_('api_key').toJson();
            end
            if isKey(obj.props_, 'api_keys')
                result('api_keys') = flywheel.ModelBase.cellmap(@toJson, obj.props_('api_keys'));
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'central_user_id')
                result('central_user_id') = flywheel.ModelBase.serializeValue(obj.props_('central_user_id'), 'char');
            end
            if isKey(obj.props_, 'central_revision')
                result('central_revision') = flywheel.ModelBase.serializeValue(obj.props_('central_revision'), 'integer');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'user_id')
                result.userId = obj.props_('user_id');
            else
                result.userId = [];
            end
            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'email')
                result.email = obj.props_('email');
            else
                result.email = [];
            end
            if isKey(obj.props_, 'avatar')
                result.avatar = obj.props_('avatar');
            else
                result.avatar = [];
            end
            if isKey(obj.props_, 'avatars')
                result.avatars = struct(obj.props_('avatars'));
            else
                result.avatars = [];
            end
            if isKey(obj.props_, 'roles')
                result.roles = obj.props_('roles');
            else
                result.roles = [];
            end
            if isKey(obj.props_, 'root')
                result.root = obj.props_('root');
            else
                result.root = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'preferences')
                result.preferences = struct(obj.props_('preferences'));
            else
                result.preferences = [];
            end
            if isKey(obj.props_, 'wechat')
                result.wechat = struct(obj.props_('wechat'));
            else
                result.wechat = [];
            end
            if isKey(obj.props_, 'firstlogin')
                result.firstlogin = obj.props_('firstlogin');
            else
                result.firstlogin = [];
            end
            if isKey(obj.props_, 'lastlogin')
                result.lastlogin = obj.props_('lastlogin');
            else
                result.lastlogin = [];
            end
            if isKey(obj.props_, 'api_key')
                result.apiKey = struct(obj.props_('api_key'));
            else
                result.apiKey = [];
            end
            if isKey(obj.props_, 'api_keys')
                result.apiKeys = flywheel.ModelBase.cellmap(@struct, obj.props_('api_keys'));
            else
                result.apiKeys = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'central_user_id')
                result.centralUserId = obj.props_('central_user_id');
            else
                result.centralUserId = [];
            end
            if isKey(obj.props_, 'central_revision')
                result.centralRevision = obj.props_('central_revision');
            else
                result.centralRevision = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'user_id')
                    propList.userId = obj.props_('user_id');
                else
                    propList.userId = [];
                end
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'email')
                    propList.email = obj.props_('email');
                else
                    propList.email = [];
                end
                if isKey(obj.props_, 'avatar')
                    propList.avatar = obj.props_('avatar');
                else
                    propList.avatar = [];
                end
                if isKey(obj.props_, 'avatars')
                    propList.avatars = obj.props_('avatars');
                else
                    propList.avatars = [];
                end
                if isKey(obj.props_, 'roles')
                    propList.roles = obj.props_('roles');
                else
                    propList.roles = [];
                end
                if isKey(obj.props_, 'root')
                    propList.root = obj.props_('root');
                else
                    propList.root = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'preferences')
                    propList.preferences = obj.props_('preferences');
                else
                    propList.preferences = [];
                end
                if isKey(obj.props_, 'wechat')
                    propList.wechat = obj.props_('wechat');
                else
                    propList.wechat = [];
                end
                if isKey(obj.props_, 'firstlogin')
                    propList.firstlogin = obj.props_('firstlogin');
                else
                    propList.firstlogin = [];
                end
                if isKey(obj.props_, 'lastlogin')
                    propList.lastlogin = obj.props_('lastlogin');
                else
                    propList.lastlogin = [];
                end
                if isKey(obj.props_, 'api_key')
                    propList.apiKey = obj.props_('api_key');
                else
                    propList.apiKey = [];
                end
                if isKey(obj.props_, 'api_keys')
                    propList.apiKeys = obj.props_('api_keys');
                else
                    propList.apiKeys = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'central_user_id')
                    propList.centralUserId = obj.props_('central_user_id');
                else
                    propList.centralUserId = [];
                end
                if isKey(obj.props_, 'central_revision')
                    propList.centralRevision = obj.props_('central_revision');
                else
                    propList.centralRevision = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.User;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'user_id')
                obj.props_('user_id') = flywheel.ModelBase.deserializeValue(json.user_id, 'char');
            end
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'email')
                obj.props_('email') = flywheel.ModelBase.deserializeValue(json.email, 'char');
            end
            if isfield(json, 'avatar')
                obj.props_('avatar') = flywheel.ModelBase.deserializeValue(json.avatar, 'char');
            end
            if isfield(json, 'avatars')
                obj.props_('avatars') = flywheel.model.Avatars.fromJson(json.avatars, context);
            end
            if isfield(json, 'roles')
                obj.props_('roles') = flywheel.ModelBase.deserializeValue(json.roles, 'vector[char]');
            end
            if isfield(json, 'root')
                obj.props_('root') = flywheel.ModelBase.deserializeValue(json.root, 'logical');
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'preferences')
                obj.props_('preferences') = flywheel.model.UserPreferences.fromJson(json.preferences, context);
            end
            if isfield(json, 'wechat')
                obj.props_('wechat') = flywheel.model.UserWechat.fromJson(json.wechat, context);
            end
            if isfield(json, 'firstlogin')
                obj.props_('firstlogin') = flywheel.ModelBase.deserializeValue(json.firstlogin, 'char');
            end
            if isfield(json, 'lastlogin')
                obj.props_('lastlogin') = flywheel.ModelBase.deserializeValue(json.lastlogin, 'char');
            end
            if isfield(json, 'api_key')
                obj.props_('api_key') = flywheel.model.UserApiKey.fromJson(json.api_key, context);
            end
            if isfield(json, 'api_keys')
                obj.props_('api_keys') = flywheel.ModelBase.cellmap(@(x) flywheel.model.UserApiKey.fromJson(x, context), json.api_keys);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'central_user_id')
                obj.props_('central_user_id') = flywheel.ModelBase.deserializeValue(json.central_user_id, 'char');
            end
            if isfield(json, 'central_revision')
                obj.props_('central_revision') = flywheel.ModelBase.deserializeValue(json.central_revision, 'integer');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.User')
                    obj = flywheel.model.User(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'user_id')
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'email')
                end
                if isKey(obj.props_, 'avatar')
                end
                if isKey(obj.props_, 'avatars')
                    obj.props_('avatars') =  flywheel.model.Avatars.ensureIsInstance(obj.props_('avatars'));
                end
                if isKey(obj.props_, 'roles')
                end
                if isKey(obj.props_, 'root')
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'preferences')
                    obj.props_('preferences') =  flywheel.model.UserPreferences.ensureIsInstance(obj.props_('preferences'));
                end
                if isKey(obj.props_, 'wechat')
                    obj.props_('wechat') =  flywheel.model.UserWechat.ensureIsInstance(obj.props_('wechat'));
                end
                if isKey(obj.props_, 'firstlogin')
                end
                if isKey(obj.props_, 'lastlogin')
                end
                if isKey(obj.props_, 'api_key')
                    obj.props_('api_key') =  flywheel.model.UserApiKey.ensureIsInstance(obj.props_('api_key'));
                end
                if isKey(obj.props_, 'api_keys')
                    obj.props_('api_keys') = flywheel.ModelBase.cellmap(@flywheel.model.UserApiKey.ensureIsInstance, obj.props_('api_keys'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'central_user_id')
                end
                if isKey(obj.props_, 'central_revision')
                end
                if isKey(obj.props_, 'info')
                end
            end
        end
    end
end
