% UserApiKey
%
% UserApiKey Properties:
%    key      
%    created   - Creation time (automatically set)
%    lastUsed 
%
% UserApiKey Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef UserApiKey < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'key', 'created', 'lastUsed' }, ...
            { 'key', 'created', 'last_used' });
    end
    properties(Dependent)
        key
        created
        lastUsed
    end
    methods
        function obj = UserApiKey(varargin)
            obj@flywheel.ModelBase(flywheel.model.UserApiKey.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'key', []);
                addParameter(p, 'created', []);
                addParameter(p, 'lastUsed', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.key)
                    obj.props_('key') = p.Results.key;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.lastUsed)
                    obj.props_('last_used') = p.Results.lastUsed;
                end
            end
        end
        function result = get.key(obj)
            if ismethod(obj, 'get_key')
                result = obj.get_key();
            else
                if isKey(obj.props_, 'key')
                    result = obj.props_('key');
                else
                    result = [];
                end
            end
        end
        function obj = set.key(obj, value)
            obj.props_('key') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.lastUsed(obj)
            if ismethod(obj, 'get_lastUsed')
                result = obj.get_lastUsed();
            else
                if isKey(obj.props_, 'last_used')
                    result = obj.props_('last_used');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastUsed(obj, value)
            obj.props_('last_used') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'key')
                result('key') = flywheel.ModelBase.serializeValue(obj.props_('key'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'last_used')
                result('last_used') = flywheel.ModelBase.serializeValue(obj.props_('last_used'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'key')
                result.key = obj.props_('key');
            else
                result.key = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'last_used')
                result.lastUsed = obj.props_('last_used');
            else
                result.lastUsed = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'key')
                    propList.key = obj.props_('key');
                else
                    propList.key = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'last_used')
                    propList.lastUsed = obj.props_('last_used');
                else
                    propList.lastUsed = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.UserApiKey;
            if isfield(json, 'key')
                obj.props_('key') = flywheel.ModelBase.deserializeValue(json.key, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'last_used')
                obj.props_('last_used') = flywheel.ModelBase.deserializeValue(json.last_used, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.UserApiKey')
                    obj = flywheel.model.UserApiKey(obj);
                end
                if isKey(obj.props_, 'key')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'last_used')
                end
            end
        end
    end
end
