% UserInput
%
% UserInput Properties:
%    id              
%    firstname       
%    lastname        
%    email           
%    password        
%    roles           
%    disabled        
%    avatar          
%    root            
%    centralUserId   
%    centralRevision 
%
% UserInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef UserInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'firstname', 'lastname', 'email', 'password', 'roles', 'disabled', 'avatar', 'root', 'centralUserId', 'centralRevision' }, ...
            { '_id', 'firstname', 'lastname', 'email', 'password', 'roles', 'disabled', 'avatar', 'root', 'central_user_id', 'central_revision' });
    end
    properties(Dependent)
        id
        firstname
        lastname
        email
        password
        roles
        disabled
        avatar
        root
        centralUserId
        centralRevision
    end
    methods
        function obj = UserInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.UserInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'email', []);
                addParameter(p, 'password', []);
                addParameter(p, 'roles', []);
                addParameter(p, 'disabled', []);
                addParameter(p, 'avatar', []);
                addParameter(p, 'root', []);
                addParameter(p, 'centralUserId', []);
                addParameter(p, 'centralRevision', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.email)
                    obj.props_('email') = p.Results.email;
                end
                if ~isempty(p.Results.password)
                    obj.props_('password') = p.Results.password;
                end
                if ~isempty(p.Results.roles)
                    obj.props_('roles') = p.Results.roles;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.avatar)
                    obj.props_('avatar') = p.Results.avatar;
                end
                if ~isempty(p.Results.root)
                    obj.props_('root') = p.Results.root;
                end
                if ~isempty(p.Results.centralUserId)
                    obj.props_('central_user_id') = p.Results.centralUserId;
                end
                if ~isempty(p.Results.centralRevision)
                    obj.props_('central_revision') = p.Results.centralRevision;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.email(obj)
            if ismethod(obj, 'get_email')
                result = obj.get_email();
            else
                if isKey(obj.props_, 'email')
                    result = obj.props_('email');
                else
                    result = [];
                end
            end
        end
        function obj = set.email(obj, value)
            obj.props_('email') = value;
        end
        function result = get.password(obj)
            if ismethod(obj, 'get_password')
                result = obj.get_password();
            else
                if isKey(obj.props_, 'password')
                    result = obj.props_('password');
                else
                    result = [];
                end
            end
        end
        function obj = set.password(obj, value)
            obj.props_('password') = value;
        end
        function result = get.roles(obj)
            if ismethod(obj, 'get_roles')
                result = obj.get_roles();
            else
                if isKey(obj.props_, 'roles')
                    result = obj.props_('roles');
                else
                    result = [];
                end
            end
        end
        function obj = set.roles(obj, value)
            obj.props_('roles') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.avatar(obj)
            if ismethod(obj, 'get_avatar')
                result = obj.get_avatar();
            else
                if isKey(obj.props_, 'avatar')
                    result = obj.props_('avatar');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatar(obj, value)
            obj.props_('avatar') = value;
        end
        function result = get.root(obj)
            if ismethod(obj, 'get_root')
                result = obj.get_root();
            else
                if isKey(obj.props_, 'root')
                    result = obj.props_('root');
                else
                    result = [];
                end
            end
        end
        function obj = set.root(obj, value)
            obj.props_('root') = value;
        end
        function result = get.centralUserId(obj)
            if ismethod(obj, 'get_centralUserId')
                result = obj.get_centralUserId();
            else
                if isKey(obj.props_, 'central_user_id')
                    result = obj.props_('central_user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralUserId(obj, value)
            obj.props_('central_user_id') = value;
        end
        function result = get.centralRevision(obj)
            if ismethod(obj, 'get_centralRevision')
                result = obj.get_centralRevision();
            else
                if isKey(obj.props_, 'central_revision')
                    result = obj.props_('central_revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralRevision(obj, value)
            obj.props_('central_revision') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'email')
                result('email') = flywheel.ModelBase.serializeValue(obj.props_('email'), 'char');
            end
            if isKey(obj.props_, 'password')
                result('password') = flywheel.ModelBase.serializeValue(obj.props_('password'), 'char');
            end
            if isKey(obj.props_, 'roles')
                result('roles') = flywheel.ModelBase.cellmap(@toJson, obj.props_('roles'));
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'avatar')
                result('avatar') = flywheel.ModelBase.serializeValue(obj.props_('avatar'), 'char');
            end
            if isKey(obj.props_, 'root')
                result('root') = flywheel.ModelBase.serializeValue(obj.props_('root'), 'logical');
            end
            if isKey(obj.props_, 'central_user_id')
                result('central_user_id') = flywheel.ModelBase.serializeValue(obj.props_('central_user_id'), 'char');
            end
            if isKey(obj.props_, 'central_revision')
                result('central_revision') = flywheel.ModelBase.serializeValue(obj.props_('central_revision'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'email')
                result.email = obj.props_('email');
            else
                result.email = [];
            end
            if isKey(obj.props_, 'password')
                result.password = obj.props_('password');
            else
                result.password = [];
            end
            if isKey(obj.props_, 'roles')
                result.roles = flywheel.ModelBase.cellmap(@struct, obj.props_('roles'));
            else
                result.roles = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'avatar')
                result.avatar = obj.props_('avatar');
            else
                result.avatar = [];
            end
            if isKey(obj.props_, 'root')
                result.root = obj.props_('root');
            else
                result.root = [];
            end
            if isKey(obj.props_, 'central_user_id')
                result.centralUserId = obj.props_('central_user_id');
            else
                result.centralUserId = [];
            end
            if isKey(obj.props_, 'central_revision')
                result.centralRevision = obj.props_('central_revision');
            else
                result.centralRevision = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'email')
                    propList.email = obj.props_('email');
                else
                    propList.email = [];
                end
                if isKey(obj.props_, 'password')
                    propList.password = obj.props_('password');
                else
                    propList.password = [];
                end
                if isKey(obj.props_, 'roles')
                    propList.roles = obj.props_('roles');
                else
                    propList.roles = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'avatar')
                    propList.avatar = obj.props_('avatar');
                else
                    propList.avatar = [];
                end
                if isKey(obj.props_, 'root')
                    propList.root = obj.props_('root');
                else
                    propList.root = [];
                end
                if isKey(obj.props_, 'central_user_id')
                    propList.centralUserId = obj.props_('central_user_id');
                else
                    propList.centralUserId = [];
                end
                if isKey(obj.props_, 'central_revision')
                    propList.centralRevision = obj.props_('central_revision');
                else
                    propList.centralRevision = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.UserInput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'email')
                obj.props_('email') = flywheel.ModelBase.deserializeValue(json.email, 'char');
            end
            if isfield(json, 'password')
                obj.props_('password') = flywheel.ModelBase.deserializeValue(json.password, 'char');
            end
            if isfield(json, 'roles')
                obj.props_('roles') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RoleType.fromJson(x, context), json.roles);
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'avatar')
                obj.props_('avatar') = flywheel.ModelBase.deserializeValue(json.avatar, 'char');
            end
            if isfield(json, 'root')
                obj.props_('root') = flywheel.ModelBase.deserializeValue(json.root, 'logical');
            end
            if isfield(json, 'central_user_id')
                obj.props_('central_user_id') = flywheel.ModelBase.deserializeValue(json.central_user_id, 'char');
            end
            if isfield(json, 'central_revision')
                obj.props_('central_revision') = flywheel.ModelBase.deserializeValue(json.central_revision, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.UserInput')
                    obj = flywheel.model.UserInput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'email')
                end
                if isKey(obj.props_, 'password')
                end
                if isKey(obj.props_, 'roles')
                    obj.props_('roles') = flywheel.ModelBase.cellmap(@flywheel.model.RoleType.ensureIsInstance, obj.props_('roles'));
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'avatar')
                end
                if isKey(obj.props_, 'root')
                end
                if isKey(obj.props_, 'central_user_id')
                end
                if isKey(obj.props_, 'central_revision')
                end
            end
        end
    end
end
