% UserJobs
%
% UserJobs Properties:
%    total 
%    jobs  
%    stats 
%
% UserJobs Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef UserJobs < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'total', 'jobs', 'stats' }, ...
            { 'total', 'jobs', 'stats' });
    end
    properties(Dependent)
        total
        jobs
        stats
    end
    methods
        function obj = UserJobs(varargin)
            obj@flywheel.ModelBase(flywheel.model.UserJobs.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'total', []);
                addParameter(p, 'jobs', []);
                addParameter(p, 'stats', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.total)
                    obj.props_('total') = p.Results.total;
                end
                if ~isempty(p.Results.jobs)
                    obj.props_('jobs') = p.Results.jobs;
                end
                if ~isempty(p.Results.stats)
                    obj.props_('stats') = p.Results.stats;
                end
            end
        end
        function result = get.total(obj)
            if ismethod(obj, 'get_total')
                result = obj.get_total();
            else
                if isKey(obj.props_, 'total')
                    result = obj.props_('total');
                else
                    result = [];
                end
            end
        end
        function obj = set.total(obj, value)
            obj.props_('total') = value;
        end
        function result = get.jobs(obj)
            if ismethod(obj, 'get_jobs')
                result = obj.get_jobs();
            else
                if isKey(obj.props_, 'jobs')
                    result = obj.props_('jobs');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobs(obj, value)
            obj.props_('jobs') = value;
        end
        function result = get.stats(obj)
            if ismethod(obj, 'get_stats')
                result = obj.get_stats();
            else
                if isKey(obj.props_, 'stats')
                    result = obj.props_('stats');
                else
                    result = [];
                end
            end
        end
        function obj = set.stats(obj, value)
            obj.props_('stats') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'total')
                result('total') = flywheel.ModelBase.serializeValue(obj.props_('total'), 'integer');
            end
            if isKey(obj.props_, 'jobs')
                result('jobs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('jobs'));
            end
            if isKey(obj.props_, 'stats')
                result('stats') = obj.props_('stats').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'total')
                result.total = obj.props_('total');
            else
                result.total = [];
            end
            if isKey(obj.props_, 'jobs')
                result.jobs = flywheel.ModelBase.cellmap(@struct, obj.props_('jobs'));
            else
                result.jobs = [];
            end
            if isKey(obj.props_, 'stats')
                result.stats = struct(obj.props_('stats'));
            else
                result.stats = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'total')
                    propList.total = obj.props_('total');
                else
                    propList.total = [];
                end
                if isKey(obj.props_, 'jobs')
                    propList.jobs = obj.props_('jobs');
                else
                    propList.jobs = [];
                end
                if isKey(obj.props_, 'stats')
                    propList.stats = obj.props_('stats');
                else
                    propList.stats = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.UserJobs;
            if isfield(json, 'total')
                obj.props_('total') = flywheel.ModelBase.deserializeValue(json.total, 'integer');
            end
            if isfield(json, 'jobs')
                obj.props_('jobs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.Job.fromJson(x, context), json.jobs);
            end
            if isfield(json, 'stats')
                obj.props_('stats') = flywheel.model.JobsByState.fromJson(json.stats, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.UserJobs')
                    obj = flywheel.model.UserJobs(obj);
                end
                if isKey(obj.props_, 'total')
                end
                if isKey(obj.props_, 'jobs')
                    obj.props_('jobs') = flywheel.ModelBase.cellmap(@flywheel.model.Job.ensureIsInstance, obj.props_('jobs'));
                end
                if isKey(obj.props_, 'stats')
                    obj.props_('stats') =  flywheel.model.JobsByState.ensureIsInstance(obj.props_('stats'));
                end
            end
        end
    end
end
