% Version
%
% Version Properties:
%    id              
%    database         - Core database version
%    databaseTarget   - Core database target version
%    release          - Core release version
%    flywheelRelease  - Flywheel installer image tag as informed by the installation recipe.env
%    cliVersion       - Compatible CLI version for this server as informed by the installation recipe.env
%    appliedChecks   
%    appliedFixes     - Collection of applied database fixes
%
% Version Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Version < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'database', 'databaseTarget', 'release', 'flywheelRelease', 'cliVersion', 'appliedChecks', 'appliedFixes' }, ...
            { '_id', 'database', 'database_target', 'release', 'flywheel_release', 'cli_version', 'applied_checks', 'applied_fixes' });
    end
    properties(Dependent)
        id
        database
        databaseTarget
        release
        flywheelRelease
        cliVersion
        appliedChecks
        appliedFixes
    end
    methods
        function obj = Version(varargin)
            obj@flywheel.ModelBase(flywheel.model.Version.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'database', []);
                addParameter(p, 'databaseTarget', []);
                addParameter(p, 'release', &#x27;&#x27;);
                addParameter(p, 'flywheelRelease', &#x27;&#x27;);
                addParameter(p, 'cliVersion', &#x27;&#x27;);
                addParameter(p, 'appliedChecks', []);
                addParameter(p, 'appliedFixes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.database)
                    obj.props_('database') = p.Results.database;
                end
                if ~isempty(p.Results.databaseTarget)
                    obj.props_('database_target') = p.Results.databaseTarget;
                end
                if ~isempty(p.Results.release)
                    obj.props_('release') = p.Results.release;
                end
                if ~isempty(p.Results.flywheelRelease)
                    obj.props_('flywheel_release') = p.Results.flywheelRelease;
                end
                if ~isempty(p.Results.cliVersion)
                    obj.props_('cli_version') = p.Results.cliVersion;
                end
                if ~isempty(p.Results.appliedChecks)
                    obj.props_('applied_checks') = p.Results.appliedChecks;
                end
                if ~isempty(p.Results.appliedFixes)
                    obj.props_('applied_fixes') = p.Results.appliedFixes;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.database(obj)
            if ismethod(obj, 'get_database')
                result = obj.get_database();
            else
                if isKey(obj.props_, 'database')
                    result = obj.props_('database');
                else
                    result = [];
                end
            end
        end
        function obj = set.database(obj, value)
            obj.props_('database') = value;
        end
        function result = get.databaseTarget(obj)
            if ismethod(obj, 'get_databaseTarget')
                result = obj.get_databaseTarget();
            else
                if isKey(obj.props_, 'database_target')
                    result = obj.props_('database_target');
                else
                    result = [];
                end
            end
        end
        function obj = set.databaseTarget(obj, value)
            obj.props_('database_target') = value;
        end
        function result = get.release(obj)
            if ismethod(obj, 'get_release')
                result = obj.get_release();
            else
                if isKey(obj.props_, 'release')
                    result = obj.props_('release');
                else
                    result = [];
                end
            end
        end
        function obj = set.release(obj, value)
            obj.props_('release') = value;
        end
        function result = get.flywheelRelease(obj)
            if ismethod(obj, 'get_flywheelRelease')
                result = obj.get_flywheelRelease();
            else
                if isKey(obj.props_, 'flywheel_release')
                    result = obj.props_('flywheel_release');
                else
                    result = [];
                end
            end
        end
        function obj = set.flywheelRelease(obj, value)
            obj.props_('flywheel_release') = value;
        end
        function result = get.cliVersion(obj)
            if ismethod(obj, 'get_cliVersion')
                result = obj.get_cliVersion();
            else
                if isKey(obj.props_, 'cli_version')
                    result = obj.props_('cli_version');
                else
                    result = [];
                end
            end
        end
        function obj = set.cliVersion(obj, value)
            obj.props_('cli_version') = value;
        end
        function result = get.appliedChecks(obj)
            if ismethod(obj, 'get_appliedChecks')
                result = obj.get_appliedChecks();
            else
                if isKey(obj.props_, 'applied_checks')
                    result = obj.props_('applied_checks');
                else
                    result = [];
                end
            end
        end
        function obj = set.appliedChecks(obj, value)
            obj.props_('applied_checks') = value;
        end
        function result = get.appliedFixes(obj)
            if ismethod(obj, 'get_appliedFixes')
                result = obj.get_appliedFixes();
            else
                if isKey(obj.props_, 'applied_fixes')
                    result = obj.props_('applied_fixes');
                else
                    result = [];
                end
            end
        end
        function obj = set.appliedFixes(obj, value)
            obj.props_('applied_fixes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'database')
                result('database') = flywheel.ModelBase.serializeValue(obj.props_('database'), 'integer');
            end
            if isKey(obj.props_, 'database_target')
                result('database_target') = flywheel.ModelBase.serializeValue(obj.props_('database_target'), 'integer');
            end
            if isKey(obj.props_, 'release')
                result('release') = flywheel.ModelBase.serializeValue(obj.props_('release'), 'char');
            end
            if isKey(obj.props_, 'flywheel_release')
                result('flywheel_release') = flywheel.ModelBase.serializeValue(obj.props_('flywheel_release'), 'char');
            end
            if isKey(obj.props_, 'cli_version')
                result('cli_version') = flywheel.ModelBase.serializeValue(obj.props_('cli_version'), 'char');
            end
            if isKey(obj.props_, 'applied_checks')
                result('applied_checks') = flywheel.ModelBase.serializeValue(obj.props_('applied_checks'), 'containers.Map');
            end
            if isKey(obj.props_, 'applied_fixes')
                result('applied_fixes') = flywheel.ModelBase.serializeValue(obj.props_('applied_fixes'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'database')
                result.database = obj.props_('database');
            else
                result.database = [];
            end
            if isKey(obj.props_, 'database_target')
                result.databaseTarget = obj.props_('database_target');
            else
                result.databaseTarget = [];
            end
            if isKey(obj.props_, 'release')
                result.release = obj.props_('release');
            else
                result.release = [];
            end
            if isKey(obj.props_, 'flywheel_release')
                result.flywheelRelease = obj.props_('flywheel_release');
            else
                result.flywheelRelease = [];
            end
            if isKey(obj.props_, 'cli_version')
                result.cliVersion = obj.props_('cli_version');
            else
                result.cliVersion = [];
            end
            if isKey(obj.props_, 'applied_checks')
                result.appliedChecks = obj.props_('applied_checks');
            else
                result.appliedChecks = [];
            end
            if isKey(obj.props_, 'applied_fixes')
                result.appliedFixes = obj.props_('applied_fixes');
            else
                result.appliedFixes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'database')
                    propList.database = obj.props_('database');
                else
                    propList.database = [];
                end
                if isKey(obj.props_, 'database_target')
                    propList.databaseTarget = obj.props_('database_target');
                else
                    propList.databaseTarget = [];
                end
                if isKey(obj.props_, 'release')
                    propList.release = obj.props_('release');
                else
                    propList.release = [];
                end
                if isKey(obj.props_, 'flywheel_release')
                    propList.flywheelRelease = obj.props_('flywheel_release');
                else
                    propList.flywheelRelease = [];
                end
                if isKey(obj.props_, 'cli_version')
                    propList.cliVersion = obj.props_('cli_version');
                else
                    propList.cliVersion = [];
                end
                if isKey(obj.props_, 'applied_checks')
                    propList.appliedChecks = obj.props_('applied_checks');
                else
                    propList.appliedChecks = [];
                end
                if isKey(obj.props_, 'applied_fixes')
                    propList.appliedFixes = obj.props_('applied_fixes');
                else
                    propList.appliedFixes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Version;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'database')
                obj.props_('database') = flywheel.ModelBase.deserializeValue(json.database, 'integer');
            end
            if isfield(json, 'database_target')
                obj.props_('database_target') = flywheel.ModelBase.deserializeValue(json.database_target, 'integer');
            end
            if isfield(json, 'release')
                obj.props_('release') = flywheel.ModelBase.deserializeValue(json.release, 'char');
            end
            if isfield(json, 'flywheel_release')
                obj.props_('flywheel_release') = flywheel.ModelBase.deserializeValue(json.flywheel_release, 'char');
            end
            if isfield(json, 'cli_version')
                obj.props_('cli_version') = flywheel.ModelBase.deserializeValue(json.cli_version, 'char');
            end
            if isfield(json, 'applied_checks')
                obj.props_('applied_checks') = flywheel.ModelBase.deserializeValue(json.applied_checks, 'containers.Map');
            end
            if isfield(json, 'applied_fixes')
                obj.props_('applied_fixes') = flywheel.ModelBase.deserializeValue(json.applied_fixes, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Version')
                    obj = flywheel.model.Version(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'database')
                end
                if isKey(obj.props_, 'database_target')
                end
                if isKey(obj.props_, 'release')
                end
                if isKey(obj.props_, 'flywheel_release')
                end
                if isKey(obj.props_, 'cli_version')
                end
                if isKey(obj.props_, 'applied_checks')
                end
                if isKey(obj.props_, 'applied_fixes')
                end
            end
        end
    end
end
