% ViewerAppInput
%
% ViewerAppInput Properties:
%    id          
%    type        
%    name        
%    description 
%    url         
%    origin      
%    options     
%    files       
%    containers  
%
% ViewerAppInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ViewerAppInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'type', 'name', 'description', 'url', 'origin', 'options', 'files', 'containers' }, ...
            { 'id', 'type', 'name', 'description', 'url', 'origin', 'options', 'files', 'containers' });
    end
    properties(Dependent)
        id
        type
        name
        description
        url
        origin
        options
        files
        containers
    end
    methods
        function obj = ViewerAppInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ViewerAppInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'type', []);
                addParameter(p, 'name', []);
                addParameter(p, 'description', []);
                addParameter(p, 'url', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'options', []);
                addParameter(p, 'files', []);
                addParameter(p, 'containers', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.url)
                    obj.props_('url') = p.Results.url;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.options)
                    obj.props_('options') = p.Results.options;
                end
                if ~isempty(p.Results.files)
                    obj.props_('files') = p.Results.files;
                end
                if ~isempty(p.Results.containers)
                    obj.props_('containers') = p.Results.containers;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.url(obj)
            if ismethod(obj, 'get_url')
                result = obj.get_url();
            else
                if isKey(obj.props_, 'url')
                    result = obj.props_('url');
                else
                    result = [];
                end
            end
        end
        function obj = set.url(obj, value)
            obj.props_('url') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.options(obj)
            if ismethod(obj, 'get_options')
                result = obj.get_options();
            else
                if isKey(obj.props_, 'options')
                    result = obj.props_('options');
                else
                    result = [];
                end
            end
        end
        function obj = set.options(obj, value)
            obj.props_('options') = value;
        end
        function result = get.files(obj)
            if ismethod(obj, 'get_files')
                result = obj.get_files();
            else
                if isKey(obj.props_, 'files')
                    result = obj.props_('files');
                else
                    result = [];
                end
            end
        end
        function obj = set.files(obj, value)
            obj.props_('files') = value;
        end
        function result = get.containers(obj)
            if ismethod(obj, 'get_containers')
                result = obj.get_containers();
            else
                if isKey(obj.props_, 'containers')
                    result = obj.props_('containers');
                else
                    result = [];
                end
            end
        end
        function obj = set.containers(obj, value)
            obj.props_('containers') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = obj.props_('type').toJson();
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'url')
                result('url') = flywheel.ModelBase.serializeValue(obj.props_('url'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'options')
                result('options') = flywheel.ModelBase.serializeValue(obj.props_('options'), 'containers.Map');
            end
            if isKey(obj.props_, 'files')
                result('files') = flywheel.ModelBase.serializeValue(obj.props_('files'), 'containers.Map');
            end
            if isKey(obj.props_, 'containers')
                result('containers') = flywheel.ModelBase.serializeValue(obj.props_('containers'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'type')
                result.type = struct(obj.props_('type'));
            else
                result.type = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'url')
                result.url = obj.props_('url');
            else
                result.url = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'options')
                result.options = obj.props_('options');
            else
                result.options = [];
            end
            if isKey(obj.props_, 'files')
                result.files = obj.props_('files');
            else
                result.files = [];
            end
            if isKey(obj.props_, 'containers')
                result.containers = obj.props_('containers');
            else
                result.containers = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'url')
                    propList.url = obj.props_('url');
                else
                    propList.url = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'options')
                    propList.options = obj.props_('options');
                else
                    propList.options = [];
                end
                if isKey(obj.props_, 'files')
                    propList.files = obj.props_('files');
                else
                    propList.files = [];
                end
                if isKey(obj.props_, 'containers')
                    propList.containers = obj.props_('containers');
                else
                    propList.containers = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ViewerAppInput;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.model.ViewerAppType.fromJson(json.type, context);
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'url')
                obj.props_('url') = flywheel.ModelBase.deserializeValue(json.url, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'options')
                obj.props_('options') = flywheel.ModelBase.deserializeValue(json.options, 'containers.Map');
            end
            if isfield(json, 'files')
                obj.props_('files') = flywheel.ModelBase.deserializeValue(json.files, 'containers.Map');
            end
            if isfield(json, 'containers')
                obj.props_('containers') = flywheel.ModelBase.deserializeValue(json.containers, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ViewerAppInput')
                    obj = flywheel.model.ViewerAppInput(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'type')
                    obj.props_('type') =  flywheel.model.ViewerAppType.ensureIsInstance(obj.props_('type'));
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'url')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'options')
                end
                if isKey(obj.props_, 'files')
                end
                if isKey(obj.props_, 'containers')
                end
            end
        end
    end
end
