% ZipfileInfo
%
% ZipfileInfo Properties:
%    comment 
%    members 
%
% ZipfileInfo Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ZipfileInfo < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'comment', 'members' }, ...
            { 'comment', 'members' });
    end
    properties(Dependent)
        comment
        members
    end
    methods
        function obj = ZipfileInfo(varargin)
            obj@flywheel.ModelBase(flywheel.model.ZipfileInfo.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'comment', []);
                addParameter(p, 'members', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.comment)
                    obj.props_('comment') = p.Results.comment;
                end
                if ~isempty(p.Results.members)
                    obj.props_('members') = p.Results.members;
                end
            end
        end
        function result = get.comment(obj)
            if ismethod(obj, 'get_comment')
                result = obj.get_comment();
            else
                if isKey(obj.props_, 'comment')
                    result = obj.props_('comment');
                else
                    result = [];
                end
            end
        end
        function obj = set.comment(obj, value)
            obj.props_('comment') = value;
        end
        function result = get.members(obj)
            if ismethod(obj, 'get_members')
                result = obj.get_members();
            else
                if isKey(obj.props_, 'members')
                    result = obj.props_('members');
                else
                    result = [];
                end
            end
        end
        function obj = set.members(obj, value)
            obj.props_('members') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'comment')
                result('comment') = flywheel.ModelBase.serializeValue(obj.props_('comment'), 'vector');
            end
            if isKey(obj.props_, 'members')
                result('members') = flywheel.ModelBase.cellmap(@toJson, obj.props_('members'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'comment')
                result.comment = obj.props_('comment');
            else
                result.comment = [];
            end
            if isKey(obj.props_, 'members')
                result.members = flywheel.ModelBase.cellmap(@struct, obj.props_('members'));
            else
                result.members = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'comment')
                    propList.comment = obj.props_('comment');
                else
                    propList.comment = [];
                end
                if isKey(obj.props_, 'members')
                    propList.members = obj.props_('members');
                else
                    propList.members = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ZipfileInfo;
            if isfield(json, 'comment')
                obj.props_('comment') = flywheel.ModelBase.deserializeValue(json.comment, 'vector');
            end
            if isfield(json, 'members')
                obj.props_('members') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ZipfileMemberInfo.fromJson(x, context), json.members);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ZipfileInfo')
                    obj = flywheel.model.ZipfileInfo(obj);
                end
                if isKey(obj.props_, 'comment')
                end
                if isKey(obj.props_, 'members')
                    obj.props_('members') = flywheel.ModelBase.cellmap(@flywheel.model.ZipfileMemberInfo.ensureIsInstance, obj.props_('members'));
                end
            end
        end
    end
end
