% ZipfileMemberInfo
%
% ZipfileMemberInfo Properties:
%    path      
%    size      
%    timestamp 
%    comment   
%
% ZipfileMemberInfo Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ZipfileMemberInfo < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'path', 'size', 'timestamp', 'comment' }, ...
            { 'path', 'size', 'timestamp', 'comment' });
    end
    properties(Dependent)
        path
        size
        timestamp
        comment
    end
    methods
        function obj = ZipfileMemberInfo(varargin)
            obj@flywheel.ModelBase(flywheel.model.ZipfileMemberInfo.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'path', []);
                addParameter(p, 'size', []);
                addParameter(p, 'timestamp', []);
                addParameter(p, 'comment', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
                if ~isempty(p.Results.comment)
                    obj.props_('comment') = p.Results.comment;
                end
            end
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = get.comment(obj)
            if ismethod(obj, 'get_comment')
                result = obj.get_comment();
            else
                if isKey(obj.props_, 'comment')
                    result = obj.props_('comment');
                else
                    result = [];
                end
            end
        end
        function obj = set.comment(obj, value)
            obj.props_('comment') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
            if isKey(obj.props_, 'comment')
                result('comment') = flywheel.ModelBase.serializeValue(obj.props_('comment'), 'vector');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
            if isKey(obj.props_, 'comment')
                result.comment = obj.props_('comment');
            else
                result.comment = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                if isKey(obj.props_, 'comment')
                    propList.comment = obj.props_('comment');
                else
                    propList.comment = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ZipfileMemberInfo;
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isfield(json, 'comment')
                obj.props_('comment') = flywheel.ModelBase.deserializeValue(json.comment, 'vector');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ZipfileMemberInfo')
                    obj = flywheel.model.ZipfileMemberInfo(obj);
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'size')
                end
                if isKey(obj.props_, 'timestamp')
                end
                if isKey(obj.props_, 'comment')
                end
            end
        end
    end
end
