% ApiClient - Wrapper for RestClient that provides an interface for api calls.
%
% ApiClient Properties:
%   restClient - The rest client instance
%
% ApiClient Methods:
%   callApi - Invoke a REST API call using restClient
classdef ApiClient < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        restClient
        versionCheckFn
    end
    methods
        function obj = ApiClient(apiKey)
            io.flywheel.rest.RestClient.useCertFile(getenv('FW_SSL_CERT_FILE'));
            obj.restClient = io.flywheel.rest.RestClient.fromApiKey(apiKey);
            obj.versionCheckFn = [];
        end
        function setVersionCheckFn(obj, fn)
            obj.versionCheckFn = fn;
        end
        function resp = callApi(obj, method, path, pathParams, queryParams, headers, body, postParams, files)
            % Perform one-time version check
            if ~isempty(obj.versionCheckFn)
                versionCheck = obj.versionCheckFn;
                obj.versionCheckFn = [];
                versionCheck();
            end

            resp = obj.restClient.callApi(method, path, pathParams, queryParams, headers, body, postParams, files);
            statusCode = resp.getStatusCode();
            if statusCode < 200 || statusCode > 299
                reason = resp.getReasonPhrase().toCharArray';
                detail = flywheel.ApiClient.getResponseError(resp);
                if isempty(detail)
                    throw(MException('ApiClient:apiException', '(%d) Reason: %s', statusCode, reason));
                else
                    throw(MException('ApiClient:apiException', '(%d) Reason: %s\nDetail: %s', statusCode, reason, detail));
                end
            end
        end
    end
    methods(Static)
        function json = encodeJson(data)
            json = jsonio.jsonwrite(data, struct('ReplacementStyle', 'hex'));
        end
        function json = getResponseJson(resp)
            body = resp.getBodyAsString().toCharArray';
            json = jsonio.jsonread(body, struct('ReplacementStyle', 'hex'));
        end
        function result = getResponseError(resp)
            result = [];
            try
                data = flywheel.ApiClient.getResponseJson(resp);
                if isfield(data, 'message')
                    result = data.message;
                end
            catch
            end
        end
        function result = castParam(value, type)
            if strcmp(type, 'integer')
                result = int64(value);
            elseif strcmp(type, 'logical')
                result = logical(value);
            else
                result = value;
            end
        end
        function params = formatParamCollection(params, name, value, format)
            if iscell(value)
                if format == 'multi'
                    for val = value
                        params = [params, name, val];
                    end
                else
                    switch format
                        case 'ssv'
                            delimiter = ' ';
                        case 'tsv'
                            delimiter = '\t';
                        case 'pipes'
                            delimiter = '|';
                        otherwise
                            delimiter = ',';
                    end
                    params = [params, name, strjoin(value, delimiter)];
                end
            else
                params = [params, name, value];
            end
        end
    end
end
