% ModelBase - Base class for all API models
classdef ModelBase < handle & matlab.mixin.CustomDisplay
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        props_
        propMap_
    end
    methods
        function obj = ModelBase(propertyMap)
            obj.props_ = containers.Map;
            obj.propMap_ = propertyMap;
        end
        function sref = subsref(obj, s)
            if s(1).type == '.'
                sref = flywheel.ModelBase.recursiveRef(obj, s);
            else
                error('subsref', 'Not a supported subscripted reference')
            end
        end
        function obj = subsasgn(obj, s, val)
            if s(1).type == '.'
                obj = flywheel.ModelBase.recursiveAsgn(obj, s, val);
            else
                error('subsasgn', 'Not a supported subscripted reference')
            end
        end
    end
    methods(Hidden)
        function result = get(obj, name)
            if ~isempty(obj.propMap_) && isKey(obj.propMap_, name)
                propName = obj.propMap_(name);
            else
                propName = name;
            end

            if isKey(obj.props_, propName)
                result = obj.props_(propName);
            else
                result = [];
            end
        end
        function obj = set(obj, name, value)
            if ~isempty(obj.propMap_) && isKey(obj.propMap_, name)
                propName = obj.propMap_(name);
            else
                propName = name;
            end

            obj.props_(propName) = value;
        end
        function obj = remove(obj, name)
            if ~isempty(obj.propMap_) && isKey(obj.propMap_, name)
                propName = obj.propMap_(name);
            else
                propName = name;
            end

            if isKey(obj.props_, propName)
                remove(obj.props_, propName);
            end
        end
    end
    methods(Static)
        function result = deserializeValue(val, typename)
            if strcmp(typename, 'datetime')
                result = flywheel.ModelBase.deserializeDatetime(val);
            else
                result = val;
            end
        end
        function result = serializeValue(val, typename)
            if strcmp(typename, 'datetime')
                result = flywheel.ModelBase.serializeDatetime(val);
            else
                result = val;
            end
        end
        function result = deserializeDatetime(val)
            if isempty(val)
                result = val;
            elseif strfind(val, '.')
                % Date/time in milliseconds
                result = datetime(val, 'TimeZone', 'UTC', 'InputFormat', 'yyyy-MM-dd''T''HH:mm:ss.SSSSSSXXXXX');
            else
                % Date/time in seconds
                result = datetime(val, 'TimeZone', 'UTC', 'InputFormat', 'yyyy-MM-dd''T''HH:mm:ssXXXXX');
            end
        end
        function result = serializeDatetime(val)
            if isempty(val)
                result = val;
            else
                result = char(datetime(val, 'Format', 'yyyy-MM-dd''T''HH:mm:ss.SSSSSSXXXXX'));
            end
        end
        % TODO: Is there a better way to do this?
        function obj = recursiveAsgn(obj, s, val)
            if isempty(s)
                obj = val;
            else
                subs = s(1).subs;
                if s(1).type == '.'
                    if isa(obj, 'flywheel.ModelBase')
                        if isprop(obj, subs)
                            obj.(subs) = flywheel.ModelBase.recursiveAsgn(obj.(subs), s(2:end), val);
                        elseif isempty(obj.propMap_)
                            srest = s(2:end);
                            if isempty(srest)
                                obj.props_(subs) = val;
                            else
                                obj.props_(subs) = flywheel.ModelBase.recursiveAsgn(obj.props_(subs), s(2:end), val);
                            end
                        else
                            if isKey(obj.propMap_, subs)
                                propName = obj.propMap_(subs);
                                srest = s(2:end);
                                if isempty(srest)
                                    obj.props_(propName) = val;
                                else
                                    obj.props_(propName) = flywheel.ModelBase.recursiveAsgn(obj.props_(propName), s(2:end), val);
                                end
                            else
                                error('subsasgn', 'No property ' + subs + ' exists for class ' + class(obj));
                            end
                        end
                    else
                        srest = s(2:end);
                        if isempty(srest)
                            obj.(subs) = val;
                        else
                            obj.(subs) = flywheel.ModelBase.recursiveAsgn(obj.(subs), s(2:end), val);
                        end
                    end
                elseif s(1).type == '{}'
                    if length(subs) > 1
                        error('subsasgn', 'Not a supported subscript annotation')
                    end
                    obj{subs{1}} = flywheel.ModelBase.recursiveAsgn(obj{subs{1}}, s(2:end), val);
                else
                    for i = 1:length(subs)
                        obj(subs{i}) = flywheel.ModelBase.recursiveAsgn(obj(subs{i}), s(2:end), val);
                    end
                end
            end
        end
        function result = recursiveRef(obj, s)
            if isempty(s)
                result = obj;
            else
                subs = s(1).subs;
                if s(1).type == '.'
                    if isa(obj, 'flywheel.ModelBase')
                        if isprop(obj, subs)
                            result = flywheel.ModelBase.recursiveRef(obj.(subs), s(2:end));
                        elseif isempty(obj.propMap_)
                            if isKey(obj.props_, subs)
                                result = flywheel.ModelBase.recursiveRef(obj.props_(subs), s(2:end));
                            else
                                result = builtin('subsref', obj, s);
                            end
                        else
                            result = builtin('subsref', obj, s);
                        end
                    else
                        result = builtin('subsref', obj, s);
                    end
                elseif s(1).type == '{}'
                    if length(subs) > 1
                        error('subsref', 'Not a supported subscript annotation')
                    end
                    result = flywheel.ModelBase.recursiveRef(obj{subs{1}}, s(2:end));
                else
                    result = builtin('subsref', obj, s);
                end
            end
        end
        function result = cellmap(pred, list)
            if isstruct(list)
                result = arrayfun(pred, list, 'UniformOutput', false);
            elseif iscell(list)
                result = cellfun(pred, list, 'UniformOutput', false);
            elseif isempty(list)
                result = [];
            else
                result = { pred(list) };
            end
        end
    end
end
