#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include <features.h>

#define __printflike(__fmt, __varargs) __attribute__((__format__(__printf__, __fmt, __varargs)))
#define __scanflike(__fmt, __varargs) __attribute__((__format__(__scanf__, __fmt, __varargs)))

#define __NEED_FILE
#define __NEED___isoc_va_list
#define __NEED_size_t

#if defined(_POSIX_SOURCE) || defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE) || \
    defined(_GNU_SOURCE) || defined(_BSD_SOURCE)
#define __NEED_ssize_t
#define __NEED_off_t
#define __NEED_va_list
#endif

#include <bits/alltypes.h>
#include <bits/null.h>

#undef EOF
#define EOF (-1)

#undef SEEK_SET
#undef SEEK_CUR
#undef SEEK_END
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define _IOFBF 0
#define _IOLBF 1
#define _IONBF 2

#define BUFSIZ 1024
#define FILENAME_MAX 4096
#define FOPEN_MAX 1000
#define TMP_MAX 10000
#define L_tmpnam 20

typedef union _G_fpos64_t {
    char __opaque[16];
    double __align;
} fpos_t;

extern FILE* const stdin;
extern FILE* const stdout;
extern FILE* const stderr;

#define stdin (stdin)
#define stdout (stdout)
#define stderr (stderr)

FILE* fopen(const char* __restrict, const char* __restrict);
FILE* freopen(const char* __restrict, const char* __restrict, FILE* __restrict);
int fclose(FILE*);

int remove(const char*);
int rename(const char*, const char*);

int feof(FILE*);
int ferror(FILE*);
int fflush(FILE*);
void clearerr(FILE*);

int fseek(FILE*, long, int);
long ftell(FILE*);
void rewind(FILE*);

int fgetpos(FILE* __restrict, fpos_t* __restrict);
int fsetpos(FILE*, const fpos_t*);

size_t fread(void* __restrict, size_t, size_t, FILE* __restrict);
size_t fwrite(const void* __restrict, size_t, size_t, FILE* __restrict);

int fgetc(FILE*);
int getc(FILE*);
int getchar(void);
int ungetc(int, FILE*);

int fputc(int, FILE*);
int putc(int, FILE*);
int putchar(int);

char* fgets(char* __restrict, int, FILE* __restrict);
#if __STDC_VERSION__ < 201112L
char* gets(char*);
#endif

int fputs(const char* __restrict, FILE* __restrict);
int puts(const char*);

int printf(const char* __restrict, ...) __printflike(1, 2);
int fprintf(FILE* __restrict, const char* __restrict, ...) __printflike(2, 3);
int sprintf(char* __restrict, const char* __restrict, ...) __printflike(2, 3);
int snprintf(char* __restrict, size_t, const char* __restrict, ...) __printflike(3, 4);

int vprintf(const char* __restrict, __isoc_va_list) __printflike(1, 0);
int vfprintf(FILE* __restrict, const char* __restrict, __isoc_va_list) __printflike(2, 0);
int vsprintf(char* __restrict, const char* __restrict, __isoc_va_list) __printflike(2, 0);
int vsnprintf(char* __restrict, size_t, const char* __restrict, __isoc_va_list) __printflike(3, 0);

int scanf(const char* __restrict, ...) __scanflike(1, 2);
int fscanf(FILE* __restrict, const char* __restrict, ...) __scanflike(2, 3);
int sscanf(const char* __restrict, const char* __restrict, ...) __scanflike(2, 3);
int vscanf(const char* __restrict, __isoc_va_list) __scanflike(1, 0);
int vfscanf(FILE* __restrict, const char* __restrict, __isoc_va_list) __scanflike(2, 0);
int vsscanf(const char* __restrict, const char* __restrict, __isoc_va_list) __scanflike(2, 0);

void perror(const char*);

int setvbuf(FILE* __restrict, char* __restrict, int, size_t);
void setbuf(FILE* __restrict, char* __restrict);

char* tmpnam(char*);
FILE* tmpfile(void);

#if defined(_POSIX_SOURCE) || defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE) || \
    defined(_GNU_SOURCE) || defined(_BSD_SOURCE)
FILE* fmemopen(void* __restrict, size_t, const char* __restrict);
FILE* open_memstream(char**, size_t*);
FILE* fdopen(int, const char*);
FILE* popen(const char*, const char*);
int pclose(FILE*);
int fileno(FILE*);
int fseeko(FILE*, off_t, int);
off_t ftello(FILE*);
int dprintf(int, const char* __restrict, ...) __printflike(2, 3);
int vdprintf(int, const char* __restrict, __isoc_va_list) __printflike(2, 0);
void flockfile(FILE*);
int ftrylockfile(FILE*);
void funlockfile(FILE*);
int getc_unlocked(FILE*);
int getchar_unlocked(void);
int putc_unlocked(int, FILE*);
int putchar_unlocked(int);
ssize_t getdelim(char** __restrict, size_t* __restrict, int, FILE* __restrict);
ssize_t getline(char** __restrict, size_t* __restrict, FILE* __restrict);
int renameat(int, const char*, int, const char*);
char* ctermid(char*);
#define L_ctermid 20
#endif

#if defined(_XOPEN_SOURCE) || defined(_GNU_SOURCE) || defined(_BSD_SOURCE)
#define P_tmpdir "/tmp"
char* tempnam(const char*, const char*);
#endif

#if defined(_GNU_SOURCE) || defined(_BSD_SOURCE)
#define L_cuserid 20
char* cuserid(char*);
void setlinebuf(FILE*);
void setbuffer(FILE*, char*, size_t);
int fgetc_unlocked(FILE*);
int fputc_unlocked(int, FILE*);
int fflush_unlocked(FILE*);
size_t fread_unlocked(void*, size_t, size_t, FILE*);
size_t fwrite_unlocked(const void*, size_t, size_t, FILE*);
void clearerr_unlocked(FILE*);
int feof_unlocked(FILE*);
int ferror_unlocked(FILE*);
int fileno_unlocked(FILE*);
int getw(FILE*);
int putw(int, FILE*);
char* fgetln(FILE*, size_t*);
int asprintf(char**, const char*, ...) __printflike(2, 3);
int vasprintf(char**, const char*, __isoc_va_list) __printflike(2, 0);
#endif

#ifdef _GNU_SOURCE
char* fgets_unlocked(char*, int, FILE*);
int fputs_unlocked(const char*, FILE*);
#endif

#if defined(_LARGEFILE64_SOURCE) || defined(_GNU_SOURCE)
#define tmpfile64 tmpfile
#define fopen64 fopen
#define freopen64 freopen
#define fseeko64 fseeko
#define ftello64 ftello
#define fgetpos64 fgetpos
#define fsetpos64 fsetpos
#define fpos64_t fpos_t
#define off64_t off_t
#endif

#ifdef __cplusplus
}
#endif
