require(['zepto', 'i18next'], function(util) {

    var interest = {
        calculate: function(amt, rate, years) {
            var result = [{year: 0,
                           amount: amt}],
                year = 0;
            while ((result.length - 1) < years) {
                result.push({year: year += 1,
                             amount: Math.round((Math.pow((1 + rate/100), 1)
                                        * result[result.length-1].amount)
                                        * 100)/100});
            }
            result.reverse();
            return result;
        }
    };

    function commas(val) {
        return val.toString().replace(/(\d)(?=(\d{3})+(\.|$))/g, '\$1,');
    }

    function range(n) {
        var result = [];
        for (var i = 0; i < n; ++i ) {
            result.push(i);
        }
        return result;
    }

    $(document).ready(function() {
        $('form').on('submit', function(event) {
            $('input').each(function(i, value) {
                var $value = $(value);
                if ($value.val() % 1 != 0) {
                    $value.prev().addClass('error');
                    event.stopImmediatePropagation();
                } else {
                    $value.prev().removeClass('error');
                }
            });
            event.preventDefault();
        });
        $('form').on('submit', function(event) {
            $('table tbody tr').remove();
            $.each(interest.calculate(
                    $('input[name=amount]').val(),
                    $('input[name=rate]').val(),
                    $('input[name=years]').val()
                    ), function(i, e) {
                $('table tbody').append('<tr><td>' + (e.year || 'Start') + '</td>'
                                          + '<td>' + commas(e.amount) + '</td>'
                                          + '</tr>');
            });
            $('#input').hide();
            $('#results').show();
            event.preventDefault();
        });
        $('#back').on('click', function(event) {
            $('#input').show();
            $('#results').hide();
            $('table').addClass('truncated');
        });
        $('#expand').on('click', function(event) {
            $('table').removeClass('truncated');
        });

        var resources = {
          'fr': { translation: {
              'title': 'Intérêts Composés',
              'heading': 'Composés',
              'amount': 'Montant',
              'calculate': 'Calculer',
              'rate': 'Taux',
              'years': 'Ans',
              'year': 'Année',
              'expand': 'Étendre',
              'back': 'Arrière'
            }
          },
          'en': { translation: {
              'title': 'Compound Interest Calculator',
              'heading': 'Compound',
              'amount': 'Amount',
              'calculate': 'Calculate',
              'rate': 'Rate',
              'years': 'Years',
              'year': 'Year',
              'expand': 'Expand',
              'back': 'Back'
            }
          }
        };

        i18n.init({resStore: resources});
        i18n.setLng(window.navigator.language, function(){});
        $('.i18n').each(function(i, value) {
            var $value = $(value);
            $value.html(i18n.t($value.data('i18n')));
            $value.removeClass('i18n');
        });
    });
});
